#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2015.9.25
'''

from conf.constants import *

import json
from json import *
import atexit
import redis

# user defined

from viewer.user import *
import warnings

# from viewer.runData import *

from viewer.menuBar import *
from viewer.statusBar import *

from viewer.mainSet import *

from model import neonReceiver


class mywindow(QtGui.QMainWindow):

    def __init__(self):
        super(mywindow, self).__init__()
        self.setupUi(self)

    def setupUi(self, MainWindow):

        self.myMenuBar = menuBar(self)
        self.setMenuBar(self.myMenuBar)

        self.myStatusBar = statusBar(self)
        self.setStatusBar(self.myStatusBar)

        self.mainSplitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)

        self.userWidget = CSNSUserInfo(self)  # .mainSplitter)
        self.mainSetWidget = CSNSMainSetInfo(self)  # .mainSplitter)

        self.mainSplitter.addWidget(self.userWidget)  # leftSplitter)
        self.mainSplitter.addWidget(self.mainSetWidget)  # rightSplitter)

        self.setCentralWidget(self.mainSplitter)
        self.layout()

    # self.updateNeutronCounts()

    # test

        global CSNSThreadID
        CSNSThreadID += 1
        self.thread1 = updateCommand(CSNSThreadID, 'haha',
                self.getIP(), self.getPort())
        self.thread1.setDaemon(True)
        self.thread1.start()

    def updateDiffractionSimulator(self):
        self.upRightTab.updateDiffractionSimulator()

    def updateDataStreaming(self):
        self.upRightTab.updateDataStreaming()

    def updateProton(self, threadID):
        self.upRightTab.updateProton(threadID)

    # update Neutron Counts
    def updateNeutronCounts(self):
        ip = '10.1.53.240'

        # ip="127.0.0.1"

        port = 9000
        try:
            print '   NEON Starting...'
            r = redis.Redis(host=ip, port=port, db=0)
        except:
            print 'ERROR: Neon server not available.\n'
            sys.exit()

        neonpathx = '/GPPD/workspace/data/bank01/fit/axis_x_1'
        neonpathy = '/GPPD/workspace/data/bank01/fit/axis_y_1'
        neonpathz = '/GPPD/workspace/data/bank01/fit/value_2'
        neonpathc = '/GPPD/workspace/data/bank01/event'

        datasetThread = neonReceiver.dataGet(
            1,
            r,
            2,
            neonpathx,
            neonpathy,
            neonpathz,
            neonpathc,
            self.getCountsText(),
            self.getImageCanvas(),
            )
        datasetThread.setDaemon(True)
        datasetThread.start()
        time.sleep(0.01)

    # diffraction pattern
    def getPatternCanvas(self, n):
        return self.mainSetWidget.getPatternCanvas(n)

    # detector Counts
    def getBankCanvas(self):
        return self.mainSetWidget.getBankCanvas()

    # monitor Counts
    def getMonitorImageCanvas(self, n):
        return self.mainSetWidget.getMonitorImageCanvas(n)

    def getMonitorPatternCanvas(self, n):
        return self.mainSetWidget.getMonitorPatternCanvas(n)

    # experiment Progress
    def getProtonCanvas(self):
        return self.mainSetWidget.getProtonCanvas()

    def getNeutronCanvas(self):
        return self.mainSetWidget.getNeutronCanvas()

    def getPulseCanvas(self):
        return self.mainSetWidget.getPulseCanvas()

    def createTimeProgress(self, mini, maxi):
	return self.mainSetWidget.createTimeProgress(mini,maxi)

    # user info
    # Proton Charge Text
    def getChargeText(self):
        return self.userWidget.getChargeText()

    # Neutron Counts
    def getCountsText(self):
        return self.userWidget.getCountsText()

    def getUserIDText(self):
        return self.userWidget.getUserIDText()

    def getProposalText(self):
        return self.userWidget.getProposalText()

    def getCommandValueLabel(self):
        return self.userWidget.getCommandValueLabel()

    def getCommandTimeLabel(self):
        return self.userWidget.getCommandTimeLabel()

    def getStatusValueLabel(self):
        return self.userWidget.getStatusValueLabel()

    def getStatusTimeLabel(self):
        return self.userWidget.getStatusTimeLabel()

    def getIP(self):
        return self.myMenuBar.getIP()

    def getPort(self):
        return self.myMenuBar.getPort()

    def layout(self):
        if not os.path.exists('./dat/layout.json'):
            _f=open("./dat/layout.json", "w")
            _data = {"mainHeight": 618, "firstLayout": 1, "mainWidth": 1438}
            json.dump(_f, _data)
            _f.close()
        layoutParameter = json.loads(open('./dat/layout.json').read())
        layoutParameter_fout = open('./dat/layout.json', 'w')
        if layoutParameter['firstLayout'] == 0:
            self.resize(conf.constants.mainWidth, conf.constants.mainHeight)

            self.mainSplitter.setSizes([(conf.constants.mainWidth + 50) / 7, conf.constants.mainWidth / 7 * 6])

            layoutParameter['firstLayout'] = 1
            layoutParameter['mainWidth'] = conf.constants.mainWidth
            layoutParameter['mainHeight'] = conf.constants.mainHeight
        else:
            self.resize(layoutParameter['mainWidth'],
                        layoutParameter['mainHeight'])

            self.mainSplitter.setSizes([(layoutParameter['mainWidth'] + 50) / 7, layoutParameter['mainWidth'] / 7 * 6])

        layoutParameter_str = JSONEncoder().encode(layoutParameter)
        layoutParameter_json = JSONDecoder().decode(layoutParameter_str)
        json.dump(layoutParameter_json, layoutParameter_fout)
        layoutParameter_fout.close()

    def getWindowSize(self):
        if not os.path.exists('./dat/layout.json'):
            _f=open("./dat/layout.json", "w")
            _data = {"mainWidth": 1920, "firstLayout": 1, "mainHeight": 972}
            _f.close()

        layoutParameter = json.loads(open('./dat/layout.json').read())
        layoutParameter_fout = open('./dat/layout.json', 'w')
        conf.constants.mainWidth = self.mainSplitter.geometry().width()
        conf.constants.mainHeight = self.mainSplitter.geometry().height()
        layoutParameter['mainWidth'] = conf.constants.mainWidth
        layoutParameter['mainHeight'] = conf.constants.mainHeight + 38

        # layoutParameter_str=JSONEncoder().encode(layoutParameter)
        # layoutParameter_json=JSONDecoder().decode(layoutParameter_str)

        json.dump(layoutParameter, layoutParameter_fout)
        layoutParameter_fout.close()


def main():
    #warnings.filterwarnings("ignore")

    myapp = QtGui.QApplication(sys.argv)
    screen_resolution = myapp.desktop().screenGeometry()
    (conf.constants.mainWidth, conf.constants.mainHeight) = (screen_resolution.width(),
                           screen_resolution.height())
    conf.constants.mytop = mywindow()
    icon = QtGui.QIcon('img/logo.jpg')
    conf.constants.mytop.setWindowIcon(icon)
    conf.constants.mytop.setWindowTitle('GPPD')

    # mytop.resize(mainWidth, mainHeight)

    conf.constants.mytop.show()

    # excute before app exit

    atexit.register(exit_handler)
    sys.exit(myapp.exec_())


def exit_handler():
    conf.constants.mytop.getWindowSize()


if __name__ == '__main__':

    main()

