#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf.constants import *

from canvas import *
from model.readData import *
from model.readImage import *
from presenter.updateStreaming import *
from model.neonReceiver import *


class CSNSImagePage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSImagePage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        self.verticalLayout = QtGui.QHBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.verticalLayout.addWidget(self.scrollArea)
        # main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 9
        _ysize = 0.8

        # Backward TOF/d
        self.BankComboBox = QtGui.QComboBox()
        self.BankComboBox.addItem('0+1:Backward')
        self.BankComboBox.addItem('0:Left Backward')
        self.BankComboBox.addItem('1:Right Backward')
        self.BankComboBox.addItem('2+3:Medium-angle Bank')
        self.BankComboBox.addItem('2:Left Medium-angle')
        self.BankComboBox.addItem('3:Right Medium-angle')
        self.BankComboBox.addItem('4+5:Low-angle Bank')
        self.BankComboBox.addItem('4:Left Low-angle')
        self.BankComboBox.addItem('5:Right Low-angle')
        self.BankComboBox.activated.connect(self.BankComboboxChoose)

        self.startBankButton = QtGui.QPushButton('Start')
        self.startBankButton.clicked.connect(self.startBank)
        self.resumeBankButton = QtGui.QPushButton('Resume')
        self.resumeBankButton.clicked.connect(self.resumeBank)
        self.resumeBankButton.setEnabled(False)
        
        self.LoadButton = QtGui.QPushButton('Load')
        #self.LoadButton.clicked.connect(self.load_file)
        self.ExportButton = QtGui.QPushButton('Export')
        #self.ExportButton.clicked.connect(self.export_file)

        self.maskListWidget = QtGui.QListWidget(self)

        # self.maskListWidget.setMinimumWidth(70)
        # self.maskListWidget.setMaximumWidth(150)

        for i in range(100):
            _item = QtGui.QListWidgetItem(str(i), self.maskListWidget)

            # _item.setFlags(QtCore.Qt.ItemIsUserCheckable)

            _r = random.random()
            if _r < 0.22:
                _item.setCheckState(QtCore.Qt.Unchecked)
            else:
                _item.setCheckState(QtCore.Qt.Checked)
            self.maskListWidget.addItem(_item)

        self.BankCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'X /mm',
            'Y /mm',
            )

        _nline = 0
        self.mainGrid.addWidget(self.BankComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startBankButton, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.resumeBankButton, _nline, 2, 1, 1)
        self.mainGrid.addWidget(self.LoadButton, _nline, 4, 1, 1)
        self.mainGrid.addWidget(self.ExportButton, _nline, 5, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.BankCanvas, _nline, 0, 1, 4)
        self.mainGrid.addWidget(self.maskListWidget, _nline, 4, 1, 2)
      
        self.neonID = [
            '/BL01/BANK01/IMAGE',
            '/BL01/BANK03/IMAGE',
            '/BL01/BANK05/IMAGE',
            ]

        Backward3DStreaming = None
        Medium3DStreaming = None
        Small3DStreaming = None
        self.streaming = [
            Backward3DStreaming,
            Medium3DStreaming,
            Small3DStreaming,
            ]
        for i in range(3):
            self.streaming[i] = CSNSGlobal()

        Backward3DstreamingThread = None
        Medium3DstreamingThread = None
        Small3DstreamingThread = None
        self.streamingThread = [
            Backward3DstreamingThread,
            Medium3DstreamingThread,
            Small3DstreamingThread,
            ]

        Backward3DplotThread = None
        Medium3DplotThread = None
        Small3DplotThread = None
        self.plotThread = [
            Backward3DplotThread,
            Medium3DplotThread,
            Small3DplotThread,
            ]

        self.plotColor = [
            'Accent',
            'Spectral',
            'cool',
            ]

    def BankComboboxChoose(self):
        index = self.BankComboBox.currentIndex()
    
    def getBankID(self):
        return self.BankComboBox.currentIndex()

    def createStreamingThread(self, sourceID, bankID):
        global CSNSThreadID
        CSNSThreadID += 1

        if sourceID == 2:
            self.streamingThread[bankID] = diffractionSimulator(
                CSNSThreadID,
                3,
                './dat/gppd.dat',
                './dat/monitor.dat',
                1E6,
                1.0,
                self.streaming[bankID],
                )
        elif sourceID == 0:
            self.streamingThread[bankID] = neonReceiver(
                CSNSThreadID,
                self.getIP(),
                self.getPort(),
                self.neonID[bankID],
                1.0,
                self.streaming[bankID],
                )

        self.streamingThread[bankID].setDaemon(True)

    def createPlotThread(self, bankID):
        global CSNSThreadID
        CSNSThreadID += 1

        self.plotThread[bankID] = updateStreaming3D(CSNSThreadID,
                self.BankCanvas, self.BankCanvas.ax,
                self.plotColor[bankID], self.streaming[bankID])

        self.plotThread[bankID].setDaemon(True)

    def startBank(self):
        _bankID = self.getBankID()
        if self.startBankButton.text() == 'Start':
            self.createStreamingThread(self.getSource(), _bankID)
            self.createPlotThread(_bankID)

            self.streamingThread[_bankID].start()
            self.plotThread[_bankID].start()

            self.startBankButton.setText('Stop')
            self.resumeBankButton.setText('Pause')
            self.resumeBankButton.setEnabled(True)
        elif self.startBankButton.text() == 'Stop':

            self.plotThread[_bankID].stop()
            del self.plotThread[_bankID]
            self.streamingThread[_bankID].stop()
            del self.streamingThread[_bankID]

            self.startBankButton.setText('Start')
            self.resumeBankButton.setText('Resume')
            self.resumeBankButton.setEnabled(False)

    def resumeBank(self):
        _bankID = self.getBankID()
        if self.resumeBankButton.text() == 'Resume':
            self.plotThread[_bankID].resume()
            self.resumeBankButton.setText('Pause')
        elif self.resumeBankButton.text() == 'Pause':
            self.plotThread[_bankID].pause()
            self.resumeBankButton.setText('Resume')

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()

    def getSource(self):
        self.sourceID = 2
        return self.sourceID
