#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2015.9.25

Chopper
'''

from conf import *

# user defined

from model.readData import *
from model.chopperModel import *
from canvas import *

import random


class CSNSChopperPage(QtGui.QWidget):

    def __init__(self):
        super(CSNSChopperPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self, QWidget):
        self.horizontalLayout = QtGui.QHBoxLayout(self)

        # chopper tab control

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaLeft = QtGui.QScrollArea()
        self.scrollAreaLeft.setWidgetResizable(True)
        self.scrollAreaLeft.setWidget(self.first)

        # left grid

        self.mainGrid = QtGui.QGridLayout(self.first)

        # left grid label

        self.timeframeLabel = QtGui.QLabel('Time Frame')

        # canvas for time frame

        self.timeframeFigure = Figure(
            (8, 4),
            dpi=150,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=True,
            )
        self.timeframeCanvas = FigureCanvas(self.timeframeFigure)
        self.timeframeCanvas.setParent(self.first)
        self.timeframeAxes = self.timeframeFigure.add_subplot(111)

        # self.timeframeFigure.subplots_adjust(left=0.05,bottom=0.10,right=0.95,top=0.95)

        self.timeframeAxes.tick_params(axis='both', which='major',
                labelsize=5)
        self.timeframeAxes.set_xlabel('Time of Flight (ms)',
                fontsize=9, x=1, y=1)
        self.timeframeAxes.get_yaxis().set_visible(False)
        self.timeframeAxes.set_ylabel('Distance (m)', fontsize=5)
        self.timeframeCanvas.draw()

        # canvas for monitor 1

        self.monitor1Figure = Figure(
            (4, 4),
            dpi=150,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            tight_layout=False,
            )
        self.monitor1Canvas = FigureCanvas(self.monitor1Figure)
        self.monitor1Canvas.setParent(self.first)
        self.monitor1Axes = self.monitor1Figure.add_subplot(111)
        self.monitor1Axes.tick_params(axis='both', which='major',
                labelsize=5)
        self.monitor1Axes.set_xlim(0, 20)

        self.monitor1Axes.yaxis.set_major_formatter(ticker.FormatStrFormatter('%3.1E'
                ))
        (nmoderator, dataModerator) = CSNSRead2DData('./dat/DPHM.dat')
        wavemin = 1.0
        wavemax = 5.0
        imin = min(dataModerator[0], key=lambda x: abs(x - wavemin))
        imax = min(dataModerator[0], key=lambda x: abs(x - wavemax))
        imin = dataModerator[0].index(imin)
        imax = dataModerator[0].index(imax)
        self.monitor1Axes.plot(dataModerator[0],
                               np.array(dataModerator[1]) / 1E5,
                               color='red')
        self.monitor1Axes.vlines((dataModerator[0])[imin:imax], 0,
                                 np.array((dataModerator[1])[imin:imax])
                                 / 1E5, color='yellow')
        self.monitor1Figure.subplots_adjust(left=0.20, bottom=0.20,
                right=0.95, top=0.95)
        self.monitor1Axes.set_xlabel('(m)', fontsize=5)
        self.monitor1Axes.set_ylabel('(m)', fontsize=5)
        self.monitor1Canvas.draw()

        # canvas for monitor 2

        self.monitor2Canvas = CSNSCanvas(self, 4, 4)

        # read monitor data
        # self.monitor2Axes.yaxis.set_major_formatter(ticker.FormatStrFormatter('%3.1E'))

        (nmonitor, dataMonitor) = CSNSRead2DData('./dat/monitor.dat')
        self.monitor2Canvas.ax.plot(dataMonitor[0], dataMonitor[1],
                                    color='green', zorder=1)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.monitor2Canvas.ax.add_patch(self.rect)
        self.monitor2Canvas.fig.subplots_adjust(left=0.20, bottom=0.20,
                right=0.95, top=0.95)
        self.monitor2Canvas.ax.set_xlabel('(m)', fontsize=5)
        self.monitor2Canvas.ax.set_ylabel('(m)', fontsize=5)
        self.monitor2Canvas.draw()
        self.zoomEvents()

        self.mainGrid.addWidget(self.timeframeLabel, 0, 0, 1, 1)  # ,QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(
            self.timeframeCanvas,
            1,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(
            self.monitor1Canvas,
            2,
            0,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(
            self.monitor2Canvas,
            2,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        
        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaRight = QtGui.QScrollArea()
        self.scrollAreaRight.setWidgetResizable(True)
        self.scrollAreaRight.setWidget(self.second)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaRight1 = QtGui.QScrollArea()
        self.scrollAreaRight1.setWidgetResizable(True)
        self.scrollAreaRight1.setWidget(self.third)

        self.rightUpGrid = QtGui.QGridLayout(self.second)
        self.rightDownGrid = QtGui.QGridLayout(self.third)
        
        # Wavelenghth
        self.waveLengthLabel = QtGui.QLabel('<font color=red>Wavelength:</font>',self.second)
        self.minimunLabel = QtGui.QLabel('Minimum:',self.second)
        self.waveminTextEdit = QtGui.QTextEdit('0.1',self.second)
        self.waveminTextEdit.setReadOnly(True)
        self.waveminTextEdit.setMaximumHeight(CSNStextMaximumHeight)
        self.maximunLabel = QtGui.QLabel('Maximum:',self.second)
        self.wavemaxTextEdit = QtGui.QTextEdit('4.0',self.second)
        self.wavemaxTextEdit.setReadOnly(True)
        self.wavemaxTextEdit.setMaximumHeight(CSNStextMaximumHeight)
        
        self.cancelButton1 = QtGui.QPushButton('Reset', self.second)

        self.okButton1 = QtGui.QPushButton('OK', self.second)
        self.okButton1.clicked.connect(self.waveLength)

        # for DC1

        self.dc1Label = QtGui.QLabel('<font color=red>DC1</font>',
                self.third)

        self.dc1FrequencyLabel = QtGui.QLabel('Frequency', self.third)

        self.dc1FrequencyComboBox = QtGui.QComboBox(self.third)
        self.dc1FrequencyComboBox.addItem('25')
        self.dc1FrequencyComboBox.addItem('25/2')
        self.dc1FrequencyComboBox.addItem('25/3')
        self.dc1FrequencyComboBox.addItem('25/4')
        self.dc1FrequencyComboBox.addItem('25/5')
        self.dc1FrequencyComboBox.addItem('0')
        self.dc1FrequencyComboBox.setSizePolicy(QtGui.QSizePolicy.Expanding,
                QtGui.QSizePolicy.Fixed)

        self.dc1PhaseLabel = QtGui.QLabel('Phase', self.third)

        self.dc1PhaseSpinBox = QtGui.QSpinBox(self.third)
        self.dc1PhaseSpinBox.setRange(-360, 360)
        self.dc1PhaseSpinBox.setSingleStep(1)

        # for DC2

        self.dc2Label = QtGui.QLabel('<font color=red>DC2</font>',
                self.third)

        self.dc2FrequencyLabel = QtGui.QLabel('Frequency', self.third)

        self.dc2FrequencyComboBox = QtGui.QComboBox(self.third)
        self.dc2FrequencyComboBox.addItem('25')
        self.dc2FrequencyComboBox.addItem('25/2')
        self.dc2FrequencyComboBox.addItem('25/3')
        self.dc2FrequencyComboBox.addItem('25/4')
        self.dc2FrequencyComboBox.addItem('25/5')
        self.dc2FrequencyComboBox.addItem('0')

        self.dc2PhaseLabel = QtGui.QLabel('Phase', self.third)

        self.dc2PhaseSpinBox = QtGui.QSpinBox(self.third)
        self.dc2PhaseSpinBox.setRange(-360, 360)
        self.dc2PhaseSpinBox.setSingleStep(1)

        # for DC3

        self.dc3Label = QtGui.QLabel('<font color=red>DC3</font>',
                self.third)

        self.dc3FrequencyLabel = QtGui.QLabel('Frequency', self.third)

        self.dc3FrequencyComboBox = QtGui.QComboBox(self.third)
        self.dc3FrequencyComboBox.addItem('0')
        self.dc3FrequencyComboBox.addItem('25')
        self.dc3FrequencyComboBox.addItem('25/2')
        self.dc3FrequencyComboBox.addItem('25/3')
        self.dc3FrequencyComboBox.addItem('25/4')
        self.dc3FrequencyComboBox.addItem('25/5')

        self.dc3PhaseLabel = QtGui.QLabel('Phase', self.third)

        self.dc3PhaseSpinBox = QtGui.QSpinBox(self.third)
        self.dc3PhaseSpinBox.setRange(-360, 360)
        self.dc3PhaseSpinBox.setSingleStep(1)

        # for button

        self.cancelButton2 = QtGui.QPushButton('Reset', self.third)

        self.okButton2 = QtGui.QPushButton('OK', self.third)
        self.okButton2.clicked.connect(self.waveLength)

        nrow = -1
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.waveLengthLabel,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.minimunLabel,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.waveminTextEdit,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.maximunLabel,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.wavemaxTextEdit,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightUpGrid.addWidget(
            self.cancelButton1,
            nrow,
            0,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        self.rightUpGrid.addWidget(
            self.okButton1,
            nrow,
            1,
            1,
            2,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc1Label,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc1FrequencyLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc1FrequencyComboBox, nrow, 0, 1,
                                 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc1PhaseLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc1PhaseSpinBox, nrow, 0, 1, 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc2Label,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc2FrequencyLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc2FrequencyComboBox, nrow, 0, 1,
                                 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc2PhaseLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc2PhaseSpinBox, nrow, 0, 1, 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc3Label,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc3FrequencyLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc3FrequencyComboBox, nrow, 0, 1,
                                 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.dc3PhaseLabel,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addWidget(self.dc3PhaseSpinBox, nrow, 0, 1, 2)
        nrow = nrow + 1
        self.rightDownGrid.addWidget(
            self.cancelButton2,
            nrow,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.rightDownGrid.addWidget(
            self.okButton2,
            nrow,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        nrow = nrow + 1
        self.rightDownGrid.addItem(QtGui.QSpacerItem(-1, -1,
                               QtGui.QSizePolicy.Ignored,
                               QtGui.QSizePolicy.Expanding), nrow, 0)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal)
        self.splitterRight = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitterRight.addWidget(self.scrollAreaRight)
        self.splitterRight.addWidget(self.scrollAreaRight1)
        self.splitter.addWidget(self.scrollAreaLeft)
        self.splitter.addWidget(self.splitterRight)
        self.splitterRight.setSizes([200, 400])
        self.splitter.setSizes([550, 150])
        self.horizontalLayout.addWidget(self.splitter)

    def updateTimeFrame(
        self,
        pulseList,
        chopperList,
        timeList,
        xList,
        yList,
        ):

        self.timeframeAxes.clear()
        self.timeframeAxes.YTick = chopperList

        _x = pulseList[0] - (pulseList[1] - pulseList[0]) / 6.0
        self.timeframeAxes.text(_x, chopperList[1], 'DC1', fontsize=5)
        self.timeframeAxes.text(_x, chopperList[2], 'DC2', fontsize=5)
        self.timeframeAxes.text(_x, chopperList[3], 'DC3', fontsize=5)
        self.timeframeAxes.text(_x, chopperList[4], 'Sample',
                                fontsize=5)

        for i in range(1, len(timeList)):
            for j in range(0, len(timeList[i]), 2):
                self.timeframeAxes.plot((timeList[i][j], timeList[i][j
                        + 1]), (chopperList[i], chopperList[i]),
                        color='black')

        for i in range(0, len(xList)):
            _R = random.uniform(0, 1)
            _G = random.uniform(0, 1)
            _B = random.uniform(0, 1)
            self.timeframeAxes.plot(xList[i], yList, color=[_R, _G, _B])

        self.timeframeAxes.set_xlim((pulseList[0], pulseList[-1]))

        self.timeframeCanvas.draw()

    def zoomEvents(self):
        self.monitor2Canvas.mpl_connect('button_press_event',
                self.zoomFigurePress)
        self.monitor2Canvas.mpl_connect('button_release_event',
                self.zoomFigureRelease)
        self.monitor2Canvas.mpl_connect('motion_notify_event',
                self.zoomFigureMove)

    def zoomFigurePress(self, event):
        if event.button == 1:
            self.zoomClick = True
            self.x0 = event.xdata
            self.y0 = event.ydata
        elif event.button == 3:
            self.monitor2Canvas.ax.autoscale(enable=True)
            self.monitor2Canvas.draw()
        else:
            return

    def zoomFigureMove(self, event):
        if event.button == 1 and self.zoomClick == True and self.x0 \
            and self.y0 and event.xdata and event.ydata:

            self.rect.set_width(event.xdata - self.x0)
            self.rect.set_height(event.ydata - self.y0)
            self.rect.set_xy((self.x0, self.y0))
            self.monitor2Canvas.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick = False

        if event.button == 1 and self.x0 and self.y0 and event.xdata \
            and event.ydata:
            self.x1 = event.xdata
            self.y1 = event.ydata

            self.rect.set_width(0)
            self.rect.set_height(0)

            _min = min(self.x0, self.x1)
            _max = max(self.x0, self.x1)
            self.monitor2Canvas.ax.set_xlim(_min, _max)
            _min = min(self.y0, self.y1)
            _max = max(self.y0, self.y1)
            self.monitor2Canvas.ax.set_ylim(_min, _max)
            self.monitor2Canvas.draw()
        else:
            return

    def setWavelength(self):
        self.okButton1.clicked.connect(self.waveLength)
    def waveLength(self):
        print "ok"
        return
