#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
from presenter.updateStreaming import *
from model.neonReceiver import *

class CSNSHistogramPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSHistogramPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)
        self.BackwardConstant = 40000
        self.MediumConstant = 30000
        self.SmallConstant = 20000

        self.simulatorStreaming = CSNSGlobal()

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        self.verticalLayout = QtGui.QHBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)
        # main  grid

        self.mainGrid = QtGui.QGridLayout(self.first)
        
        _xsize = 9
        _ysize = 0.8

        # Backward TOF/d

        self.BackwardComboBox = QtGui.QComboBox()
        self.BackwardComboBox.addItem('TOF')
        self.BackwardComboBox.addItem('d')
        self.BackwardComboBox.activated.connect(self.BackwardComboboxChoose)

        self.startBackwardButton = QtGui.QPushButton('Start') 
        self.startBackwardButton.clicked.connect(self.startBackwardPattern)

        self.resumeBackwardButton = QtGui.QPushButton('Pause') 
        self.resumeBackwardButton.setEnabled(False)
        self.resumeBackwardButton.clicked.connect(self.resumeBackwardPattern)
        
        self.BackwardCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # 90-Bank TOF/d

        self.MediumComboBox = QtGui.QComboBox()
        self.MediumComboBox.addItem('TOF')
        self.MediumComboBox.addItem('d')
        self.MediumComboBox.activated.connect(self.MediumComboboxChoose)
        
        self.startMediumButton = QtGui.QPushButton('Start') 
        self.startMediumButton.clicked.connect(self.startMediumPattern)

        self.resumeMediumButton = QtGui.QPushButton('Pause') 
        self.resumeMediumButton.setEnabled(False)
        self.resumeMediumButton.clicked.connect(self.resumeMediumPattern)

        self.MediumCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small-angle bank TOF/d

        self.SmallComboBox = QtGui.QComboBox()
        self.SmallComboBox.addItem('TOF')
        self.SmallComboBox.addItem('d')
        self.SmallComboBox.activated.connect(self.SmallComboboxChoose)
        
        self.startSmallButton = QtGui.QPushButton('Start') 
        self.startSmallButton.clicked.connect(self.startSmallPattern)

        self.resumeSmallButton = QtGui.QPushButton('Pause') 
        self.resumeSmallButton.setEnabled(False)
        self.resumeSmallButton.clicked.connect(self.resumeSmallPattern)
        
        self.SmallCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Monitor TOF/d

        self.MonitorCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Backward bank 3D

        self.Backward3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Medium bank 3D

        self.Medium3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small bank 3D

        self.Small3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        _nline = 0
        self.mainGrid.addWidget(self.BackwardComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startBackwardButton, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.resumeBackwardButton, _nline, 2, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.BackwardCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MediumComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startMediumButton, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.resumeMediumButton, _nline, 2, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.MediumCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.SmallComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.startSmallButton, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.resumeSmallButton, _nline, 2, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.SmallCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MonitorCanvas, _nline, 0, 1, 2)
        self.mainGrid.addWidget(self.Backward3DCanvas, _nline, 2, 1, 2)
        self.mainGrid.addWidget(self.Medium3DCanvas, _nline, 4, 1, 2)
        self.mainGrid.addWidget(self.Small3DCanvas, _nline, 6, 1, 2)

        self.verticalLayout.addWidget(self.scrollArea)

    def BackwardComboboxChoose(self):
        index = self.BackwardComboBox.currentIndex()
        if index == 0:
            BackwardConstant = 40000    
        elif index == 1:
            BackwardConstant = 1
        self.BackwardThread.setUnit(BackwardConstant)

    def MediumComboboxChoose(self):
        index = self.MediumComboBox.currentIndex()
        if index == 0:
            MediumConstant = 30000       
        elif index == 1:
            MediumConstant = 1
        self.MediumThread.setUnit(MediumConstant)

    def SmallComboboxChoose(self):
        index = self.SmallComboBox.currentIndex()
        if index == 0:
            SmallConstant = 20000       
        elif index == 1:
            SmallConstant = 1
        self.SmallThread.setUnit(SmallConstant)
     
    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        self.BackwardThread = updateStreaming2D(threadID, self.BackwardCanvas, 
                self.BackwardCanvas.ax, CSNSBackwardConstant , 'r', 
                    simulatorStreaming)
        self.BackwardThread.setDaemon(True)
        self.BackwardThread.start()

    def updateMediumStreaming(self, threadID, simulatorStreaming):
        self.MediumThread = updateStreaming2D(threadID, self.MediumCanvas,
                self.MediumCanvas.ax,CSNSMediumConstant, 'g', simulatorStreaming)
        self.MediumThread.setDaemon(True)
        self.MediumThread.start()

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        self.SmallThread = updateStreaming2D(threadID, self.SmallCanvas,
                self.SmallCanvas.ax, CSNSSmallConstant,'b', simulatorStreaming)
        self.SmallThread.setDaemon(True)
        self.SmallThread.start()

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        MonitorThread = updateStreamingMonitor(threadID,
                self.MonitorCanvas, self.MonitorCanvas.ax, 'y',
                simulatorStreaming)
        MonitorThread.setDaemon(True)
        MonitorThread.start()
    
    def updateBackward3DStreaming(self, threadID, simulatorStreaming):
        Backward3DThread = updateStreaming3D(threadID,
                self.Backward3DCanvas, self.Backward3DCanvas.ax,
                'Accent', simulatorStreaming)
        Backward3DThread.setDaemon(True)
        Backward3DThread.start()

    def updateMedium3DStreaming(self, threadID, simulatorStreaming):
        Medium3DThread = updateStreaming3D(threadID,
                self.Medium3DCanvas, self.Medium3DCanvas.ax, 'Spectral'
                , simulatorStreaming)
        Medium3DThread.setDaemon(True)
        Medium3DThread.start()

    def updateSmall3DStreaming(self, threadID, simulatorStreaming):
        Small3DThread = updateStreaming3D(threadID, self.Small3DCanvas,
                self.Small3DCanvas.ax, 'cool', simulatorStreaming)
        Small3DThread.setDaemon(True)
        Small3DThread.start()

    def startBackwardPattern(self):
        if self.startBackwardButton.text()=="Start":
            if self.startBackwardPatternStreamingThread():
                    if self.startBackwardPatternPlotThread():
                        self.startBackwardButton.setText("Stop")
                        self.resumeBackwardButton.setEnabled(True)
                    else:
                        print "ERROR: BackwardPatternPlotThread cannot start."
            else:
                print "ERROR: BackwardPatternStreamingThread cannot start."
                
        elif self.startBackwardButton.text()=="Stop":
            try:
                self.BackwardPatternPlotThread.stop()
                del self.BackwardPatternPlotThread
                self.BackwardPatternStreamingThread.stop()
                del self.BackwardPatternStreamingThread
                self.startBackwardButton.setText("Start")
                self.resumeBackwardButton.setEnabled(False)
                print "INFO: BackwardPatternStreamingThread stopped."
            except:
                print "ERROR: BackwardPatternStreamingThread cannot stop."
    
    def resumeBackwardPattern(self):
        if self.resumeBackwardButton.text()=="Resume":
            if self.isBackwardPatternStreamingThread():
                    try:
                        self.BackwardPatternPlotThread.resume()
                        self.resumeBackwardButton.setText("Pause")
                    except:
                        print "ERROR: BackwardPatternPlotThread cannot start."
            else:
                    print "WARNING: BackwardPatternStreamingThread cannot start."
                
        elif self.resumeBackwardButton.text()=="Pause":
            if self.isBackwardPatternStreamingThread():
                try:
                    self.BackwardPatternPlotThread.pause()
                    self.resumeBackwardButton.setText("Resume")
                except:
                    print "ERROR: BackwardPatternPlotThread cannot start."
            else:
                print "WARNING: BackwardPatternStreamingThread cannot start."
   
    def startMediumPattern(self):
        if self.startMediumButton.text()=="Start":
            if self.startMediumPatternStreamingThread():
                    if self.startMediumPatternPlotThread():
                        self.startMediumButton.setText("Stop")
                        self.resumeMediumButton.setEnabled(True)
                    else:
                        print "ERROR: MediumPatternPlotThread cannot start."
            else:
                print "ERROR: MediumPatternStreamingThread cannot start."

        elif self.startMediumButton.text()=="Stop":
            try:
                self.MediumPatternPlotThread.stop()
                del self.MediumPatternPlotThread
                self.MediumPatternStreamingThread.stop()
                del self.MediumPatternStreamingThread
                self.startMediumButton.setText("Start")
                self.resumeMediumButton.setEnabled(False)
                print "INFO: MediumPatternStreamingThread stopped."
            except:
                print "ERROR: MediumPatternStreamingThread cannot stop."

    def resumeMediumPattern(self):
        if self.resumeMediumButton.text()=="Resume":
            if self.isMediumPatternStreamingThread():
                    try:
                        self.MediumPatternPlotThread.resume()
                        self.resumeMediumButton.setText("Pause")
                    except:
                        print "ERROR: MediumPatternPlotThread cannot start."
            else:
                    print "WARNING: MediumPatternStreamingThread cannot start."

        elif self.resumeMediumButton.text()=="Pause":
            if self.isMediumPatternStreamingThread():
                try:
                    self.MediumPatternPlotThread.pause()
                    self.resumeMediumButton.setText("Resume")
                except:
                    print "ERROR: MediumPatternPlotThread cannot start."
            else:
                print "WARNING: MediumPatternStreamingThread cannot start."
 
    def startSmallPattern(self):
        if self.startSmallButton.text()=="Start":
            if self.startSmallPatternStreamingThread():
                    if self.startSmallPatternPlotThread():
                        self.startSmallButton.setText("Stop")
                        self.resumeSmallButton.setEnabled(True)
                    else:
                        print "ERROR: SmallPatternPlotThread cannot start."
            else:
                print "ERROR: SmallPatternStreamingThread cannot start."

        elif self.startSmallButton.text()=="Stop":
            try:
                self.SmallPatternPlotThread.stop()
                del self.SmallPatternPlotThread
                self.SmallPatternStreamingThread.stop()
                del self.SmallPatternStreamingThread
                self.startSmallButton.setText("Start")
                self.resumeSmallButton.setEnabled(False)
                print "INFO: SmallPatternStreamingThread stopped."
            except:
                print "ERROR: SmallPatternStreamingThread cannot stop."

    def resumeSmallPattern(self):
        if self.resumeSmallButton.text()=="Resume":
            if self.isSmallPatternStreamingThread():
                    try:
                        self.SmallPatternPlotThread.resume()
                        self.resumeSmallButton.setText("Pause")
                    except:
                        print "ERROR: SmallPatternPlotThread cannot start."
            else:
                    print "WARNING: SmallPatternStreamingThread cannot start."

        elif self.resumeSmallButton.text()=="Pause":
            if self.isSmallPatternStreamingThread():
                try:
                    self.SmallPatternPlotThread.pause()
                    self.resumeSmallButton.setText("Resume")
                except:
                    print "ERROR: SmallPatternPlotThread cannot start."
            else:
                print "WARNING: SmallPatternStreamingThread cannot start."
    def putPulse(self):
        self.simulatorStreaming = CSNSGlobal()

        global CSNSThreadID
        CSNSThreadID += 1

        self.putThread = diffractionSimulator(
            CSNSThreadID,
            3,
            './dat/gppd.dat',
            './dat/monitor.dat',
            1E6,
            1.0,
            self.simulatorStreaming,
            )
        self.putThread.setDaemon(True)
        self.putThread.start()

    def getPulse(self):
        global CSNSThreadID

        CSNSThreadID += 1
        self.updateBackwardStreaming(CSNSThreadID,
                self.simulatorStreaming)
        
        CSNSThreadID += 1
        self.updateMediumStreaming(CSNSThreadID,
                self.simulatorStreaming)

        CSNSThreadID += 1
        self.updateSmallStreaming(CSNSThreadID,
                self.simulatorStreaming)
        
        CSNSThreadID += 1
        self.updateMonitorStreaming(CSNSThreadID,
                self.simulatorStreaming)
    
        CSNSThreadID += 1
        self.updateBackward3DStreaming(CSNSThreadID,
                self.simulatorStreaming)
        
        CSNSThreadID += 1
        self.updateMedium3DStreaming(CSNSThreadID,
                self.simulatorStreaming)
        
        CSNSThreadID += 1
        self.updateSmall3DStreaming(CSNSThreadID,
                self.simulatorStreaming)

    def startDiffractionSimulator(self):
        self.putPulse()
        #yield
        self.getPulse()
        self.enablePauseButton(True)

    def putDataStreaming(self):
        self.simulatorStreaming = CSNSGlobal()

        global CSNSThreadID
        CSNSThreadID += 1

        self.putBackwardThread = neonReceiver(
            CSNSThreadID, '192.168.1.12', 9999, 0, 1.0, self.simulatorStreaming)
    
        self.putBackwardThread.setDaemon(True)
        self.putBackwardThread.start()

# Create and Start Backward Pattern Streaming Thread
    def startBackwardPatternStreamingThread(self):
        _IP=self.getIP()
        _Port=self.getPort()
        print self.getIP(), self.getPort()
        if isNeonConnector(_IP, _Port):
            self.BackwardPatternStreaming = CSNSGlobal()
            global CSNSThreadID
            CSNSThreadID += 1

            self.BackwardPatternStreamingThread = neonReceiver(
                CSNSThreadID, self.getIP(), self.getPort(), '/BL01/BANK01/PATTERN',  1.0, self.BackwardPatternStreaming)

            self.BackwardPatternStreamingThread.setDaemon(True)
            self.BackwardPatternStreamingThread.start()
            
            print "INFO: Backward Streaming connected."
            return True
        else:
            print "WARNING: Backward Streaming not connected."
            return False
    
    def startBackwardPatternPlotThread(self):
        try:
            global CSNSThreadID
            CSNSThreadID += 1

            self.BackwardPatternPlotThread = updateStreaming2D(CSNSThreadID, self.BackwardCanvas,
                self.BackwardCanvas.ax, CSNSBackwardConstant , 'r',
                self.BackwardPatternStreaming)

            self.BackwardPatternPlotThread.setDaemon(True)
            self.BackwardPatternPlotThread.start()
            print "INFO: BackwardPatternPlotThread started."
        except:
            print "ERROR: BackwardPatternPlotThread cannot start."
            return False

        return True

    def isBackwardPatternStreamingThread(self):
        try:
            self.BackwardPatternStreamingThread
            return True
        except:
            return False
            
    def isBackwardPatternPlotThread(self):
        try:
            self.BackwardPatternPlotThread
            return True
        except:
            return False

# Create and Start Medium Pattern Streaming Thread
    def startMediumPatternStreamingThread(self):
        try:
            self.MediumPatternStreaming = CSNSGlobal()
            global CSNSThreadID
            CSNSThreadID += 1

            self.MediumPatternStreamingThread = neonReceiver(
                CSNSThreadID, self.getIP(), self.getPort(), '/BL01/BANK03/PATTERN', 1.0, self.MediumPatternStreaming)

            self.MediumPatternStreamingThread.setDaemon(True)
            self.MediumPatternStreamingThread.start()
        except:
            return False

        return True

    def startMediumPatternPlotThread(self):
        try:
            global CSNSThreadID
            CSNSThreadID += 1

            self.MediumPatternPlotThread = updateStreaming2D(CSNSThreadID, self.MediumCanvas,
                self.MediumCanvas.ax, CSNSMediumConstant , 'g',
                self.MediumPatternStreaming)

            self.MediumPatternPlotThread.setDaemon(True)
            self.MediumPatternPlotThread.start()
            print "INFO: MediumPatternPlotThread started."
        except:
            print "ERROR: MediumPatternPlotThread cannot start."
            return False

        return True

    def isMediumPatternStreamingThread(self):
        try:
            self.MediumPatternStreamingThread
            return True
        except:
            return False
            
    def isMediumPatternPlotThread(self):
        try:
            self.MediumPatternPlotThread
            return True
        except:
            return False

# Create and Start Small Pattern Streaming Thread
    def startSmallPatternStreamingThread(self):
        try:
            self.SmallPatternStreaming = CSNSGlobal()
            global CSNSThreadID
            CSNSThreadID += 1

            self.SmallPatternStreamingThread = neonReceiver(
                CSNSThreadID, self.getIP(), self.getPort(), '/BL01/BANK05/PATTERN', 1.0, self.SmallPatternStreaming)

            self.SmallPatternStreamingThread.setDaemon(True)
            self.SmallPatternStreamingThread.start()
        except:
            return False

        return True

    def startSmallPatternPlotThread(self):
        try:
            global CSNSThreadID
            CSNSThreadID += 1

            self.SmallPatternPlotThread = updateStreaming2D(CSNSThreadID, self.SmallCanvas,
                self.SmallCanvas.ax, CSNSSmallConstant , 'b',
                self.SmallPatternStreaming)

            self.SmallPatternPlotThread.setDaemon(True)
            self.SmallPatternPlotThread.start()
            print "INFO: SmallPatternPlotThread started."
        except:
            print "ERROR: SmallPatternPlotThread cannot start."
            return False

        return True

    def isSmallPatternStreamingThread(self):
        try:
            self.SmallPatternStreamingThread
            return True
        except:
            return False
            
    def isSmallPatternPlotThread(self):
        try:
            self.SmallPatternPlotThread
            return True
        except:
            return False

    def getDataStreaming(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.updateBackwardStreaming(CSNSThreadID,
                self.simulatorStreaming)

    def startDataStreaming(self):
        self.putDataStreaming()        
        self.getDataStreaming()        
        self.enablePauseButton(True)

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()
