#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2015.9.25
'''

from conf import *
import json
from json import *
import atexit
# user defined

from viewer.runList import *
from viewer.runData import *
from viewer.mainTab import *
from viewer.subTab import *
from viewer.menuBar import *
from viewer.statusBar import *

import atexit

class mywindow(QtGui.QMainWindow):

    def __init__(self):
        super(mywindow, self).__init__()
        self.setupUi(self)

    def setupUi(self, MainWindow):

        self.myMenuBar = menuBar(self)
        self.setMenuBar(self.myMenuBar)

        self.myStatusBar = statusBar(self)
        self.setStatusBar(self.myStatusBar)

        self.mainSplitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)

        self.leftSplitter = QtGui.QSplitter(QtCore.Qt.Vertical, self)
        self.rightSplitter = QtGui.QSplitter(QtCore.Qt.Vertical, self)

        self.upLeftListWidget = CSNSRunList(self.leftSplitter)
        self.downLeftFigure = CSNSRunData(self.leftSplitter)
        
        #self.upRightTab = CSNSMainTab(self.rightSplitter)
        #self.downRightTab = CSNSSubTab(self.rightSplitter)
        self.upRightTab = CSNSMainTab(self)
        self.downRightTab = CSNSSubTab(self)

        self.leftSplitter.addWidget(self.upLeftListWidget)
        self.leftSplitter.addWidget(self.downLeftFigure)
        self.rightSplitter.addWidget(self.upRightTab)
        self.rightSplitter.addWidget(self.downRightTab)
        self.mainSplitter.addWidget(self.leftSplitter)
        self.mainSplitter.addWidget(self.rightSplitter)

        self.setCentralWidget(self.mainSplitter) 
        self.layout()      
 
    def layout(self):
        layoutParameter = json.loads(open("./dat/layout.json").read())
        layoutParameter_fout = open("./dat/layout.json",'w')
        if layoutParameter["firstLayout"]==0:
            global mainWidth, mainHeight    
            self.resize(mainWidth, mainHeight)
            
            self.mainSplitter.setSizes([mainWidth/7, mainWidth/7*6])
            self.leftSplitter.setSizes([mainHeight/7*5, mainHeight/7*2])
            self.rightSplitter.setSizes([mainHeight/7*6, mainHeight/7])
            
            layoutParameter["firstLayout"]=1
            layoutParameter["mainWidth"]=mainWidth
            layoutParameter["mainHeight"]=mainHeight
        else:
            self.resize(layoutParameter["mainWidth"],layoutParameter["mainHeight"])
            
            self.mainSplitter.setSizes([layoutParameter["mainWidth"]/7, layoutParameter["mainWidth"]/7*6])
            self.leftSplitter.setSizes([layoutParameter["mainHeight"]/7*5, layoutParameter["mainHeight"]/7*2])
            self.rightSplitter.setSizes([layoutParameter["mainHeight"]/7*6, layoutParameter["mainHeight"]/7])

        layoutParameter_str=JSONEncoder().encode(layoutParameter)
        layoutParameter_json=JSONDecoder().decode(layoutParameter_str)
        json.dump(layoutParameter_json,layoutParameter_fout)
        layoutParameter_fout.close()

    def getWindowSize(self):
        layoutParameter = json.loads(open("./dat/layout.json").read())
        layoutParameter_fout = open("./dat/layout.json",'w')
        mainWidth=self.mainSplitter.geometry().width()
        mainHeight=self.mainSplitter.geometry().height()
        layoutParameter["mainWidth"]=mainWidth
        layoutParameter["mainHeight"]=mainHeight+38
        
        #layoutParameter_str=JSONEncoder().encode(layoutParameter)
        #layoutParameter_json=JSONDecoder().decode(layoutParameter_str)
        json.dump(layoutParameter,layoutParameter_fout)
        layoutParameter_fout.close()  
        
    def updateDiffractionSimulator(self):
        self.upRightTab.updateDiffractionSimulator()

    def updateDataStreaming(self):
        self.upRightTab.updateDataStreaming()

    def updateProton(self, threadID):
        self.upRightTab.updateProton(threadID)

    def getIP(self):
        return self.myMenuBar.getIP()

    def getPort(self):
        return self.myMenuBar.getPort()

myapp = QtGui.QApplication(sys.argv)
global mainWidth, mainHeight 
screen_resolution = myapp.desktop().screenGeometry()
mainWidth, mainHeight = screen_resolution.width(), screen_resolution.height() 
mytop = mywindow()

def main():
    icon = QtGui.QIcon("img/logo.jpg")
    mytop.setWindowIcon(icon)
    mytop.setWindowTitle('GPPD')

    #mytop.resize(mainWidth, mainHeight)
    mytop.show()
    
    # excute before app exit
    atexit.register(exit_handler)
    sys.exit(myapp.exec_())

def exit_handler():
    mytop.getWindowSize()

if __name__ == '__main__':

    main()

