#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2017.05.15

Detector
'''
from conf.constants import *

# user defined

from model.readData import *
from canvas import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *

class CSNSDetectorPage(QtGui.QTabWidget):#QMainWindow):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([100, 200])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
	
        #first Grid
        _width = 15
        _height = 15
        self.button131 = BankButton(self,'img/module_off.png', _width, _height)
        self.button132 = BankButton(self,'img/module_off.png', _width, _height)
        self.button133 = BankButton(self,'img/module_off.png', _width, _height)
        
        self.button231 = BankButton(self,'img/module_off.png', _width, _height)
        self.button232 = BankButton(self,'img/module_off.png', _width, _height)
        self.button233 = BankButton(self,'img/module_off.png', _width, _height)
        
        self.button322 = BankButton(self,'img/module_off.png', _width, _height)
        self.button331 = BankButton(self,'img/module_off.png', _width, _height)
        self.button332 = BankButton(self,'img/module_off.png', _width, _height)
        self.button333 = BankButton(self,'img/module_off.png', _width, _height)
        self.button341 = BankButton(self,'img/module_off.png', _width, _height)
        self.button342 = BankButton(self,'img/module_off.png', _width, _height)
        self.button343 = BankButton(self,'img/module_off.png', _width, _height)
        
        self.button422 = BankButton(self,'img/module_off.png', _width, _height)
        self.button431 = BankButton(self,'img/module_off.png', _width, _height)
        self.button432 = BankButton(self,'img/module_off.png', _width, _height)
        self.button433 = BankButton(self,'img/module_off.png', _width, _height)
        self.button441 = BankButton(self,'img/module_off.png', _width, _height)
        self.button442 = BankButton(self,'img/module_off.png', _width, _height)
        self.button443 = BankButton(self,'img/module_off.png', _width, _height)
        
        self.button521 = BankButton(self,'img/module_off.png', _width, _height)
        self.button522 = BankButton(self,'img/module_off.png', _width, _height)
        self.button523 = BankButton(self,'img/module_off.png', _width, _height)
        self.button531 = BankButton(self,'img/module_off.png', _width, _height)
        self.button532 = BankButton(self,'img/module_off.png', _width, _height)
        self.button533 = BankButton(self,'img/module_off.png', _width, _height)
        self.button541 = BankButton(self,'img/module_off.png', _width, _height)
        self.button542 = BankButton(self,'img/module_off.png', _width, _height)
        self.button543 = BankButton(self,'img/module_off.png', _width, _height)
        
        self.button621 = BankButton(self,'img/module_off.png', _width, _height)
        self.button622 = BankButton(self,'img/module_off.png', _width, _height)
        self.button623 = BankButton(self,'img/module_off.png', _width, _height)
        self.button631 = BankButton(self,'img/module_off.png', _width, _height)
        self.button632 = BankButton(self,'img/module_off.png', _width, _height)
        self.button633 = BankButton(self,'img/module_off.png', _width, _height)
        self.button641 = BankButton(self,'img/module_off.png', _width, _height)
        self.button642 = BankButton(self,'img/module_off.png', _width, _height)
        self.button643 = BankButton(self,'img/module_off.png', _width, _height)
        '''
        self.bank01 = BankButton(self,'img/bank1_off.png', _width, _height+45)
        self.bank02 = BankButton(self,'img/bank2_off.png', _width, _height+45)

        self.bank03 = BankButton(self,'img/bank3_off.png', _width+55, _height)
        self.bank04 = BankButton(self,'img/bank4_off.png', _width+55, _height)
        self.bank05 = BankButton(self,'img/bank5_off.png', _width+45, _height+40)
        self.bank06 = BankButton(self,'img/bank6_off.png', _width+45, _height+40)
        '''
        
        self.camera = BankButton(self,'img/camera.png', _width, _height)
        self.sample = BankButton(self,'img/sample.png', _width, _height)
        self.monitor = BankButton(self,'img/monitor.png', _width, _height)
        
        self.blank5 = BankButton(self,'blank.png', _width, _height)
        self.blank9 = BankButton(self,'blank.png', _width, _height)
	
        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.button131)
        self.RadioGroup.addButton(self.button132)
        self.RadioGroup.addButton(self.button133)
        self.RadioGroup.addButton(self.button231)
        self.RadioGroup.addButton(self.button232)
        self.RadioGroup.addButton(self.button233)
        
        self.RadioGroup.addButton(self.button322)
        self.RadioGroup.addButton(self.button331)
        self.RadioGroup.addButton(self.button332)
        self.RadioGroup.addButton(self.button333)
        self.RadioGroup.addButton(self.button341)
        self.RadioGroup.addButton(self.button342)
        self.RadioGroup.addButton(self.button343)
        
        self.RadioGroup.addButton(self.button422)
        self.RadioGroup.addButton(self.button431)
        self.RadioGroup.addButton(self.button432)
        self.RadioGroup.addButton(self.button433)
        self.RadioGroup.addButton(self.button441)
        self.RadioGroup.addButton(self.button442)
        self.RadioGroup.addButton(self.button443)
        
        self.RadioGroup.addButton(self.button521)
        self.RadioGroup.addButton(self.button522)
        self.RadioGroup.addButton(self.button523)
        self.RadioGroup.addButton(self.button531)
        self.RadioGroup.addButton(self.button532)
        self.RadioGroup.addButton(self.button533)
        self.RadioGroup.addButton(self.button541)
        self.RadioGroup.addButton(self.button542)
        self.RadioGroup.addButton(self.button543)
        
        self.RadioGroup.addButton(self.button621)
        self.RadioGroup.addButton(self.button622)
        self.RadioGroup.addButton(self.button623)
        self.RadioGroup.addButton(self.button631)
        self.RadioGroup.addButton(self.button632)
        self.RadioGroup.addButton(self.button633)
        self.RadioGroup.addButton(self.button641)
        self.RadioGroup.addButton(self.button642)
        self.RadioGroup.addButton(self.button643)
        self.RadioGroup.buttonClicked.connect(self.buttonClicked)

        self.blank1 = QtGui.QLabel("                               ---------------------------------------------->", self.first)
        self.blank1.setMinimumWidth(460)
        self.blank2 = QtGui.QLabel(self.first)
        self.blank2.setMinimumWidth(460)
	
        #second Grid
        self.bankCombo = QtGui.QComboBox()
        self.bankCombo.addItem('PID')
        self.bankCombo.addItem('XY')
        self.bankCombo.activated.connect(self.comboSelected)

        _xsize = 16#6
        _ysize = 8#3
        '''
        self.BankCanvas = blankCanvas(
            self,
            _xsize,
            _ysize,
            72,
            )
	    '''
        self.BankCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            #self.plotColor,
            #self.title,
            'Neutron Distribution',
            'SpecNo',
            'TOF / us',
            True,
            )
    

        _nline = 0
        self.firstGrid.addWidget(self.blank5, _nline, 5, 1,1)
        self.firstGrid.addWidget(self.blank9, _nline, 9, 1,1)
        self.firstGrid.addWidget(self.button341, _nline, 6, 1,1)
        self.firstGrid.addWidget(self.button342, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.button343, _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.button543, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.button533, _nline, 3, 1,1)
        self.firstGrid.addWidget(self.button523, _nline, 4, 1,1)
        self.firstGrid.addWidget(self.button331, _nline, 6, 1,1)
        self.firstGrid.addWidget(self.button332, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.button333, _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.button542, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.button532, _nline, 3, 1,1)
        self.firstGrid.addWidget(self.button522, _nline, 4, 1,1)
        self.firstGrid.addWidget(self.button322, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.button131, _nline, 10, 1,1)
        self.firstGrid.addWidget(self.button132, _nline, 11, 1,1)
        self.firstGrid.addWidget(self.button133, _nline, 12, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.button541, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.button531, _nline, 3, 1,1)
        self.firstGrid.addWidget(self.button521, _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.monitor, _nline, 1, 1,1)
        self.firstGrid.addWidget(self.sample, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.camera, _nline, 13, 1,1)
        self.firstGrid.addWidget(self.blank1, _nline, 0, 1,1)
        self.firstGrid.addWidget(self.blank2, _nline, 14, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.button643, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.button633, _nline, 3, 1,1)
        self.firstGrid.addWidget(self.button623, _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.button642, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.button632, _nline, 3, 1,1)
        self.firstGrid.addWidget(self.button622, _nline, 4, 1,1)
        self.firstGrid.addWidget(self.button422, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.button231, _nline, 10, 1,1)
        self.firstGrid.addWidget(self.button232, _nline, 11, 1,1)
        self.firstGrid.addWidget(self.button233, _nline, 12, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.button641, _nline, 2, 1,1)
        self.firstGrid.addWidget(self.button631, _nline, 3, 1,1)
        self.firstGrid.addWidget(self.button621, _nline, 4, 1,1)
        self.firstGrid.addWidget(self.button433, _nline, 6, 1,1)
        self.firstGrid.addWidget(self.button432, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.button431, _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.button443, _nline, 6, 1,1)
        self.firstGrid.addWidget(self.button442, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.button441, _nline, 8, 1,1)

        _nline += 1
        self.secondGrid.addWidget(self.bankCombo, _nline, 1, 1,1)
        _nline += 1
        self.secondGrid.addWidget(self.BankCanvas, _nline, 0, 1,1, QtCore.Qt.AlignCenter)

        self.verticalLayout.addWidget(self.splitter)
        
        self.buttonIndex = -1
        self.comboIndex = 0    

    def getComboIndex(self):
        self.comboIndex = self.bankCombo.currentIndex()    
        return self.comboIndex    

    def getButtonIndex(self):
        return self.buttonIndex
    
    def getDetectorIndex(self):
        buttonIndex = self.getButtonIndex()
        comboIndex = self.getComboIndex()
        return buttonIndex, comboIndex

    def comboSelected(self):
        comboIndex = self.getComboIndex()
        buttonIndex = self.getButtonIndex()
        self.parent.tabChange()

    def buttonClicked(self):
        #buttonIndex = self.getButtonIndex()
        comboIndex = self.getComboIndex()
        self.buttonChange()
        if self.button131.isChecked():
            self.button131.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=0
        elif self.button132.isChecked(): 
            self.button132.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=1
        elif self.button133.isChecked(): 
            self.button133.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=2
        elif self.button231.isChecked(): 
            self.button231.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=3
        elif self.button232.isChecked(): 
            self.button232.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=4
        elif self.button233.isChecked(): 
            self.button233.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=5
        elif self.button322.isChecked(): 
            self.button322.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=6
        elif self.button331.isChecked(): 
            self.button331.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=7
        elif self.button332.isChecked(): 
            self.button332.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=8
        elif self.button333.isChecked(): 
            self.button333.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=9
        elif self.button341.isChecked(): 
            self.button341.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=10
        elif self.button342.isChecked(): 
            self.button342.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=11
        elif self.button343.isChecked(): 
            self.button343.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=12
        elif self.button422.isChecked(): 
            self.button422.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=13
        elif self.button431.isChecked(): 
            self.button431.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=14
        elif self.button432.isChecked(): 
            self.button432.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=15
        elif self.button433.isChecked(): 
            self.button433.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=16
        elif self.button441.isChecked(): 
            self.button441.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=17
        elif self.button442.isChecked(): 
            self.button442.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=18
        elif self.button443.isChecked(): 
            self.button443.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=19
        elif self.button521.isChecked(): 
            self.button521.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=20
        elif self.button522.isChecked(): 
            self.button522.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=21
        elif self.button523.isChecked(): 
            self.button523.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=22
        elif self.button531.isChecked(): 
            self.button531.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=23
        elif self.button532.isChecked(): 
            self.button532.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=24
        elif self.button533.isChecked(): 
            self.button533.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=25
        elif self.button541.isChecked(): 
            self.button541.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=26
        elif self.button542.isChecked(): 
            self.button542.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=27
        elif self.button543.isChecked(): 
            self.button543.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=28
        elif self.button621.isChecked(): 
            self.button621.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=29
        elif self.button622.isChecked(): 
            self.button622.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=30
        elif self.button623.isChecked(): 
            self.button623.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=31
        elif self.button631.isChecked(): 
            self.button631.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=32
        elif self.button632.isChecked(): 
            self.button632.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=33
        elif self.button633.isChecked(): 
            self.button633.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=34
        elif self.button641.isChecked(): 
            self.button641.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=35
        elif self.button642.isChecked(): 
            self.button642.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=36
        elif self.button643.isChecked(): 
            self.button643.setIcon(QtGui.QIcon('img/module_on.png'))
            buttonIndex=37
        
        self.buttonIndex = buttonIndex
        self.parent.tabChange()
 
    def updateBankCanvas(self, value, started):
        self.BankCanvas.ax.clear()
        if not started:
            pass
        else:
            _buttonIndex=self.getButtonIndex()
            _comboIndex=self.getComboIndex()
            if _buttonIndex   in (0, 6,12,18,24,30,36):
                color2D = 'r'
                color3D = 'hot'
            elif _buttonIndex in (1, 7,13,19,25,31,37):
                color2D = 'g'
                color3D = 'cool'
            elif _buttonIndex in (2, 8,14,20,26,32):
                color2D = 'b'
                color3D = 'prism'
            elif _buttonIndex in (3, 9,15,21,27,33):
                color2D = 'c'
                color3D = 'spring'
            elif _buttonIndex in (4,10,16,22,28,34):
                color2D = 'm'
                color3D = 'winter'
            elif _buttonIndex in (5,11,17,23,29,35):
                color2D = 'y'
                color3D = 'BuPu'
            try:
                if _comboIndex==0:
                    # PID 2D Bar
                    #self.BankCanvas.ax.bar(_x,value,0.5,color='r')
                    #self.BankCanvas.ax.axis('scaled')
                    self.BankCanvas.ax.hist(value[1], color=color2D)
                elif _comboIndex==1:
                    # XY 3D Image
                    #self.BankCanvas.ax.axis('equal', adjustable='box')
                    self.BankCanvas.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                    #mlab.show()
                    #self.BankCanvas.ax.clear()
                    #self.BankCanvas.ax.imshow(img)
                    #self.BankCanvas.draw()
            except:
                pass
        plt.pause(0.0001)
        self.BankCanvas.draw()

    def buttonChange(self):
        self.button131.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button132.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button133.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button231.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button232.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button233.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button322.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button331.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button332.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button333.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button341.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button342.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button343.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button422.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button431.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button432.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button433.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button441.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button442.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button443.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button521.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button522.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button523.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button531.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button532.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button533.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button541.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button542.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button543.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button621.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button622.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button623.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button631.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button632.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button633.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button641.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button642.setIcon(QtGui.QIcon('img/module_off.png'))
        self.button643.setIcon(QtGui.QIcon('img/module_off.png'))

class BankButton(QtGui.QPushButton):

    def __init__(
        self,
        parent=None,
        img='',
        width=20,
        height=20,
        ):
        super(BankButton,self).__init__(parent)
	
        #self.img = img
        #self.width = width
        #self.height = height
        self.setFlat(True)
        self.setStyleSheet("border:none;outline:none")
        self.setIcon(QtGui.QIcon(img))
        self.setIconSize(QtCore.QSize(width,height))
        #self.resize(self.width,self.height)
        self.setCheckable(True)
