#!/usr/bin/python
# -*- coding: utf-8 -*-

# for pyqt4

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

import matplotlib
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure

class figureCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        plotColor = '',
        title='',
        xlabel='',
        ylabel='',
        tight_layout=False,
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor='white',
            edgecolor=None,
            linewidth=1.0,
            frameon=False,
            )

        self.fig.patch.set_alpha(0.1)
        self.ax = self.fig.add_subplot(111)  # axisbg='r'
        self.ax.tick_params(axis='both', which='major', labelsize=5)
        self.fig.subplots_adjust(left=0.12, bottom=0.25, right=0.95,
                                 top=0.95)

        self.xtitle = ''
        self.ytitle = ''

        self.ax.set_xlabel(xlabel, fontsize=5)
        self.ax.set_ylabel(ylabel, fontsize=5)

        self.plotColor = plotColor
        self.title = title
        self.grid_status = True
        self.xaxis_style = 'linear'
        self.yaxis_style = 'linear'
        #self.ax.hold(True)

        # self.ax.patch.set_alpha(0)

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                   QtGui.QSizePolicy.Expanding)
        FigureCanvasQTAgg.updateGeometry(self)

        self.draw()

class blankCanvas(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=3,
        height=2,
        dpi=150,
        ):

        self.fig = Figure(
            figsize=(width, height),
            dpi=dpi,
            facecolor=None,
            edgecolor=None,
            linewidth=0.0,
            frameon=False,
            tight_layout=False,
            )

        self.fig.patch.set_alpha(0.0)
        self.ax = self.fig.add_subplot(111, alpha=0.0, aspect=1.5)
        self.ax.get_xaxis().set_visible(False)
        self.ax.get_yaxis().set_visible(False)
        self.ax.set_axis_off()
        self.ax.set_frame_on(False)
        self.fig.subplots_adjust(left=0, bottom=0, right=1,top=1)

        self.ax.patch.set_alpha(0.0)
        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                   QtGui.QSizePolicy.Expanding)

        FigureCanvasQTAgg.updateGeometry(self)

        self.draw()

class xkcdFigure(FigureCanvasQTAgg):

    def __init__(
        self,
        parent=None,
        width=1,
        height=1,
        dpi=150,
        ):

        self.fig = Figure(
            (width, height),
            dpi=150,
            facecolor='white',
            edgecolor=None,
            frameon=False,
            tight_layout=False,
            )

        self.ax = self.fig.add_subplot(111)
        #self.ax.set_axis_off()
        self.ax.get_xaxis().set_visible(False)
        self.ax.get_yaxis().set_visible(False)
        #self.line, =self.ax.plot([], [], color="g")

        FigureCanvasQTAgg.__init__(self, self.fig)
        FigureCanvasQTAgg.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                   QtGui.QSizePolicy.Expanding)

        FigureCanvasQTAgg.updateGeometry(self)
