#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2017.05.15

Detector
'''

from conf.constants import *

# user defined

from model.readData import *
from canvas import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *
import random

from detectorDock import *


class CSNSDetectorPage(QtGui.QTabWidget):#QMainWindow):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

    # self.CSNSTOF1DetectorDock = CSNSDetectorDock(self , '/BL01/BANK01/IMAGE', 1, 'Accent', '0+1:Backward')
    # self.CSNSTOF2DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fit', 1, 'gist_rainbow', '0+1:Backward')
    # self.CSNSXY1DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fxy', 1, 'Spectral', '0+1:Backward')
    # self.CSNSXY2DetectorDock = CSNSDetectorDock(self , '/GPPD/workspace/data/bank01/fxy', 1, 'cool', '0+1:Backward')

    # self.addDockWidget(QtCore.Qt.TopDockWidgetArea, self.CSNSTOF1DetectorDock)
    # self.addDockWidget(QtCore.Qt.TopDockWidgetArea, self.CSNSTOF2DetectorDock)
    # self.addDockWidget(QtCore.Qt.BottomDockWidgetArea, self.CSNSXY1DetectorDock)
    # self.addDockWidget(QtCore.Qt.BottomDockWidgetArea, self.CSNSXY2DetectorDock)

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)

	#first Grid
	self.bank01 = QtGui.QPushButton('Bank #1')
	self.bank01.setStyleSheet("background-color : skyblue")
	self.bank02 = QtGui.QPushButton('Bank #2')
	self.bank02.setStyleSheet("background-color : skyblue")
	self.bank03 = QtGui.QPushButton('Bank #3')
	self.bank03.setStyleSheet("background-color : skyblue")
	self.bank04 = QtGui.QPushButton('Bank #4')
	self.bank04.setStyleSheet("background-color : skyblue")
	self.bank05 = QtGui.QPushButton('Bank #5')
	self.bank05.setStyleSheet("background-color : skyblue")
	self.bank06 = QtGui.QPushButton('Bank #6')
	self.bank06.setStyleSheet("background-color : skyblue")
	self.camera = QtGui.QPushButton('Camera')
	self.camera.setStyleSheet("background-color : lavender")
	
	#second Grid
        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('PID')
        self.comboBox.addItem('XY')
        # self.comboBox.activated.connect(self.comboboxChoose)

	_xsize = 3
        _ysize = 0.5	
	self.canvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            '',
            '',
            '',
            )
	
	_nline = 0
	self.firstGrid.addWidget(self.bank03, _nline, 2, 1,1)
	_nline += 1
	self.firstGrid.addWidget(self.bank05, _nline, 1, 1,1)
	self.firstGrid.addWidget(self.bank01, _nline, 3, 1,1)
	_nline += 1
	self.firstGrid.addWidget(self.camera, _nline, 4, 1,1)
	_nline += 1
	self.firstGrid.addWidget(self.bank06, _nline, 1, 1,1)
	self.firstGrid.addWidget(self.bank02, _nline, 3, 1,1)
	_nline += 1
	self.firstGrid.addWidget(self.bank04, _nline, 2, 1,1)
	
	_nline += 1
	self.secondGrid.addWidget(self.comboBox, _nline, 1, 1,1)
	_nline += 1
	self.secondGrid.addWidget(self.canvas, _nline, 0, 1,1)

	self.verticalLayout.addWidget(self.scrollArea)
	self.verticalLayout.addWidget(self.scrollArea2)


