#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.26

Calibration

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *


class CSNSCalibrationPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSCalibrationPage, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.verticalLayout = QtGui.QVBoxLayout(self)

        first = QtGui.QFrame(self)
        first.setFrameShape(QtGui.QFrame.StyledPanel)
        scrollArea = QtGui.QScrollArea()
        scrollArea.setWidgetResizable(True)
        scrollArea.setWidget(first)

        self.verticalLayout.addWidget(scrollArea)

        self.mainGrid = QtGui.QGridLayout(first)

        # Background

        _xsize = 5
        _ysize = 0.8

        # Background

        self.BackgroundLabel = QtGui.QLabel('Background')
        self.BackgroundComboBox = QtGui.QComboBox()
        self.BackgroundComboBox.addItem('0 1')
        self.BackgroundComboBox.addItem('2 3')
        self.BackgroundComboBox.addItem('4 5')
        self.LoadBackgroundButton = QtGui.QPushButton('Load')

        self.BackgroundImageCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.filexy = ['img/XY ++.png', 'img/XY +-.png']

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[0], 1, 1)
        self.BackgroundImage = \
            self.BackgroundImageCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.BackgroundImageCanvas.ax.add_patch(self.rect)
        self.BackgroundImageCanvas.draw()

        _nline = 0
        self.mainGrid.addWidget(self.BackgroundComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.BackgroundLabel,_nline, 4, 1, 1, QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.LoadBackgroundButton, _nline, 8, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.BackgroundImageCanvas, _nline, 1, 1, 7)

