from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy

class workerObject(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    
    def __init__(self, parent=None, *args,**kwargs):
        super(self.__class__, self).__init__(parent)

        for kwarg in kwargs:
            if kwarg == 'neonServer':
                self.neonServer= kwargs[kwarg]
            elif kwarg == 'neonPath': 
                self.neonPath= kwargs[kwarg]
            elif kwarg == 'refreshTime': 
                self.refreshTime= kwargs[kwarg]
      
        try:
            type(self.refreshTime)
        except:
            self.refreshTime=0.3
 
        self.command=True
        self.mylist=["configure", "start", "stop", "pause", "abort"]

    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command: break
            try:
                i=random.randint(0,4)
                self.signalStatus.emit(self.mylist[i])
            except:
                continue

            time.sleep(self.refreshTime) 
        self.finished.emit()            

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command

class getNeonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalProgress = QtCore.pyqtSignal(object)
    signalStatus = QtCore.pyqtSignal(object)
    signalMonitor = QtCore.pyqtSignal(object)
    signalExperiment = QtCore.pyqtSignal(object,object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, neonServer, progressPath, protonPath, neutronPath, pulsePath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.progressPath = progressPath
        self.protonPath = protonPath
        self.neutronPath = neutronPath
        self.pulsePath = pulsePath
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0
        self.monitorTOFPath = '/GPPD/workspace/MantidData/monitor02/tof'
        self.monitorCountsPath = '/GPPD/workspace/MantidData/monitor02/counts'
        self.monitorTOF=[]

        self.pidXaxis=[]
        self.xyXaxis=[]
        self.xyYaxis=[]
        for i in range(6):
            self.pidXaxis.append([])
            self.xyXaxis.append([])
            self.xyYaxis.append([])

    def pause(self):
        self.started=False

    @QtCore.pyqtSlot()
    def process(self):
        # progress setting in mainSet
        try:
            progress = self.neonServer.get(self.progressPath)
            if progress is None:
                self.signalLog.emit("Empty progressBar Setting Data!")
            else:
                try:
                    self.signalProgress.emit(progress)
                except:
                    pass
        except:
            pass 

        # Monitor TOF in User Panel 
        try:
            _data = self.neonServer.get(self.monitorTOFPath)
            if _data is None:
                self.signalLog.emit("Empty Monitor TOF Data!")
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.monitorTOF=_data
                except:
                    self.signalLog.emit("Incompleted Monitor TOF Data")
        except:
            pass

        while True:
            # Monitor Counts in User Panel 
            try:
                _data = self.neonServer.get(self.monitorCountsPath)
            except:
                pass
            if _data is None :
                self.signalLog.emit("Empty Monitor Counts Data!")
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.signalMonitor.emit(_data)
                except:
                    self.signalLog.emit("Incompleted Monitor Counts Data")
            
            if not self.started:break 
            # get Proton Charge and Neutron Counts in User
            try:
                _proton = self.neonServer.get(self.protonPath)
                _neutron = self.neonServer.get(self.neutronPath)
            except:
                pass
            if _proton is None:
                self.signalLog.emit("Empty Proton Charge Data!")
            else:
                try:
                    _proton = jsonArray.jsonDecoder(_proton)
                except:
                    self.signalLog.emit("Incompleted Proton Charge  data")
            if _neutron is None:
                self.signalLog.emit("Empty Neutron Counts Data!")
            else:
                try:
                    _neutron = jsonArray.jsonDecoder(_neutron)
                except:
                    self.signalLog.emit("Incompleted Neutron Counts data")
            try:
                self.signalExperiment.emit(_proton[-1][-1],  _neutron[-1][-1])
            except:
                pass

            # get Tab index
            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass
            # Detector page
            if self.tabIndex == 1:
                value = []
                bankIndex, comboIndex = self.getDetectorIndex()
                if comboIndex==0 and bankIndex!=-1:
                    try:
                        # pid combo Xaxis
                        if len(self.pidXaxis[bankIndex])==0:
                            _json=self.neonServer.get(self.kwargs['path1'][bankIndex])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.pidXaxis[bankIndex]=_array
                        value.append(self.pidXaxis[bankIndex])
                    except:
                        pass
                    #pid combo value
                    try:
                        _data = self.neonServer.get(self.kwargs['path2'][bankIndex])
                        if _data is None:
                            self.signalLog.emit("Empty PID Data!")
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                                value.append(_data)
                            except:
                                self.signalLog.emit("Incompleted Canvas data")
                    except:
                        pass
                elif comboIndex==1 and bankIndex!=-1:
                    try:
                        # xy combo Xaxis
                        if len(self.xyXaxis[bankIndex])==0:
                            _json=self.neonServer.get(self.kwargs['path3'][bankIndex])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.xyXaxis[bankIndex]=_array
                        # xy combo Yaxis
                        if len(self.xyYaxis[bankIndex])==0:
                            _json=self.neonServer.get(self.kwargs['path4'][bankIndex])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.xyYaxis[bankIndex]=_array
                        value.append(self.xyXaxis[bankIndex])
                        value.append(self.xyYaxis[bankIndex])
                    except:
                        pass
                    #xy combo value
                    try:
                        _data = self.neonServer.get(self.kwargs['path5'][bankIndex])
                        if _data is None:
                            self.signalLog.emit("Empty XY Data!")
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                                value.append(_data)
                            except:
                                self.signalLog.emit("Incompleted Canvas data")
                    except:
                        pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Experiment page
            elif self.tabIndex == 3:
                value = []
                try:
                    _pulse = self.neonServer.get(self.pulsePath)
                    if _pulse is None:
                        self.signalLog.emit("Empty Pulse Counts Data!")
                    else:
                        try:
                            _pulse = jsonArray.jsonDecoder(_pulse)
                        except:
                            self.signalLog.emit("Incompleted Pulse Counts data")
                except:
                    pass
                value.append(_proton)
                value.append(_neutron)
                value.append(_pulse)
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            else:
                value = []
                for key in self.kwargs: 
                    _array = []
                    if key=='tabIndex':
                        pass
                    else:
                        try:
                            for j in range(len(self.kwargs[key])): 
                                _data = self.neonServer.get(self.kwargs[key][j])
                                if _data is None:
                                    self.signalLog.emit("Empty Canvas Data!")
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        _array.append(_data)
                                    except:
                                        self.signalLog.emit("Incompleted Canvas data")
                            value.append(_array)
                        except:
                            pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass

            time.sleep(self.refreshTime)
        self.finished.emit()

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getTabIndex(self):
        return self.tabIndex

    def getMonitorTOF(self):
        return self.monitorTOF

    def getDetectorIndex(self):
        return self.parent.getDetectorIndex()

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()
