#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
from presenter.updateStreaming import *


class CSNSHistogramPage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSHistogramPage, self).__init__(parent=None)
        self.setupUi(self)
        self.BackwardConstant = 40000
        self.MediumConstant = 30000
        self.SmallConstant = 20000

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        _xsize = 5
        _ysize = 0.8

        # Backward TOF/d

        self.BackwardComboBox = QtGui.QComboBox()
        self.BackwardComboBox.addItem('TOF')
        self.BackwardComboBox.addItem('d')
        self.BackwardComboBox.activated.connect(self.BackwardComboboxChoose)
        self.BackwardButton = QtGui.QPushButton('Pause') 
        self.BackwardButton.clicked.connect(self.BackwardButtonClicked)

        self.BackwardCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # 90-Bank TOF/d

        self.MediumComboBox = QtGui.QComboBox()
        self.MediumComboBox.addItem('TOF')
        self.MediumComboBox.addItem('d')
        self.MediumComboBox.activated.connect(self.MediumComboboxChoose)
        self.MediumButton = QtGui.QPushButton('Pause') 
        self.MediumButton.clicked.connect(self.MediumButtonClicked)

        self.MediumCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small-angle bank TOF/d

        self.SmallComboBox = QtGui.QComboBox()
        self.SmallComboBox.addItem('TOF')
        self.SmallComboBox.addItem('d')
        self.SmallComboBox.activated.connect(self.SmallComboboxChoose)
        self.SmallButton = QtGui.QPushButton('Pause') 
        self.SmallButton.clicked.connect(self.SmallButtonClicked)
        
        self.SmallCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Monitor TOF/d

        self.MonitorCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Backward bank 3D

        self.Backward3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Medium bank 3D

        self.Medium3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small bank 3D

        self.Small3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        _nline = 0
        self.mainGrid.addWidget(self.BackwardComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.BackwardButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.BackwardCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MediumComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.MediumButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.MediumCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.SmallComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.SmallButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.SmallCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MonitorCanvas, _nline, 0, 1, 2)
        self.mainGrid.addWidget(self.Backward3DCanvas, _nline, 2, 1, 2)
        self.mainGrid.addWidget(self.Medium3DCanvas, _nline, 4, 1, 2)
        self.mainGrid.addWidget(self.Small3DCanvas, _nline, 6, 1, 2)

    def BackwardComboboxChoose(self):
        self.index = self.BackwardComboBox.currentIndex()
        if self.index == 0:
            self.BackwardConstant = 40000    
        elif self.index == 1:
            self.BackwardConstant = 1
        self.BackwardThread.stop()
        
        self.BackwardThread = updateStreaming2D(self.BackwardThreadID,self.BackwardCanvas,
                self.BackwardCanvas.ax, self.BackwardConstant, 'r', self.BackwardSimulatorStreaming)
        self.BackwardThread.setDaemon(True)
        self.BackwardThread.start()

    def MediumComboboxChoose(self):
        index = self.MediumComboBox.currentIndex()
        if index == 0:
            self.MediumConstant = 30000       
        elif index == 1:
            self.MediumConstant = 1
        self.MediumThread.stop()
        
        self.MediumThread = updateStreaming2D(self.MediumThreadID,self.MediumCanvas,
                self.MediumCanvas.ax, self.MediumConstant, 'g', self.MediumSimulatorStreaming)
        self.MediumThread.setDaemon(True)
        self.MediumThread.start()

    def SmallComboboxChoose(self):
        self.index = self.SmallComboBox.currentIndex()
        if self.index == 0:
            self.SmallConstant = 20000       
        elif self.index == 1:
            self.SmallConstant = 1
        self.SmallThread.stop()
        
        self.SmallThread = updateStreaming2D(self.SmallThreadID,self.SmallCanvas,
                self.SmallCanvas.ax, self.SmallConstant, 'b', self.SmallSimulatorStreaming)
        self.SmallThread.setDaemon(True)
        self.SmallThread.start()
     
    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        self.BackwardThreadID = threadID
        self.BackwardSimulatorStreaming = simulatorStreaming
        
        self.BackwardThread = updateStreaming2D(self.BackwardThreadID,self.BackwardCanvas, 
                self.BackwardCanvas.ax, CSNSBackwardConstant , 'r', 
                    self.BackwardSimulatorStreaming)
        self.BackwardThread.setDaemon(True)
        self.BackwardThread.start()
        return self.BackwardThread

    def updateMediumStreaming(self, threadID, simulatorStreaming):
        self.MediumThreadID = threadID
        self.MediumSimulatorStreaming = simulatorStreaming
        self.MediumThread = updateStreaming2D(self.MediumThreadID, self.MediumCanvas,
                self.MediumCanvas.ax,CSNSMediumConstant, 'g', self.MediumSimulatorStreaming)
        self.MediumThread.setDaemon(True)
        self.MediumThread.start()
        return self.MediumThread

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        self.SmallThreadID = threadID
        self.SmallSimulatorStreaming = simulatorStreaming
        self.SmallThread = updateStreaming2D(self.SmallThreadID, self.SmallCanvas,
                self.SmallCanvas.ax, CSNSSmallConstant,'b', self.SmallSimulatorStreaming)
        self.SmallThread.setDaemon(True)
        self.SmallThread.start()
        return self.SmallThread

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        MonitorThread = updateStreamingMonitor(threadID,
                self.MonitorCanvas, self.MonitorCanvas.ax, 'y',
                simulatorStreaming)
        MonitorThread.setDaemon(True)
        MonitorThread.start()
        return MonitorThread
    
    def updateBackward3DStreaming(self, threadID, simulatorStreaming):
        Backward3DThread = updateStreaming3D(threadID,
                self.Backward3DCanvas, self.Backward3DCanvas.ax,
                'Accent', simulatorStreaming)
        Backward3DThread.setDaemon(True)
        Backward3DThread.start()
        return Backward3DThread

    def updateMedium3DStreaming(self, threadID, simulatorStreaming):
        Medium3DThread = updateStreaming3D(threadID,
                self.Medium3DCanvas, self.Medium3DCanvas.ax, 'Spectral'
                , simulatorStreaming)
        Medium3DThread.setDaemon(True)
        Medium3DThread.start()
        return Medium3DThread

    def updateSmall3DStreaming(self, threadID, simulatorStreaming):
        Small3DThread = updateStreaming3D(threadID, self.Small3DCanvas,
                self.Small3DCanvas.ax, 'cool', simulatorStreaming)
        Small3DThread.setDaemon(True)
        Small3DThread.start()
        return Small3DThread

    def BackwardButtonClicked(self):
        if self.BackwardButton.text()=="Pause":
            self.BackwardButton.setText("Start")     

            self.BackwardThread.stop()

        elif self.BackwardButton.text()=="Start":
            self.BackwardButton.setText("Pause")     

            self.BackwardThread = updateStreaming2D(self.BackwardThreadID,self.BackwardCanvas,
                self.BackwardCanvas.ax, self.BackwardConstant, 'r', self.BackwardSimulatorStreaming)
            self.BackwardThread.setDaemon(True)
            self.BackwardThread.start()     

    def MediumButtonClicked(self):
        if self.MediumButton.text()=="Pause":
            self.MediumButton.setText("Start")
            
            self.MediumThread.stop()
        
        elif self.MediumButton.text()=="Start":
            self.MediumButton.setText("Pause")
            
            self.MediumThread = updateStreaming2D(self.MediumThreadID,self.MediumCanvas,
                self.MediumCanvas.ax, self.MediumConstant, 'g', self.MediumSimulatorStreaming)
            self.MediumThread.setDaemon(True)
            self.MediumThread.start()     

    def SmallButtonClicked(self):
        if self.SmallButton.text()=="Pause":
            self.SmallButton.setText("Start")     

            self.SmallThread.stop()

        elif self.SmallButton.text()=="Start":
            self.SmallButton.setText("Pause")     
            
            self.SmallThread = updateStreaming2D(self.SmallThreadID,self.SmallCanvas,
                self.SmallCanvas.ax, self.SmallConstant, 'b', self.SmallSimulatorStreaming)
            self.SmallThread.setDaemon(True)
            self.SmallThread.start()     
