#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

'''
Created on 2015.9.25
'''

from conf.constants import *
import json
from json import *
import atexit
import redis
#import warnings

# viewer defined
from viewer.user import *
from viewer.menuBar import *
from viewer.statusBar import *
from viewer.mainSet import *
from viewer import logWindow
# model defined
from model import neonReceiver
#from mayavi import mlab

class mywindow(QtGui.QMainWindow):

    def __init__(self, parent):
        super(mywindow, self).__init__()
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, MainWindow):

        self.myMenuBar = menuBar(self)
        self.setMenuBar(self.myMenuBar)

        self.myStatusBar = statusBar(self)
        self.setStatusBar(self.myStatusBar)

        self.mainSplitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)

        self.userWidget = CSNSUserInfo(self)
        self.mainSetWidget = CSNSMainSetInfo(self)

        self.mainSplitter.addWidget(self.userWidget)
        self.mainSplitter.addWidget(self.mainSetWidget)
    
        self.myStatus = 'waiting'
        logging.info("Status is waiting")
        self.ip_port = "" 
        self.mainSplitterLeft = 100
        self.mainSplitterRight = 900
        self.myCommand = None
        self.commandList = ['configure','unconfigure','start','pause','resume','stop','abort']
        self.statusList = ['waiting','unconfigured','configuring','ready','running','paused','error']
        self.dataThread = None
        self.started = True
        # data update time
        self.refreshtime = 1.0
        # progress value
        self.progressName = ''
        self.progressValue = 0
        self.protonValue = 0
        self.neutronValue = 0
        self.pulseValue = 0

        self.setCentralWidget(self.mainSplitter)
        self.loadConfigure()
        self.setConfigure()

        self.userWidget.setStatusLabel(self.myStatus)  
 
        self.createThread()

    def updateDiffractionSimulator(self):
        self.upRightTab.updateDiffractionSimulator()

    def updateDataStreaming(self):
        self.upRightTab.updateDataStreaming()

    def updateProton(self, threadID):
        self.upRightTab.updateProton(threadID)

    def getDisplay(self):
        screen_resolution = self.parent.desktop().screenGeometry()
        return screen_resolution.width(), screen_resolution.height()

    def loadConfigure(self):
        _confFile='./conf/configure.json'
        _mainWidth, _mainHeight=self.getDisplay()

        if not os.path.exists(_confFile):
            self.mainWidth=_mainWidth
            self.mainHeight=_mainHeight
            self.ip_port=self.userWidget.getIP_PORT()
            self.mainSplitterLeft=(self.mainWidth + 50) / 9.0
            self.mainSplitterRight=self.mainWidth / 9.0 * 8
        else:
            try:
                layoutParameter = json.loads(open(_confFile, "r").read())
                self.mainWidth=layoutParameter['mainWidth']
                self.mainHeight=layoutParameter['mainHeight']
                self.ip_port=layoutParameter['ip_port']
                self.mainSplitterLeft=layoutParameter['mainSplitterLeft']
                self.mainSplitterRight=layoutParameter['mainSplitterRight']
            except:
                self.mainWidth=_mainWidth
                self.mainHeight=_mainHeight
                self.ip_port=[('10.1.53.240', 9001), ('10.1.53.240',9011), ('10.1.53.240',9021)]

    def setConfigure(self):
        self.resize(self.mainWidth, self.mainHeight)
        self.mainSplitter.setSizes([self.mainSplitterLeft,self.mainSplitterRight])

    def saveConfigure(self):
        _mainWidth=self.mainSplitter.geometry().width()
        _mainHeight=self.mainSplitter.geometry().height()
        _ip_port=self.userWidget.getIP_PORT()
        _mainSplitterLeft=self.mainSplitter.sizes()[0]
        _mainSplitterRight=self.mainSplitter.sizes()[1]

        _data = {"mainWidth": _mainWidth, "mainHeight": _mainHeight, "mainSplitterLeft":_mainSplitterLeft,"mainSplitterRight":_mainSplitterRight, "ip_port":_ip_port }
        
        _confFile='./conf/configure.json'
        if not os.path.exists(_confFile):
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)
        else:
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)

    def setNeonStatus(self, value):
	    self.userWidget.setNeonStatus(value)
 
    def getNeon(self):
	    self.neonStatus, self.neonServer=self.userWidget.getNeon()
	    return self.neonStatus, self.neonServer
  
    def getStatus(self):
    	return self.statusList.index(self.myStatus)
    
    def setHeartBeat(self, parent):
    	neonpath="/GPPD/heartbeat/pilot"

    	logging.info("Creating heartbeat thread")
    	self.heartbeatThread = neonReceiver.setHeartbeat(self, self.neonServer, 1.0, neonpath, self.getStatus())
    	self.heartbeatThread.setDaemon(True)

    def getApp(self):
        return self.parent

    def getCommand(self, parent, gui):
        logging.info("Creating Command Thread...")
        #commandPath = '/GPPD/control/command'
        commandPath = '/GPPD/command/pilot'
        self.commandThread = neonReceiver.commandThread(parent, gui, self.neonServer, commandPath, 5.0)

    @QtCore.pyqtSlot(str)
    def setCommand(self, value):
        _command = self.commandList[int(value)]
        if self.myCommand!=_command:
            logging.info(str("Received command: " + _command))
            # start stateMachine
            self.stateMachine(_command) 
            self.userWidget.setCommandLabel(_command)
            
            self.myCommand = _command

    @QtCore.pyqtSlot(str)
    def setLog(self, value):
        logging.info(value)
   
    def getCanvasData(self, parent, gui):
        logging.info("Creating Canvas data Thread...")
     
        progressPath='/GPPD/cockpit/progress_setting'        
 
        protonValuePath='/GPPD/workspace/MantidData/proton_charge/value'
        neutronValuePath='/GPPD/workspace/MantidData/neutron_counts/value'
        pulseValuePath='/GPPD/workspace/MantidData/pulse_counts/value'
                
        self.dataThread = neonReceiver.dataThread(parent, gui, self.neonServer, progressPath, protonValuePath, neutronValuePath, pulseValuePath, self.refreshtime)
 
    def setDataPath(self, kwargs):
        if not self.dataThread:
            logging.info("No data availabel")
        else:
            self.dataThread.setDataPath(kwargs)

    def getDetectorIndex(self):
        return self.mainSetWidget.upRightTab.detectorPage.getDetectorIndex()
    
    @QtCore.pyqtSlot(object)
    def setCanvasData(self, value):
        tabIndex = self.dataThread.getTabIndex()
        _started = self.started
        _command = self.myCommand
        if tabIndex == 0:
            self.mainSetWidget.upRightTab.patternPage.updateCanvas(value, _started, _command)
        elif tabIndex == 1:
            self.mainSetWidget.upRightTab.detectorPage.updateBankCanvas(value, _started, _command)
        elif tabIndex == 2:
            self.mainSetWidget.upRightTab.monitorPage.updateCanvas(value, _started, _command)
        elif tabIndex == 3:    
            self.mainSetWidget.upRightTab.experimentPage.updateCanvas(value, _started, _command)
    
    @QtCore.pyqtSlot(object)
    def setMonitorCanvas(self, value):
        xdata = self.dataThread.getMonitorTOF()
        self.userWidget.updateMonitorCanvas(xdata,value)

    @QtCore.pyqtSlot(object, object)
    def setUserData(self, _proton, _neutron):
        self.userWidget.setProtonNeutron(_proton, _neutron)
        self.protonValue = int(_proton)
        self.neutronValue = int(_neutron)
        #self.pulseValue = int(_pulse)

    @QtCore.pyqtSlot(str)
    def setProgressData(self, value):
        _value = json.loads(str(value))
        self.progressName = _value['name']
        self.setProgressBar(_value['min'], _value['max'])

    # set max and min value for progressBar
    def setProgressBar(self, mini, maxi):
        self.mainSetWidget.createProgressBar(mini, maxi)

    #get current value for progressBar
    def getValue(self):
        if self.progressName=='proton_charge':
            self.progressValue = self.protonValue
        elif self.progressName=='neutron_counts':
            self.progressValue = self.neutronValue
        elif self.progressName=='pulse_counts':
            self.progressValue = self.pulseValue
        else:
            pass
        return self.progressValue

    def getUserInfo(self):
        try:
            userPath = '/MR/cockpit/user_information'
            _neonStatus, _neonServer = self.getNeon()
            if _neonStatus:
                #get json date after json.dumps from neon
                _userInfo = self.neonServer.get(userPath)
                print _userInfo
                print json.loads(_userInfo)
                if _userInfo is None:
                    logging.info("Empty User Information Data!")
                else:
                    self.userWidget.setUserInfo(_userInfo)
        except:
            pass   
 
    def createThread(self):
        # connect neon
        _neonStatus, _neonServer = self.getNeon()
        self.setNeonStatus(_neonStatus)
        if _neonStatus:
            # set heartbeat
            self.setHeartBeat(self)
            # get command
            self.getCommand(self.parent, self)
            # get canvas data
            self.getCanvasData(self.parent, self)
            self.myStatus = 'unconfigured'
            logging.info("Status change to unconfigured")

    def startThread(self):
        self.heartbeatThread.start()
        logging.info("Start heartbeat successfully")
        self.commandThread.start()
        logging.info("Start Command Thread successfully")

    def stateMachine(self, command):
        _command = command
        _index = self.getStatus()
        _status = self.statusList[_index]

        if _command == 'configure':
            if _status == 'waiting':
                logging.info("waiting status cannot receive configure command")
            elif _status == 'unconfigured':
                _status = 'configuring'
                logging.info("status change to configuring")
                self.getUserInfo()
                _status = 'ready'
                logging.info("status change to ready")
            elif _status == 'configuring':
                logging.info("configuring status cannot receive configure command")
            elif _status == 'ready':
                logging.info("ready status cannot receive configure command")
            elif _status == 'running':
                logging.info("running status cannot receive configure command")
            elif _status == 'paused':
                logging.info("paused status cannot receive configure command")
        elif _command == 'unconfigure':
            if _status == 'waiting':
                logging.info("waiting status cannot receive unconfigure command")
            elif _status == 'unconfigured':
                logging.info("unconfigured status cannot receive unconfigure command")
            elif _status == 'configuring':
                logging.info("configuring status cannot receive unconfigure command")
            elif _status == 'ready':
                self.started = False
                self.dataThread.pause()
                _status = 'unconfigured'
                logging.info("status change to unconfigured")
            elif _status == 'running':
                logging.info("running status cannot receive unconfigure command")
            elif _status == 'paused':
                logging.info("paused status cannot receive unconfigure command")
        elif _command == 'start':
            if _status == 'waiting':
                logging.info("waiting status cannot receive start command")
            elif _status == 'unconfigured':
                logging.info("unconfigured status cannot receive start command")
            elif _status == 'configuring':
                logging.info("configuring status cannot receive start command")
            elif _status == 'ready':
                #clear canvas

                self.dataThread.start()
                logging.info("Start Canvas Data Thread successfully")
                # set canvas data path
                self.mainSetWidget.upRightTab.tabChange()

                self.userWidget.startTime=time.time()
                _status = 'running'
                logging.info("status change to running")
            elif _status == 'running':
                logging.info("running status cannot receive start command")
            elif _status == 'paused':
                logging.info("paused status cannot receive start command")
        elif _command == 'pause':
            if _status == 'waiting':
                logging.info("waiting status cannot receive pause command")
            elif _status == 'unconfigured':
                logging.info("unconfigured status cannot receive pause command")
            elif _status == 'configuring':
                logging.info("configuring status cannot receive pause command")
            elif _status == 'ready':
                logging.info("ready status cannot receive pause command")
            elif _status == 'running':
                # pause get date from neon
                self.dataThread.pause()
                _status = 'paused'
                logging.info("status change to paused")
            elif _status == 'paused':
                logging.info("paused status cannot receive pause command")
        elif _command == 'resume':
            if _status == 'waiting':
                logging.info("waiting status cannot receive resume command")
            elif _status == 'unconfigured':
                logging.info("unconfigured status cannot receive resume command")
            elif _status == 'configuring':
                logging.info("configuring status cannot receive resume command")
            elif _status == 'ready':
                logging.info("ready status cannot receive resume command")
            elif _status == 'running':
                logging.info("running status cannot receive resume command")
            elif _status == 'paused':
                self.dataThread.resume()
                _status = 'running'
                logging.info("status change to runninig")
        elif _command == 'stop':
            if _status == 'waiting':
                logging.info("waiting status cannot receive stop command")
            elif _status == 'unconfigured':
                logging.info("unconfigured status cannot receive stop command")
            elif _status == 'configuring':
                logging.info("configuring status cannot receive stop command")
            elif _status == 'ready':
                logging.info("ready status cannot receive stop command")
            elif _status == 'running':
                self.started = False
                time.sleep(self.refreshtime)
                self.dataThread.pause()
                #self.dataThread.stop()
                _status = 'ready'
                logging.info("status change to ready")
            elif _status == 'paused':
                logging.info("paused status cannot receive stop command")
        elif _command == 'abort':
            if _status == 'waiting':
                logging.info("waiting status cannot receive abort command")
            elif _status == 'unconfigured':
                logging.info("unconfigured status cannot receive abort command")
            elif _status == 'configuring':
                self.started = False
                time.sleep(self.refreshtime)
                #self.dataThread.stop()
                self.dataThread.pause()
                _status = 'unconfigured'
                logging.info("status change to unconfigured")
            elif _status == 'ready':
                logging.info("ready status cannot receive abort command")
            elif _status == 'running':
                self.started = False
                time.sleep(self.refreshtime)
                self.dataThread.pause()
                #self.dataThread.stop()
                _status = 'ready'
                logging.info("status change to ready")
            elif _status == 'paused':
                logging.info("paused status cannot receive abort command")
        else:
            pass

        self.userWidget.setStatusLabel(_status)  
        self.myStatus = _status

def exit_handler(top):
    top.saveConfigure()

if __name__ == '__main__':
    
    myapp = QtGui.QApplication(sys.argv)
    
    mytop = mywindow(myapp)
    icon = QtGui.QIcon('img/logo.jpg')
    mytop.setWindowIcon(icon)
    mytop.setWindowTitle('GPPD')
    mytop.show()
    time.sleep(0.1)
    mytop.startThread()

    atexit.register(exit_handler, mytop)
    sys.exit(myapp.exec_())
