from numpy import exp

# lorentzian Squared
def CSNSlor2(parameters, values):
    # FWHM = 2*sqrt(sqrt(2.0)-1)*p1
    p0, p1, p2= parameters
    x = values
    return (p2 * (1/(1+((x-p0)/p1)**2.0))**2.0 )

# gaussian
def CSNSgauss(parameters, values):
    a, x0, w, y0 = parameters
    x = values
    return(a * exp(-(x-x0)**2/2/w**2) + y0)
