#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from chopper import *
from experiment import *
from monitor import *
#from image import *
from model.chopperModel import *

class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.chopperPage = CSNSChopperPage(self)
        self.experimentPage = CSNSExperimentPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        #self.imagePage = CSNSImagePage(self)

        self.addTab(self.chopperPage, 'Chopper')
        self.addTab(self.experimentPage, 'Experiment')
        self.addTab(self.monitorPage, 'Monitor')
        #self.addTab(self.imagePage, 'Image')

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()


