#!/usr/bin/python
# -*- coding: utf-8 -*-

# configure

from conf import *

from model.readData import *


class CSNSRunData(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSRunData, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, QWidget):
        self.mainGrid = QtGui.QGridLayout(self)
        self.mainGrid.setMargin(0)

        with plt.xkcd():
            self.runFigure = Figure(
                (1, 1),
                dpi=150,
                facecolor='white',
                edgecolor=None,
                frameon=False,
                tight_layout=False,
                )
            self.runCanvas = FigureCanvas(self.runFigure)
            self.runCanvas.setParent(self)

            self.runAxes = self.runFigure.add_subplot(111)
            self.runFigure.subplots_adjust(left=0.05, bottom=0.05,
                    right=0.95, top=0.95)
            self.runAxes.tick_params(axis='both', which='major',
                    labelsize=6)
            self.runAxes.get_xaxis().set_visible(False)
            self.runAxes.get_yaxis().set_visible(False)
            (_ntmp, runData) = CSNSRead2DData('./dat/refl.dat')
            self.runAxes.yaxis.set_major_formatter(ticker.FormatStrFormatter('%3.1E'
                    ))
            self.runAxes.plot(runData[0], runData[1])
            self.runCanvas.draw()

        self.chargeLabel = QtGui.QLabel('Proton Charge: ')
        self.chargeText = QtGui.QLabel('1.3E6 ')

        self.countsLabel = QtGui.QLabel('Neutron Counts: ')
        self.countsText = QtGui.QLabel('5.2E10 ')

        self.mainGrid.addWidget(
            self.chargeLabel,
            0,
            0,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(
            self.chargeText,
            0,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(
            self.countsLabel,
            1,
            0,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(
            self.countsText,
            1,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(
            self.runCanvas,
            2,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addItem(QtGui.QSpacerItem(-1, -1,
                              QtGui.QSizePolicy.Ignored,
                              QtGui.QSizePolicy.Expanding), 2, 0)


