#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Hotimage

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *


class CSNSHotimagePage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSHotimagePage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        # Left Label

        self.LeftLabel = QtGui.QLabel('Left')

        # Right Label

        self.RightLabel = QtGui.QLabel('Right')

        # Bckward 2D/3D

        self.BackwardComboBox = QtGui.QComboBox()
        self.BackwardComboBox.addItem('2D')
        self.BackwardComboBox.addItem('3D')
        self.filexy = ['img/XY ++.png', 'img/XY +-.png']
        self.filext = ['img/XT ++.png', 'img/XT +-.png']
        _index = self.BackwardComboBox.currentIndex()

        _xsize = 3
        _ysize = 1

        # Backward

        self.BackwardLabel = QtGui.QLabel('Backward')

        self.BackwardCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.BackwardImage = \
            self.BackwardCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.BackwardCanvas.ax.add_patch(self.rect)
        self.BackwardCanvas.draw()

        # Background

        self.BackgroundLabel = QtGui.QLabel('Backward')

        self.BackgroundCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.BackgroundImage = \
            self.BackwardCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.BackgroundCanvas.ax.add_patch(self.rect)
        self.BackgroundCanvas.draw()

        # 90-bank

        self.BankLabel = QtGui.QLabel('90-Bank')

        self.BankCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.BankImage = self.BankCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.BankCanvas.ax.add_patch(self.rect)
        self.BankCanvas.draw()

        # noise

        self.NoiseLabel = QtGui.QLabel('Noise')

        self.NoiseCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.NoiseImage = self.NoiseCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.NoiseCanvas.ax.add_patch(self.rect)
        self.NoiseCanvas.draw()

        # ComboBox 2D/3D

        self.BankComboBox = QtGui.QComboBox()
        self.BankComboBox.addItem('2D')
        self.BankComboBox.addItem('3D')
        self.filexy = ['img/XY ++.png', 'img/XY +-.png']
        self.filext = ['img/XT ++.png', 'img/XT +-.png']
        _index = self.BankComboBox.currentIndex()

        # Small-angle Bank

        self.SmallLabel = QtGui.QLabel('90-Bank')

        self.SmallCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.SmallImage = self.SmallCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.SmallCanvas.ax.add_patch(self.rect)
        self.SmallCanvas.draw()

        # Holder

        self.HolderLabel = QtGui.QLabel('Noise')

        self.HolderCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.HolderImage = \
            self.HolderCanvas.ax.pcolormesh(self.dataxyY, self.dataxyX,
                self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.HolderCanvas.ax.add_patch(self.rect)
        self.HolderCanvas.draw()

        # ComboBox 2D/3D

        self.SmallComboBox = QtGui.QComboBox()
        self.SmallComboBox.addItem('2D')
        self.SmallComboBox.addItem('3D')
        self.filexy = ['img/XY ++.png', 'img/XY +-.png']
        self.filext = ['img/XT ++.png', 'img/XT +-.png']
        _index = self.SmallComboBox.currentIndex()

        self.mainGrid.addWidget(self.LeftLabel, 0, 0, 1, 1)
        self.mainGrid.addWidget(self.RightLabel, 0, 1, 1, 1)
        self.mainGrid.addWidget(self.BackwardLabel, 1, 0, 1, 1)
        self.mainGrid.addWidget(self.BackgroundLabel, 1, 1, 1, 1)
        self.mainGrid.addWidget(self.BackwardCanvas, 2, 0, 1, 1)
        self.mainGrid.addWidget(self.BackgroundCanvas, 2, 1, 1, 1)
        self.mainGrid.addWidget(self.BackwardComboBox, 2, 2, 1, 1)
        self.mainGrid.addWidget(self.BankLabel, 3, 0, 1, 1)
        self.mainGrid.addWidget(self.NoiseLabel, 3, 1, 1, 1)
        self.mainGrid.addWidget(self.BankCanvas, 4, 0, 1, 1)
        self.mainGrid.addWidget(self.NoiseCanvas, 4, 1, 1, 1)
        self.mainGrid.addWidget(self.BankComboBox, 4, 2, 1, 1)
        self.mainGrid.addWidget(self.SmallLabel, 5, 0, 1, 1)
        self.mainGrid.addWidget(self.HolderLabel, 5, 1, 1, 1)
        self.mainGrid.addWidget(self.SmallCanvas, 6, 0, 1, 1)
        self.mainGrid.addWidget(self.HolderCanvas, 6, 1, 1, 1)
        self.mainGrid.addWidget(self.SmallComboBox, 6, 2, 1, 1)


