#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.26

Calibration

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *


class CSNSCalibrationPage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSCalibrationPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        # Background

        _xsize = 5
        _ysize = 0.8

        # Background

        self.BackgroundLabel = QtGui.QLabel('Background')
        self.CountBackgroundLabel = QtGui.QLabel('Count')
        self.LoadBackgroundLabel = QtGui.QLabel('Load')
        self.TOFBackgroundLabel = QtGui.QLabel('TOF')

        self.BackgroundImageCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.filexy = ['img/XY ++.png', 'img/XY +-.png']

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[0], 1, 1)
        self.BackgroundImage = \
            self.BackgroundImageCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle(
            (0, 0),
            0,
            0,
            facecolor='None',
            edgecolor='black',
            alpha=0.8,
            zorder=2,
            )
        self.BackgroundImageCanvas.ax.add_patch(self.rect)
        self.BackgroundImageCanvas.draw()

        # Noise

        self.NoiseLabel = QtGui.QLabel('Noise')
        self.CountNoiseLabel = QtGui.QLabel('Count')
        self.LoadNoiseLabel = QtGui.QLabel('Load')
        self.TOFNoiseLabel = QtGui.QLabel('TOF')
        self.NoiseCanvas = CSNSCanvas(self, _xsize, _ysize)

        (nx, dataX) = CSNSRead2DData('./dat/monitor.dat')
        self.NoiseCanvas.ax.plot(dataX[0], dataX[1], color='red')
        self.NoiseCanvas.ax.tick_params(axis='both', which='major',
                labelsize=5)
        self.NoiseCanvas.draw()

        # Holder

        self.HolderLabel = QtGui.QLabel('Holder')
        self.CountHolderLabel = QtGui.QLabel('Count')
        self.LoadHolderLabel = QtGui.QLabel('Load')
        self.TOFHolderLabel = QtGui.QLabel('TOF')
        self.HolderCanvas = CSNSCanvas(self, _xsize, _ysize)

        (self.dataxtX, self.dataxtY, self.dataxtZ) = \
            CSNSReadImage2Matrix(self.filexy[0], 1, 0.4)
        self.HolderImage = \
            self.HolderCanvas.ax.pcolormesh(self.dataxtY, self.dataxtX,
                self.dataxtZ, cmap=cm.hot)
        self.HolderCanvas.draw()

        # Efficience

        self.EfficienceLabel = QtGui.QLabel('Efficience')
        self.CountEfficienceLabel = QtGui.QLabel('Count')
        self.LoadEfficienceLabel = QtGui.QLabel('Load')
        self.TOFEfficienceLabel = QtGui.QLabel('TOF')
        self.EfficienceCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.dataXTx = []
        for i in range(1, self.dataxtY.shape[0]):
            self.dataXTx.append(self.dataxtY[0][i])
        self.dataXTy = []
        for i in range(1, self.dataxtX.shape[0]):
            self.dataXTy.append(self.dataxtX[i][0])

        self.EfficienceFigure = \
            self.EfficienceCanvas.ax.plot(self.dataXTx,
                (self.dataxtZ[40])[:], color='red')
        self.EfficienceCanvas.draw()

        self.mainGrid.addWidget(
            self.BackgroundLabel,
            0,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(self.CountBackgroundLabel, 0, 0, 1, 1)
        self.mainGrid.addWidget(self.LoadBackgroundLabel, 0, 2, 1, 1)
        self.mainGrid.addWidget(self.BackgroundImageCanvas, 1, 1, 1, 1)
        self.mainGrid.addWidget(self.TOFBackgroundLabel, 1, 2, 1, 1)
        self.mainGrid.addWidget(
            self.NoiseLabel,
            2,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(self.CountNoiseLabel, 2, 0, 1, 1)
        self.mainGrid.addWidget(self.LoadNoiseLabel, 2, 2, 1, 1)
        self.mainGrid.addWidget(self.NoiseCanvas, 3, 1, 1, 1)
        self.mainGrid.addWidget(self.TOFNoiseLabel, 3, 2, 1, 1)
        self.mainGrid.addWidget(
            self.HolderLabel,
            4,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(self.CountHolderLabel, 4, 0, 1, 1)
        self.mainGrid.addWidget(self.LoadHolderLabel, 4, 2, 1, 1)
        self.mainGrid.addWidget(self.HolderCanvas, 5, 1, 1, 1)
        self.mainGrid.addWidget(self.TOFHolderLabel, 5, 2, 1, 1)
        self.mainGrid.addWidget(
            self.EfficienceLabel,
            6,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.mainGrid.addWidget(self.CountEfficienceLabel, 6, 0, 1, 1)
        self.mainGrid.addWidget(self.LoadEfficienceLabel, 6, 2, 1, 1)
        self.mainGrid.addWidget(self.EfficienceCanvas, 7, 1, 1, 1)
        self.mainGrid.addWidget(self.TOFEfficienceLabel, 7, 2, 1, 1)


