#!/usr/bin/python
# -*- coding: utf-8 -*-

import numpy as np


class TimeFrameCalculation:

    def __init__(self, lambdaMin=0.1, lambdaMax=6.0):

        # super(TimeFrameCalculation, self).__init__(lambdaMin, lambdaMax)

        self.lambdaMin = lambdaMin
        self.lambdaMax = lambdaMax

    def getTimeFrame(self):
        _npulse = 5
        pulseList = []
        for i in range(_npulse):
            pulseList.append(i * 40)

        _nchopper = 5
        chopperList = [0, 6.395, 8.359, 9.923, 12]

        timeList = []
        for i in range(_nchopper):
            timeList.append([])
            timeList[i].append(0)
            for j in range(_npulse):
                _t0 = j * 40
                _t1 = chopperList[i] * self.lambdaMin / 3.9562
                _t2 = chopperList[i] * self.lambdaMax / 3.9562
                timeList[i].append(_t0 + _t1)
                timeList[i].append(_t0 + _t2)
            timeList[i].append((_npulse + 1) * 40)

        lineList = []

        xList = []
        yList = [0, chopperList[-1]]

        _LDC1 = chopperList[1]
        _LSAM = chopperList[-1]
        for i in range(1, len(timeList[1]) - 1):
            _tmp = _LSAM / (_LDC1 / timeList[1][i])
            for j in range(len(pulseList)):
                xList.append([pulseList[j], pulseList[j] + _tmp])

        return (pulseList, chopperList, timeList, xList, yList)


