#!/usr/bin/python
# -*- coding: utf-8 -*-

import math
from math import atan
from numpy import *
from scipy import pi
import numpy as np

# import pylab

import time
from scipy.interpolate import InterpolatedUnivariateSpline
from scipy.interpolate import UnivariateSpline
import random


def gauss(parameters, values):
    (a, x0, w, y0) = parameters
    x = values
    return a * exp(-(x - x0) ** 2 / 2 / w ** 2) + y0


nx = 100
ny = 80

dat1 = np.zeros((nx, ny))
dat2 = np.zeros((nx, ny))
dat3 = np.zeros((nx, ny))

peak = 1000
background = peak * 0.05
iwidth = 10
jwidth = 2
center1 = 26
center2 = 64

for i in range(nx):
    for j in range(ny):
        dat1[i][j] = random.uniform(0, background)
        dat2[i][j] = dat1[i][j]

_r0 = sqrt((0 - nx / 2) ** 2 / iwidth ** 2 + (0 - ny / 2) ** 2 / jwidth
           ** 2)
for i in range(nx):
    for j in range(ny):
        _r1 = sqrt((i - nx / 2) ** 2 / iwidth ** 2 + (j - center1) ** 2
                   / jwidth ** 2)
        _r2 = sqrt((i - nx / 2) ** 2 / iwidth ** 2 + (j - center2) ** 2
                   / jwidth ** 2)
        if _r1 <= sqrt(2) or _r2 <= sqrt(2):
            dat1[i][j] += peak * (1 - 0.2 / iwidth * abs(i - nx / 2))
        else:
            dat1[i][j] += peak * (1 / _r1 + 1 / _r2) * 0.2 \
                * random.uniform(0, 1)

_nx = random.randint(5, nx - 5)
_ny = random.randint(5, ny - 5)
for i in range(nx):
    for j in range(ny):
        if (i - _nx) ** 2 / 10 ** 2 + (j - _ny) ** 2 / 5 ** 2 < 1:
            dat2[i][j] += 5 * background * random.uniform(0.1, 1)
        elif j > 17 and j < 21:
            dat2[i][j] = -background

f1 = open('3d0.dat', 'w')
for i in range(nx):
    for j in range(ny):
        f1.write('%8.f\t' % dat1[i][j])
    f1.write('%s' % '\n')
f1.close()

f1 = open('3d1.dat', 'w')
for i in range(nx):
    for j in range(ny):
        f1.write('%8.f\t%8.f\t%8.f\n' % (i, j, dat1[i][j]))

f1.close()

f1 = open('detector.dat', 'w')
for i in range(nx):
    for j in range(ny):
        f1.write('%8.f\t%8.f\t%8.f\n' % (i, j, dat2[i][j]))

f1.close()

f1 = open('2d-x.dat', 'w')
for i in range(nx):
    f1.write('%f\t%8.f\n' % (i, dat1[i][int(center1)]))

f1.close()

f1 = open('2d-y.dat', 'w')
for j in range(ny):
    f1.write('%f\t%8.f\n' % (j, dat1[int(nx / 2)][j]))

f1.close()
