#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10
'''
import numpy as np
from PyQt4 import QtCore, QtGui
import patternDock
import patternDock1

class CSNSPatternPage(QtGui.QMainWindow):

    def __init__(self, parent):
        super(CSNSPatternPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):
        self.patternDock=[]
        self.patternDock.append(patternDock1.patternDock(self,
                1, 9, 0.4, 'r', 4000, 'Backward Bank'))
        self.patternDock.append(patternDock.patternDock(self,
                2, 9, 0.4, 'g', 3000, 'Medium-Angle Bank'))
        self.patternDock.append(patternDock.patternDock(self,
                3, 9, 0.4, 'b', 2000, 'Low-Angle Bank'))

        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[0])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[1])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[2])
        
        #self.setCentralWidget(self.scrollArea)
        self.pix = []
        for i in range(len(self.patternDock)):
            self.pix.append('') 

    def getPatternCanvas(self, n):
        return self.patternDock[n].getCanvas()
    
    def setStatus(self):
        return self.parent.setStatus()

    def updateCanvas(self, value, started, _command): 
        for i in range(len(self.patternDock)):
            can = self.patternDock[i].canvas
            if _command in ('configure', 'abort'):
                #can.ax.clear()
                self.pix[i] = None
            else:
                if not started:
                    pass
                else:
                    _pause = self.patternDock[i].pauseButton.text()
                    if _pause == 'Pause':
                        try:
                            #_scale = self.patternDock[i].getScale()
                            if len(value[0][i]) != len(value[1][i]):
                                pass
                            elif len(value[0][i]) == 0:
                                pass
                            else:
                                if not self.pix[i]:
                                    can.ax.clear()
                                    self.pix[i], = can.ax.plot(value[0][i], value[1][i], color=can.plotColor)
                                else:
                                    self.pix[i].set_ydata(value[1][i])
                                can.ax.set_xlabel('TOF / us')
                                can.ax.set_ylabel('Neutron Counts')
                                can.draw()
                        except:
                            pass
