#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10

Histogram

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *
from presenter.updateStreaming import *


class CSNSHistogramPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSHistogramPage, self).__init__(parent)
        self.setupUi(self)
        self.BackwardConstant = 40000
        self.MediumConstant = 30000
        self.SmallConstant = 20000

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)

        _xsize = 5
        _ysize = 0.8

        # Backward TOF/d

        self.BackwardComboBox = QtGui.QComboBox()
        self.BackwardComboBox.addItem('TOF')
        self.BackwardComboBox.addItem('d')
        self.BackwardComboBox.activated.connect(self.BackwardComboboxChoose)
        self.BackwardButton = QtGui.QPushButton('Pause') 
        self.BackwardButton.clicked.connect(self.BackwardButtonClicked)

        self.BackwardCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # 90-Bank TOF/d

        self.MediumComboBox = QtGui.QComboBox()
        self.MediumComboBox.addItem('TOF')
        self.MediumComboBox.addItem('d')
        self.MediumComboBox.activated.connect(self.MediumComboboxChoose)
        self.MediumButton = QtGui.QPushButton('Pause') 
        self.MediumButton.clicked.connect(self.MediumButtonClicked)

        self.MediumCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small-angle bank TOF/d

        self.SmallComboBox = QtGui.QComboBox()
        self.SmallComboBox.addItem('TOF')
        self.SmallComboBox.addItem('d')
        self.SmallComboBox.activated.connect(self.SmallComboboxChoose)
        self.SmallButton = QtGui.QPushButton('Pause') 
        self.SmallButton.clicked.connect(self.SmallButtonClicked)
        
        self.SmallCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Monitor TOF/d

        self.MonitorCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Backward bank 3D

        self.Backward3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Medium bank 3D

        self.Medium3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        # Small bank 3D

        self.Small3DCanvas = CSNSCanvas(
            self,
            _xsize / 4.0,
            _ysize,
            150,
            'Backward Bank',
            'TOF /mics',
            'Neutron Counts',
            )

        _nline = 0
        self.mainGrid.addWidget(self.BackwardComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.BackwardButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.BackwardCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MediumComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.MediumButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.MediumCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.SmallComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.SmallButton, _nline, 1, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(
            self.SmallCanvas,
            _nline,
            0,
            1,
            8,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.MonitorCanvas, _nline, 0, 1, 2)
        self.mainGrid.addWidget(self.Backward3DCanvas, _nline, 2, 1, 2)
        self.mainGrid.addWidget(self.Medium3DCanvas, _nline, 4, 1, 2)
        self.mainGrid.addWidget(self.Small3DCanvas, _nline, 6, 1, 2)

    def BackwardComboboxChoose(self):
        self.index = self.BackwardComboBox.currentIndex()
        if self.index == 0:
            BackwardConstant = 40000    
        elif self.index == 1:
            BackwardConstant = 1
        self.BackwardThread.setUnit(BackwardConstant)

    def MediumComboboxChoose(self):
        index = self.MediumComboBox.currentIndex()
        if index == 0:
            MediumConstant = 30000       
        elif index == 1:
            MediumConstant = 1
        self.MediumThread.setUnit(MediumConstant)

    def SmallComboboxChoose(self):
        self.index = self.SmallComboBox.currentIndex()
        if self.index == 0:
            SmallConstant = 20000       
        elif self.index == 1:
            SmallConstant = 1
        self.SmallThread.setUnit(SmallConstant)
     
    def updateBackwardStreaming(self, threadID, simulatorStreaming):
        self.BackwardThread = updateStreaming2D(self.BackwardThreadID,self.BackwardCanvas, 
                self.BackwardCanvas.ax, CSNSBackwardConstant , 'r', 
                    self.BackwardSimulatorStreaming)
        self.BackwardThread.setDaemon(True)
        self.BackwardThread.start()

    def updateMediumStreaming(self, threadID, simulatorStreaming):
        self.MediumThread = updateStreaming2D(self.MediumThreadID, self.MediumCanvas,
                self.MediumCanvas.ax,CSNSMediumConstant, 'g', self.MediumSimulatorStreaming)
        self.MediumThread.setDaemon(True)
        self.MediumThread.start()

    def updateSmallStreaming(self, threadID, simulatorStreaming):
        self.SmallThread = updateStreaming2D(self.SmallThreadID, self.SmallCanvas,
                self.SmallCanvas.ax, CSNSSmallConstant,'b', self.SmallSimulatorStreaming)
        self.SmallThread.setDaemon(True)
        self.SmallThread.start()

    def updateMonitorStreaming(self, threadID, simulatorStreaming):
        MonitorThread = updateStreamingMonitor(threadID,
                self.MonitorCanvas, self.MonitorCanvas.ax, 'y',
                simulatorStreaming)
        MonitorThread.setDaemon(True)
        MonitorThread.start()
    
    def updateBackward3DStreaming(self, threadID, simulatorStreaming):
        Backward3DThread = updateStreaming3D(threadID,
                self.Backward3DCanvas, self.Backward3DCanvas.ax,
                'Accent', simulatorStreaming)
        Backward3DThread.setDaemon(True)
        Backward3DThread.start()

    def updateMedium3DStreaming(self, threadID, simulatorStreaming):
        Medium3DThread = updateStreaming3D(threadID,
                self.Medium3DCanvas, self.Medium3DCanvas.ax, 'Spectral'
                , simulatorStreaming)
        Medium3DThread.setDaemon(True)
        Medium3DThread.start()

    def updateSmall3DStreaming(self, threadID, simulatorStreaming):
        Small3DThread = updateStreaming3D(threadID, self.Small3DCanvas,
                self.Small3DCanvas.ax, 'cool', simulatorStreaming)
        Small3DThread.setDaemon(True)
        Small3DThread.start()

    def BackwardButtonClicked(self):
        if self.BackwardButton.text()=="Pause":
            self.BackwardButton.setText("Resume")     
            
            self.BackwardThread.pause()

        elif self.BackwardButton.text()=="Resume":
            self.BackwardButton.setText("Pause")     
            
            self.BackwardThread.resume()
    
    def MediumButtonClicked(self):
        if self.MediumButton.text()=="Pause":
            self.MediumButton.setText("Resume")
            
            self.MediumThread.pause()
        
        elif self.MediumButton.text()=="Resume":
            self.MediumButton.setText("Pause")
            
            self.MediumThread.resume()     

    def SmallButtonClicked(self):
        if self.SmallButton.text()=="Resume":
            self.SmallButton.setText("Pause")     

            self.SmallThread.pause()

        elif self.SmallButton.text()=="Pause":
            self.SmallButton.setText("Resume")     
            
            self.SmallThread.resume()     
