#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2016.12.12
'''
from conf.constants import *
from canvas import *
from model.neonReceiver import *

class patternDock(QtGui.QDockWidget):  # QTabWidget):

    def __init__(
        self,
        parent,
        number,
        width,
        height,
        plotColor,
        plotScale,
        title,
        ):
        super(patternDock, self).__init__(parent)

        self.parent = parent
        self.number = number
        self.width = width
        self.height = height
        self.plotColor = plotColor
        self.plotScale = plotScale
        self.title = title

        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):

        self.setFeatures(QtGui.QDockWidget.DockWidgetFloatable
                         | QtGui.QDockWidget.DockWidgetMovable)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        # main  grid
        self.mainGrid = QtGui.QGridLayout(self.first)

        # Backward TOF/d
        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('TOF')
        self.comboBox.addItem('d')
        self.comboBox.addItem('Q')
        self.comboBox.setFixedSize(QtCore.QSize(60, 20))
        #self.comboBox.activated.connect(self.comboSelected)

        self.pauseButton = QtGui.QPushButton('Pause')
        #self.pauseButton.setEnabled(False)
        self.pauseButton.setFixedSize(QtCore.QSize(60, 20))    
        self.pauseButton.clicked.connect(self.pauseButtonClicked)

        self.saveButton = QtGui.QPushButton('Save')
        #self.saveButton.setEnabled(False)
        self.saveButton.setFixedSize(QtCore.QSize(60, 20))
        self.saveButton.clicked.connect(self.saveButtonClicked)

        self.normLabel = QtGui.QLabel('Normalization by')
        self.normLabel.setMaximumWidth(110)
        self.comboBoxNorm = QtGui.QComboBox()
        self.comboBoxNorm.addItem('Monitor')
        self.comboBoxNorm.addItem('Proton Charge')
        self.comboBoxNorm.addItem('Raw Data')
        self.comboBoxNorm.setMaximumWidth(130)
        self.comboBoxNorm.activated.connect(self.parent.parent.tabChange)

        self.canvas = figureCanvas(
            self,
            self.width,
            self.height,
            150,
            self.plotColor,
            self.title,
            'TOF /mics',
            'Neutron Counts',
            )

        self.label = QtGui.QLabel(self.title)

        _nline = 0
        self.mainGrid.addWidget(self.comboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.pauseButton, _nline, 1, 1, 1)
        self.mainGrid.addWidget(self.saveButton, _nline, 2, 1, 1)
        self.mainGrid.addWidget(self.normLabel, _nline, 3, 1, 1)
        self.mainGrid.addWidget(self.comboBoxNorm, _nline, 4, 1, 1)
        self.mainGrid.addWidget(self.label, _nline, 6, 1, 2, QtCore.Qt.AlignCenter)
        _nline += 1
        self.mainGrid.addWidget(
            self.canvas,
            _nline,
            0,
            1,
            10,
            #QtCore.Qt.AlignLeft,
            )

        #_nline += 1

        self.setWidget(self.scrollArea)

        # self.setCentralWidget(self)

    def getIndex(self):
        index = self.comboBox.currentIndex()
        return index

    def normSelected(self):
        index = self.comboBoxNorm.currentIndex()
        #self.parent.tabChange()
        return index

    def getScale(self):
        index = self.getIndex()
        if index == 0:
            _scale = 1#self.plotScale
        elif index == 1:
            _scale = 1
        else:
            _scale = 3
        return _scale

    def pauseButtonClicked(self):
        if self.pauseButton.text() == 'Resume':
            self.pauseButton.setText('Pause')
        elif self.pauseButton.text() == 'Pause':
            self.pauseButton.setText('Resume')
        self.parent.setStatus()    

    def saveButtonClicked(self):
        _name = 'save/histogram' + str(self.number) +'.png'
        self.canvas.fig.savefig(_name)
        logging.info("save pixture as " + _name)

