#!/usr/bin/python
# -*- coding: utf-8 -*-
import numpy as np
import json
import base64


class numpyEncoder(json.JSONEncoder):

    def default(self, obj):
        if isinstance(obj, np.ndarray):
            if obj.flags['C_CONTIGUOUS']:
                obj_data = obj.data
            else:
                cont_obj = np.ascontiguousarray(obj)
                assert cont_obj.flags['C_CONTIGUOUS']
                obj_data = cont_obj.data
            data_b64 = base64.b64encode(obj_data)
            return dict(__ndarray__=data_b64, dtype=str(obj.dtype),
                        shape=obj.shape)
        return json.JSONEncoder(self, obj)


def numpyDecoder(obj):
    if isinstance(obj, dict) and '__ndarray__' in obj:
        data = base64.b64decode(obj['__ndarray__'])
        return np.frombuffer(data, obj['dtype']).reshape(obj['shape'])
    return obj


def jsonEncoder(array_data):
    return json.dumps(array_data, cls=numpyEncoder)


def jsonDecoder(json_data):
    return json.loads(json_data, object_hook=numpyDecoder)


