#!/usr/bin/python
# -*- coding: utf-8 -*-

# from PyQt4 import QtCore, QtGui
# from PyQt4 import Qt

import json
import time
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure
from redis.sentinel import Sentinel

from conf.constants import *
from model import neonReceiver
from viewer import canvas

class CSNSUserInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSUserInfo, self).__init__(parent)
        self.setupUi(self)

        self.parent = parent
        self.controlThread = None

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        '''
        self.expe = QtGui.QFrame(self)
        self.expe.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreaexpe = QtGui.QScrollArea()
        self.scrollAreaexpe.setWidgetResizable(True)
        self.scrollAreaexpe.setWidget(self.expe)
        '''

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreafirst = QtGui.QScrollArea()
        self.scrollAreafirst.setWidgetResizable(True)
        self.scrollAreafirst.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreasecond = QtGui.QScrollArea()
        self.scrollAreasecond.setWidgetResizable(True)
        self.scrollAreasecond.setWidget(self.second)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreathird = QtGui.QScrollArea()
        self.scrollAreathird.setWidgetResizable(True)
        self.scrollAreathird.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        #self.splitter.addWidget(self.scrollAreaexpe)
        self.splitter.addWidget(self.scrollAreafirst)
        self.splitter.addWidget(self.scrollAreasecond)
        self.splitter.addWidget(self.scrollAreathird)
        self.splitter.setSizes([150, 270, 230])

        #self.expeGrid = QtGui.QGridLayout(self.expe)
        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.thirdGrid = QtGui.QGridLayout(self.third)

    	# main verticalLayout
        self.GPPDLabel = QtGui.QLabel('<font color=red>GPPD</font>')
        self.GPPDLabel.setFont(QtGui.QFont('Roman times', 20,
                               QtGui.QFont.Bold))
        self.spectLabel = QtGui.QLabel('<font color=black>Instrument Scientist: Lunhua He(123)</font>')
        self.developLabel = QtGui.QLabel('<font size=2 color=black>Software Engineer: Lili Yan(347)</font>')

        self.verticalLayout.addWidget(self.GPPDLabel)
        self.verticalLayout.addWidget(self.spectLabel)
        self.verticalLayout.addWidget(self.developLabel)
        self.verticalLayout.addWidget(self.splitter)

        '''
        # experiment Grid
        self.expeLabel = QtGui.QLabel('Experiment simulating ', self.expe)
        self.expeTimer = QtCore.QTimer(self)
        self.labelConstant = True
        self.expeTimer.timeout.connect(self.changeColor)
        self.expeTimer.start(1000)
        '''

    	# first Grid
        self.userIDLabel = QtGui.QLabel('UserID: ', self.first)
        self.userIDText = QtGui.QLabel('--------', self.first)

        self.runNoLabel = QtGui.QLabel('RunNo: ', self.first)
        self.runNoText = QtGui.QLabel('--------', self.first)

        self.proposalLabel = QtGui.QLabel('ProposalID: ', self.first)
        self.proposalText = QtGui.QLabel('--------', self.first)

    	# second Grid
        self.neonLabel = QtGui.QLabel('NEON', self.second)
        self.neonConnectLabel = QtGui.QLabel('Connect',
                self.second)
        self.neonConnectLabel.setFixedSize(QtCore.QSize(80, 30))
        #self.neonConnectButton.clicked.connect(self.connectButtonClicked)

        self.commandLabel = QtGui.QLabel('Command: ', self.second)

        self.commandTimeLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel.setStyleSheet("color:green")
        
        self.statusLabel = QtGui.QLabel('Status: ', self.second)
        self.statusTimeLabel = QtGui.QLabel('', self.second)
        self.statusValueLabel = QtGui.QLabel('None', self.second)
        self.statusValueLabel.setStyleSheet("color:blue")

        # third Grid
        with plt.xkcd():
            self.runCanvas=canvas.xkcdFigure(self)

        self.expTimeLabel = \
            QtGui.QLabel('<font color=red>Running Time:</font>')
        self.expTimeText = QtGui.QLabel('<font color=red></font>')

        self.startTime=time.time()
        self.runTimer = QtCore.QTimer(self)
        self.runTimer.setInterval(1000)
        self.runTimer.timeout.connect(self.setRunTime)
        self.runTimer.start()

        self.protonLabel = QtGui.QLabel('Proton Charge: ')
        self.protonText = QtGui.QLabel('-----')

        self.neutronLabel = QtGui.QLabel('Neutron Counts: ')
        self.neutronText = QtGui.QLabel('-----')

        #_nline = 0
        #self.expeGrid.addWidget(self.expeLabel, _nline, 0, 1, 1, QtCore.Qt.AlignCenter)

        _nline = 0
        self.firstGrid.addWidget(self.userIDLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.userIDText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.runNoLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.runNoText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.proposalLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.proposalText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline = 0
        self.secondGrid.addWidget(self.neonLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.neonConnectLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        
        _nline += 1
        self.secondGrid.addWidget(self.commandLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.commandValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.commandTimeLabel, _nline, 1, 1, 2, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        
        _nline += 1
        self.secondGrid.addWidget(self.statusLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.statusValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.statusTimeLabel, _nline, 1, 1, 2, QtCore.Qt.AlignLeft|QtCore.Qt.AlignTop)

        _nline += 1
        self.thirdGrid.addWidget(
            self.expTimeLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.expTimeText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.protonLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.protonText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.neutronLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.neutronText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.runCanvas,
            _nline,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        self.thirdGrid.addItem(QtGui.QSpacerItem(-1, -1,
                               QtGui.QSizePolicy.Ignored,
                               QtGui.QSizePolicy.Expanding), 2, 0)

        #timen=str(datetime.datetime.now())
        #self.setCommandTimeLabel(timen)

        #self.setCommandValueLabel('<font color=green>Start</font>')
        
        #timen=timen+21.4
        #self.setStatusTimeLabel(timen)
        #self.setStatusValueLabel('<font color=red>Running</font>')

        self.dataThread = False

    '''
    def changeColor(self):
        if (self.labelConstant):
            self.expeLabel.setText('<font color=black>Experiment simulating </font>')
            self.expeLabel.setFont(QtGui.QFont("Roman times",10,QtGui.QFont.Bold))
            self.labelConstant=False
        else:
            self.expeLabel.setText('<font color=green>Experiment simulating </font>')
            self.expeLabel.setFont(QtGui.QFont("Roman times",13,QtGui.QFont.Bold))
            self.labelConstant=True
    '''

    def setNeonStatus(self, value):
        if value:
            self.neonConnectLabel.setText('Connected')
        else:
            self.neonConnectLabel.setText('Disconnected')

    def getIP_PORT(self):
        _ip = '10.1.33.141'
        _ip_port = [(_ip, 9001), (_ip,9011), (_ip,9021)]
        return _ip_port

    def getNeon(self):
        status=False
        server=None

        _timeout=10
        _ip_port=self.getIP_PORT()
        _passwd='sanlie;123'
        _r=neonReceiver.connectNeon(_ip_port, _passwd, _timeout)
        status=_r.getStatus()
        server=_r.getServer()
        
        return status, server

    '''
    def connectButtonClicked(self):
        if self.neonConnectButton.text() == 'Connect':
            status, server = self.getNeon()
            if status:
                self.neonConnectButton.setText('Disconnect')
                logging.info("NEON connected.")
                if not self.dataThread:
                    self.dataThread = self.parent.createThread()
                    
        elif self.neonConnectButton.text() == 'Disconnect':
            status=False
            server=None
            self.neonConnectButton.setText('Connect')
            logging.info("NEON disconnected.")
    '''

    def setUserInfo(self, value):
        _value = json.loads(str(value))
        self.userIDText.setText(_value['userID'])
        self.runNoText.setText(_value['runNo'])
        self.proposalText.setText(_value['proposalID'])

    # get from neon
    def setCommandLabel(self, value):
        _timen=str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        self.setCommandTimeLabel(_timen)
        self.setCommandValueLabel(value)

    def setCommandTimeLabel(self, time):
        self.commandTimeLabel.setText(time)

    def setCommandValueLabel(self, value):
        self.commandValueLabel.setText(value)
    
    # get from neon
    def setStatusLabel(self, value):
        myStatus = self.statusValueLabel.text()
        _timen=str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        if myStatus != value: 
            self.setStatusTimeLabel(_timen)
            self.setStatusValueLabel(value)
            logging.info(str("status is " + value + ' now')) 

    def setStatusTimeLabel(self, time):
        self.statusTimeLabel.setText(time)

    def setStatusValueLabel(self, value):
        self.statusValueLabel.setText(value)
    
    def setRunTime(self):
        if self.parent.myCommand == 'start':
            _during=int(time.time()-self.startTime)
            self.expTimeText.setText(str(_during))
        else:
            self.expTimeText.setText(str(0))

    def setProtonNeutron(self, _proton, _neutron):
        self.protonText.setText("-----")
        self.neutronText.setText("-----")
        #self.protonText.setText(str(_proton))
        #self.neutronText.setText(str(_neutron))

    def updateMonitorCanvas(self, xdata, ydata):
        try:
            self.runCanvas.ax.clear()
            #self.runCanvas.ax.set_xdata(xdata)
            #self.runCanvas.ax.set_ydata(ydata)
            self.runCanvas.ax.plot(xdata, ydata, color="g")
            self.runCanvas.ax.relim()
            self.runCanvas.ax.autoscale_view()
            self.runCanvas.draw()
            self.runCanvas.flush_events()
        except:
            pass
