#!/usr/bin/python
# -*- coding: utf-8 -*-

from conf.constants import *
from canvas import *
import time

class CSNSDetectorPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSDetectorPage, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):

        self.verticalLayout = QtGui.QVBoxLayout(self)
        
        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([100, 200])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
	
        #first Grid
        _width = 15
        _height = 15
        self.buttonList=[131,132,133,# 0, 1, 2
                        231,232,233, # 3, 4, 5
                        322,         # 6
                        331,332,333, # 7, 8, 9
                        341,342,343, #10,11,12
                        422,         #13,
                        431,432,433, #14,15,16
                        441,442,443, #17,18,19
                        521,522,523, #20.21.22
                        531,532,533, #23,24,25
                        541,542,543, #26,27,28
                        621,622,623, #29,30,31
                        631,632,633, #32,33,34
                        641,642,643] #35,36,37
        for i in range(len(self.buttonList)):
            self.buttonList[i] = BankButton(self,'img/module_off.png', _width, _height)
        
        self.camera = BankButton(self,'img/camera.png', _width, _height)
        self.sample = BankButton(self,'img/sample.png', _width, _height)
        self.monitor = BankButton(self,'img/monitor.png', _width, _height)
        
        self.blank5 = BankButton(self,'blank.png', _width, _height)
        self.blank9 = BankButton(self,'blank.png', _width, _height)
	
        self.RadioGroup = QtGui.QButtonGroup()
        for i in range(len(self.buttonList)):
            self.RadioGroup.addButton(self.buttonList[i])
        self.RadioGroup.buttonClicked.connect(self.buttonClicked)

        self.blank1 = QtGui.QLabel("                               ---------------------------------------------->", self.first)
        self.blank1.setMinimumWidth(460)
        self.blank2 = QtGui.QLabel(self.first)
        self.blank2.setMinimumWidth(460)
	
        #second Grid
        self.bankCombo = QtGui.QComboBox()
        self.bankCombo.addItem('PID')
        self.bankCombo.addItem('XY')
        self.bankCombo.setCurrentIndex(1)
        self.bankCombo.activated.connect(self.comboSelected)

        _xsize = 16
        _ysize = 8
        self.pidCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            'Neutron Distribution',
            'SpecNo',
            #'TOF / us',
            )
        self.xyCanvas = figureCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Accent'
            'Neutron Distribution',
            'SpecNo',
            #'TOF / us',
            )
        self.rect = Rectangle((0,0), 0, 0, facecolor='None', edgecolor='black', alpha=0.8,zorder=5)
        self.xyCanvas.ax.add_patch(self.rect)
        self.xyCanvas.draw()
        
        self.zoomEvents()

        self.tofLabel = QtGui.QLabel("TOF / mm")
        #self.xMinLabel = QtGui.QLabel("")
        #self.xMaxLabel = QtGui.QLabel("")
        #self.yMinLabel = QtGui.QLabel("")
        #self.yMaxLabel = QtGui.QLabel("")

        _nline = 0
        self.firstGrid.addWidget(self.blank5, _nline, 5, 1,1)
        self.firstGrid.addWidget(self.blank9, _nline, 9, 1,1)
        self.firstGrid.addWidget(self.buttonList[10], _nline, 6, 1,1)
        self.firstGrid.addWidget(self.buttonList[11], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[12], _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[28], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[25], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[22], _nline, 4, 1,1)
        self.firstGrid.addWidget(self.buttonList[7], _nline, 6, 1,1)
        self.firstGrid.addWidget(self.buttonList[8], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[9], _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[27], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[24], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[21], _nline, 4, 1,1)
        self.firstGrid.addWidget(self.buttonList[6], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[0], _nline, 10, 1,1)
        self.firstGrid.addWidget(self.buttonList[1], _nline, 11, 1,1)
        self.firstGrid.addWidget(self.buttonList[2], _nline, 12, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[26], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[23], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[20], _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.monitor, _nline, 1, 1,1)
        self.firstGrid.addWidget(self.sample, _nline, 7, 1,1)
        self.firstGrid.addWidget(self.camera, _nline, 13, 1,1)
        self.firstGrid.addWidget(self.blank1, _nline, 0, 1,1)
        self.firstGrid.addWidget(self.blank2, _nline, 14, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[37], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[34], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[31], _nline, 4, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[36], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[33], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[30], _nline, 4, 1,1)
        self.firstGrid.addWidget(self.buttonList[13], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[3], _nline, 10, 1,1)
        self.firstGrid.addWidget(self.buttonList[4], _nline,11, 1,1)
        self.firstGrid.addWidget(self.buttonList[5], _nline, 12, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[35], _nline, 2, 1,1)
        self.firstGrid.addWidget(self.buttonList[32], _nline, 3, 1,1)
        self.firstGrid.addWidget(self.buttonList[29], _nline, 4, 1,1)
        self.firstGrid.addWidget(self.buttonList[16], _nline, 6, 1,1)
        self.firstGrid.addWidget(self.buttonList[15], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[14], _nline, 8, 1,1)
        _nline += 1
        self.firstGrid.addWidget(self.buttonList[19], _nline, 6, 1,1)
        self.firstGrid.addWidget(self.buttonList[18], _nline, 7, 1,1)
        self.firstGrid.addWidget(self.buttonList[17], _nline, 8, 1,1)
        _nline += 1
        self.secondGrid.addWidget(self.bankCombo, _nline, 2, 1,1)
        _nline += 1
        self.secondGrid.addWidget(self.pidCanvas, _nline, 1, 1,1)#, QtCore.Qt.AlignCenter)
        self.secondGrid.addWidget(self.xyCanvas, _nline, 1, 1,1)#, QtCore.Qt.AlignCenter)
        _nline += 1
        self.secondGrid.addWidget(self.tofLabel, _nline, 1, 1,1,QtCore.Qt.AlignCenter)
        self.pidCanvas.hide()
        self.xyCanvas.show()
        self.verticalLayout.addWidget(self.splitter)
        
        self.buttonIndex = 34
        self.buttonList[34].setIcon(QtGui.QIcon('img/module_on.png'))
        self.buttonChange = True
        self.comboIndex = 1   
        self.testTime = 0

        self.roi = None
        self.zoomClick = False
        self.zoomSelected = False
        self.minX = 0
        self.maxX = 0
        self.minY = 0
        self.maxY = 0

        self.font={ 'family': 'serif',
                    'color':  'red',
                    'weight': 'normal',
                    'size': 7,
                    }

    def getComboIndex(self):
        self.comboIndex = self.bankCombo.currentIndex()    
        return self.comboIndex    

    def getButtonIndex(self):
        return self.buttonIndex
    
    def getDetectorIndex(self):
        buttonIndex = self.getButtonIndex()
        comboIndex = self.getComboIndex()
        return buttonIndex, comboIndex

    def comboSelected(self):
        comboIndex = self.getComboIndex()
        #buttonIndex = self.getButtonIndex()
        self.parent.tabChange()
        if comboIndex==0:
            self.pidCanvas.show()
            self.xyCanvas.hide()
        else:
            self.pidCanvas.hide()
            self.xyCanvas.show()

    def buttonClicked(self):
        self.testTime = time.time()
        comboIndex = self.getComboIndex()
        self.buttonReset()
        for i in range (len(self.buttonList)):
            if self.buttonList[i].isChecked():
                self.buttonList[i].setIcon(QtGui.QIcon('img/module_on.png'))
                buttonIndex=i
        self.buttonIndex = buttonIndex
        self.buttonChange = True
        self.zoomSelected = False
        self.parent.tabChange()

    def zoomEvents(self):
        self.xyCanvas.mpl_connect('button_press_event',   self.zoomFigurePress)
        self.xyCanvas.mpl_connect('button_release_event', self.zoomFigureRelease)
        self.xyCanvas.mpl_connect('motion_notify_event',  self.zoomFigureMove)

    def zoomFigurePress(self,event):
        if event.button==1:
            self.zoomClick=True
            self.zoomSelected = True
            self.x1 = event.xdata
            self.y1 = event.ydata
            print self.x1
        elif event.button==3:
            self.xyCanvas.ax.autoscale(enable=True)
            self.xyCanvas.draw()
            self.zoomSelected = False
        else:
            return

    def zoomFigureMove(self, event):
        if event.button==1 and self.zoomClick==True and self.x1 and self.y1 and event.xdata and event.ydata:

            self.rect.set_x(self.x1)
            self.rect.set_y(self.y1)
            self.rect.set_width(event.xdata - self.x1)
            self.rect.set_height(event.ydata - self.y1)
            #self.rect.set_xy((self.x0, self.y0))
            self.xyCanvas.draw()
        else:
            return

    def zoomFigureRelease(self, event):
        self.zoomClick=False

        if event.button==1 and self.x1 and self.y1 and event.xdata and event.ydata:
            self.x2 = event.xdata
            self.y2 = event.ydata
            print self.x2
            #self.rect.set_width(0)
            #self.rect.set_height(0)

            self.minX=min(self.x1,self.x2)
            self.maxX=max(self.x1,self.x2)
            if self.minX != self.maxX:
                self.xyCanvas.ax.set_xlim(self.minX, self.maxX)
            self.minY=min(self.y1,self.y2)
            self.maxY=max(self.y1,self.y2)
            if self.minY != self.maxY:
                self.xyCanvas.ax.set_ylim(self.minY, self.maxY)
            self.xyCanvas.draw()
        else:
            return
 
    def updateBankCanvas(self, value, started, _command):
        self.pidCanvas.ax.clear()
        if _command in ('configure', 'abort'):
            pass
        else:
            if not started:
                pass
            else:
                _buttonIndex=self.getButtonIndex()
                _comboIndex=self.getComboIndex()
                if _buttonIndex in (0,1,2,3,4,5):
                    color2D = 'c'
                    color3D = 'Greens'
                elif _buttonIndex   in (6,7,8,9,10,11,12,13,14,15,16,17,18,19):
                    color2D = 'r'
                    color3D = 'Blues'
                elif _buttonIndex in (20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37):
                    color2D = 'y'
                    color3D = 'gist_heat'
                # PID 2D Bar
                if _comboIndex==0:
                    try:
                        #self.pidCanvas.ax.bar(_x,value,0.5,color='r')
                        #self.pidCanvas.ax.axis('scaled')
                        #self.pidCanvas.ax.hist(value[1], color=color2D)
                        self.pidCanvas.ax.plot(value[1], color=color2D)
                    except:
                        pass
                    self.pidCanvas.draw()
                # XY 3D Image
                elif _comboIndex==1:
                    try:
                        if self.buttonChange or self.roi == None:
                            self.xyCanvas.ax.clear()
                            self.rect = Rectangle((0,0), 0, 0, facecolor='None', edgecolor='black', alpha=0.8,zorder=5)
                            self.xyCanvas.ax.add_patch(self.rect)
                            self.xyCanvas.ax.axis('equal', adjustable='box')
                            self.roi=self.xyCanvas.ax.pcolormesh(value[0], value[1], value[2], cmap=color3D)
                            lowerX,upperX = self.xyCanvas.ax.get_xbound()
                            lowerY,upperY = self.xyCanvas.ax.get_ybound()
                            self.xyCanvas.ax.text(lowerX,lowerY-10,str(int(lowerX)),fontdict=self.font)
                            self.xyCanvas.ax.text(upperX-15,lowerY-10,str(int(upperX)),fontdict=self.font)
                            self.xyCanvas.ax.text(lowerX-15,lowerY,str(int(lowerY)),fontdict=self.font)
                            self.xyCanvas.ax.text(lowerX-15,upperY,str(int(upperY)),fontdict=self.font)
                        else:
                            self.roi.set_array(z.ravel())
                            self.buttonChange = False

                        if self.zoomSelected and (self.minX != self.maxX) and (self.minY != self.maxY):
                            print self.minX,self.maxX
                            self.xyCanvas.ax.set_xlim(self.minX, self.maxX)
                            self.xyCanvas.ax.set_ylim(self.minY, self.maxY)
                            self.xyCanvas.ax.text(self.minX,self.minY-5,str(int(self.minX)),fontdict=self.font)
                            self.xyCanvas.ax.text(self.maxX,self.minY-5,str(int(self.maxX)),fontdict=self.font)
                            self.xyCanvas.ax.text(self.minX-5,self.minY,str(int(self.minY)),fontdict=self.font)
                            self.xyCanvas.ax.text(self.minX-5,self.maxY,str(int(self.maxY)),fontdict=self.font)
                        #self.xyCanvas.draw()
                    except:
                        pass
                    self.xyCanvas.draw()
        plt.pause(0.0001)
        print "Time spent:", time.time()-self.testTime

    def buttonReset(self):
        for i in range (len(self.buttonList)):
            self.buttonList[i].setIcon(QtGui.QIcon('img/module_off.png')) 

class BankButton(QtGui.QPushButton):

    def __init__(
        self,
        parent=None,
        img='',
        width=20,
        height=20,
        ):
        super(BankButton,self).__init__(parent)
	
        #self.img = img
        #self.width = width
        #self.height = height
        self.setFlat(True)
        self.setStyleSheet("border:none;outline:none")
        self.setIcon(QtGui.QIcon(img))
        self.setIconSize(QtCore.QSize(width,height))
        self.setCheckable(True)
