from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy as np

class getCommand(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    signalLog = QtCore.pyqtSignal(str)
 
    def __init__(self, parent, neonServer, commandPath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.commandPath = commandPath
        self.refreshTime = refreshTime
        self.command=True
        self.userInfo=None
        self.logNum=0
    
    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            #get command from neon
            if not self.command: break
            try:
                _command = self.neonServer.get(self.commandPath)
                if _command is None:
                    if self.logNum == 0:
                        self.signalLog.emit("Empty command from NEON!")
                        self.logNum += 1
                else:
                    try:
                        self.signalStatus.emit(_command)
                    except:
                        pass
            except:
                pass
            try: 
                time.sleep(self.refreshTime) 
            except:
                pass
        try: 
            self.finished.emit()            
        except:
            pass

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command

class getNeonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalProgress = QtCore.pyqtSignal(str)
    signalStatus = QtCore.pyqtSignal(object)
    signalMonitor = QtCore.pyqtSignal(object)
    signalExperiment = QtCore.pyqtSignal(object)#,object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, neonServer, progressPath, protonPath, neutronValuePath, pulseValuePath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.progressPath = progressPath
        self.protonPath = protonPath
        self.neutronValuePath = neutronValuePath
        self.pulseValuePath = pulseValuePath
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0
        self.monitorTOFPath = '/GPPD/workspace/MantidData/monitor02/tof'
        self.monitorCountsPath = '/GPPD/workspace/MantidData/monitor02/counts'
        self.monitorTOF=[]

        self.pidXaxis=[]
        self.xyXaxis=[]
        self.xyYaxis=[]
        for i in range(38):
            self.pidXaxis.append([])
            self.xyXaxis.append([])
            self.xyYaxis.append([])
        
        self.progressLog = 0 
        self.monitorTOFLog = 0
        self.monitorCountsLog = 0
        self.protonLog = 0
        self.neurontLog = 0
        self.pidLog = 0
        self.xyLog = 0
        self.expLog = 0
        self.hisLog = 0

    def __del__(self):
        self.wait()

    def pause(self):
        self.started=False

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def resume(self):
        if not self.started:
            self.started = True

    @QtCore.pyqtSlot()
    def process(self):
        # progress setting in mainSet
        try:
            #get json date after json.dumps from neon
            progress = self.neonServer.get(self.progressPath)
            if progress is None:
                if self.progressLog == 0:
                    self.signalLog.emit("Empty progressBar Setting Data!")
                    self.progressLog += 1
            else:
                try:
                    self.signalProgress.emit(progress)
                except:
                    pass
        except:
            pass 

        # Monitor TOF in User Panel 
        try:
            _data = self.neonServer.get(self.monitorTOFPath)
            if _data is None:
                if self.monitorTOFLog == 0:
                    self.signalLog.emit("Empty Monitor TOF Data!")
                    self.monitorTOFLog += 1
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.monitorTOF=_data
                except:
                    if self.monitorTOFLog < 2:
                        self.signalLog.emit("Incompleted Monitor TOF Data")
                        self.monitorTOFLog += 1
        except:
            pass

        while True:
            _started = self.get()
            if not _started:
                continue 
            # Monitor Counts in User Panel 
            try:
                _data = self.neonServer.get(self.monitorCountsPath)
            except:
                pass
            if _data is None :
                if self.monitorCountsLog == 0:
                    self.signalLog.emit("Empty Monitor Counts Data!")
                    self.monitorCountsLog += 1
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.signalMonitor.emit(_data)
                except:
                    if self.monitorCountsLog < 2:
                        self.signalLog.emit("Incompleted Monitor Counts Data")
                        self.monitorCountsLog += 1

            # get Proton Charge and Neutron Counts in User
            try:
                _proton = self.neonServer.get(self.protonPath)
                _neutron = self.neonServer.get(self.neutronValuePath)
            except:
                pass
            if _proton is None:
                if self.protonLog == 0:
                    self.signalLog.emit("Empty Proton Charge Data!")
                    self.protonLog += 1
            else:
                try:
                    _proton = jsonArray.jsonDecoder(_proton)
                except:
                    if self.protonLog < 2:
                        self.signalLog.emit("Incompleted Proton Charge  data")
                        self.protonLog += 1
            if _neutron is None:
                if self.neurontLog == 0:
                    self.signalLog.emit("Empty Neutron Counts Data!")
                    self.neurontLog += 1
            else:
                try:
                    _neutron = jsonArray.jsonDecoder(_neutron)
                except:
                    if self.neurontLog < 2:
                        self.signalLog.emit("Incompleted Neutron Counts data")
                        self.neurontLog += 2
            try:
                self.signalExperiment.emit(_proton[1][-1])#,  _neutron[-1][-1])
                #self.signalExperiment.emit(_proton[-1],  _neutron[-1])
            except:
                pass

            # get Tab index
            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass
            # Detector Page
            if self.tabIndex == 1:
                value = []
                buttonIndex, comboIndex = self.getDetectorIndex()
                if comboIndex==0 and buttonIndex!=-1:
                    try:
                        # pid combo Xaxis
                        if len(self.pidXaxis[buttonIndex])==0:
                            _json=self.neonServer.get(self.kwargs['path1'][buttonIndex])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.pidXaxis[buttonIndex]=_array
                        value.append(self.pidXaxis[buttonIndex])
                    except:
                        pass
                    #pid combo value
                    try:
                        _data = self.neonServer.get(self.kwargs['path2'][buttonIndex])
                    	#print _data, self.kwargs['path5'][buttonIndex]
                        if _data is None:
                            if self.pidLog == 0:
                                self.signalLog.emit("Empty PID Data!")
                                self.pidLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                                value.append(_data)
                            except:
                                if self.pidLog < 2:
                                    self.signalLog.emit("Incompleted Canvas data")
                                    self.pidLog += 1
                    except:
                        pass
                elif comboIndex==1 and buttonIndex!=-1:
                    try:
                        # xy combo Xaxis
                        if len(self.xyXaxis[buttonIndex])==0:
                            _json=self.neonServer.get(self.kwargs['path3'][buttonIndex])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.xyXaxis[buttonIndex]=_array
                        # xy combo Yaxis
                        if len(self.xyYaxis[buttonIndex])==0:
                            _json=self.neonServer.get(self.kwargs['path4'][buttonIndex])
                            _array=jsonArray.jsonDecoder(_json)
                            if len(_array)!=0:
                                self.xyYaxis[buttonIndex]=_array
                        value.append(self.xyXaxis[buttonIndex])
                        value.append(self.xyYaxis[buttonIndex])
                    except:
                        pass
                    #xy combo value
                    try:
                        _data = self.neonServer.get(self.kwargs['path5'][buttonIndex])
                        if _data is None:
                            if self.xyLog == 0:
                                self.signalLog.emit("Empty XY Data!")
                                self.xyLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                                value.append(_data)
                            except:
                                if self.xyLog < 2:
                                    self.signalLog.emit("Incompleted Canvas data")
                                    self.xyLog += 1
                    except:
                        pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Experiment Page
            elif self.tabIndex == 3:
                value = []
                for i in range(len(self.kwargs)-1):
                    value.append([])
                try:
                    for i in range(len(self.kwargs)-1):
                        _data = self.neonServer.get(self.kwargs['path'+str(i+1)])
                        if _data is None:
                            if self.expLog == 0:
                                self.signalLog.emit("Empty Canvas Data!")
                                self.expLog += 1
                        else:
                            try:
                                _data = jsonArray.jsonDecoder(_data)
                            except:
                                if self.expLog < 2:
                                    self.signalLog.emit("Incompleted Canvas data")
                                    self.expLog += 1
                        value[i] = _data
                except:
                    pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass
            # Histogram and Monitor Page
            else:
                value = []
                _pause = []
                try:
                    _pause = self.kwargs['status']
                except:
                    pass
                for _ini in range(len(self.kwargs)-2):
                    value.append([])
                for i in range(len(self.kwargs)-2):
                    _array = []
                    for key in range(len(self.kwargs['path1'])):
                        _array.append([])
                    try:
                        for j in range(len(self.kwargs['path1'])):
                            if _pause[j]=='Pause':
                                _data = self.neonServer.get(self.kwargs['path'+str(i+1)][j])
                                if _data is None:
                                    if self.hisLog == 0:
                                        self.signalLog.emit("Empty Canvas Data!")
                                        self.hisLog += 1
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        _array[j] = _data
                                    except:
                                        if self.hisLog < 2:
                                            self.signalLog.emit("Incompleted Canvas data")
                                            self.hisLog += 1
                            else:
                                pass
                        value[i]=_array
                    except:
                        pass
                try:
                    self.signalStatus.emit(value)
                except:
                    pass     
            try:
                time.sleep(self.refreshTime)
            except:
                pass
        self.finished.emit()

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getTabIndex(self):
        return self.tabIndex

    def getMonitorTOF(self):
        return self.monitorTOF

    def getDetectorIndex(self):
        return self.parent.getDetectorIndex()

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()

