#!/usr/bin/python
# -*- coding: utf-8 -*-

# from PyQt4 import QtCore, QtGui
# from PyQt4 import Qt

import json
import time
from matplotlib.backends.backend_qt4agg import FigureCanvasQTAgg
from matplotlib.figure import Figure
from redis.sentinel import Sentinel

from conf.constants import *
from model import neonReceiver
from viewer import canvas

class CSNSUserInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSUserInfo, self).__init__(parent)
        self.setupUi(self)

        self.parent = parent
        self.controlThread = None

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreafirst = QtGui.QScrollArea()
        self.scrollAreafirst.setWidgetResizable(True)
        self.scrollAreafirst.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreasecond = QtGui.QScrollArea()
        self.scrollAreasecond.setWidgetResizable(True)
        self.scrollAreasecond.setWidget(self.second)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreathird = QtGui.QScrollArea()
        self.scrollAreathird.setWidgetResizable(True)
        self.scrollAreathird.setWidget(self.third)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollAreafirst)
        self.splitter.addWidget(self.scrollAreasecond)
        self.splitter.addWidget(self.scrollAreathird)
        self.splitter.setSizes([150, 270, 230])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.thirdGrid = QtGui.QGridLayout(self.third)

    	# main verticalLayout
        self.GPPDLabel = QtGui.QLabel('<font color=red>GPPD</font>')
        self.GPPDLabel.setFont(QtGui.QFont('Roman times', 20,
                               QtGui.QFont.Bold))
        self.spectLabel = QtGui.QLabel('<font color=black>Instrument Scientist: Lunhua He(123)</font>')
        self.developLabel = QtGui.QLabel('<font size=2 color=black>Software Engineer: Lili Yan(347)</font>')

        self.verticalLayout.addWidget(self.GPPDLabel)
        self.verticalLayout.addWidget(self.spectLabel)
        self.verticalLayout.addWidget(self.developLabel)
        self.verticalLayout.addWidget(self.splitter)

    	# first Grid
        self.userIDLabel = QtGui.QLabel('UserID: ', self.first)
        self.userIDText = QtGui.QLabel('--------', self.first)

        self.runNoLabel = QtGui.QLabel('RunNo: ', self.first)
        self.runNoText = QtGui.QLabel('--------', self.first)

        self.proposalLabel = QtGui.QLabel('ProposalID: ', self.first)
        self.proposalText = QtGui.QLabel('--------', self.first)

    	# second Grid
        self.neonLabel = QtGui.QLabel('NEON', self.second)
        self.neonConnectLabel = QtGui.QLabel('Connect',
                self.second)
        self.neonConnectLabel.setFixedSize(QtCore.QSize(80, 30))

        self.commandLabel = QtGui.QLabel('Command: ', self.second)

        self.commandTimeLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel = QtGui.QLabel('', self.second)
        self.commandValueLabel.setStyleSheet("color:green")
        
        self.statusLabel = QtGui.QLabel('Status: ', self.second)
        self.statusTimeLabel = QtGui.QLabel('', self.second)
        self.statusValueLabel = QtGui.QLabel('None', self.second)
        self.statusValueLabel.setStyleSheet("color:blue")

        # third Grid
        with plt.xkcd():
            self.runCanvas=canvas.xkcdFigure(self)

        self.startTimeLabel = QtGui.QLabel('<font color=red>Start Time:</font>')
        self.startTimeText = QtGui.QLabel('<font color=red>------</font>')
        self.endTimeLabel = QtGui.QLabel('<font color=red>End Time:</font>')
        self.endTimeText = QtGui.QLabel('<font color=red>------</font>')

        self.protonLabel = QtGui.QLabel('Proton Charge: ')
        self.protonText = QtGui.QLabel('-----')

        self.neutronLabel = QtGui.QLabel('Neutron Counts: ')
        self.neutronText = QtGui.QLabel('-----')

        _nline = 0
        self.firstGrid.addWidget(self.userIDLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.userIDText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.runNoLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.runNoText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline += 1
        self.firstGrid.addWidget(self.proposalLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.proposalText, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)

        _nline = 0
        self.secondGrid.addWidget(self.neonLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.neonConnectLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        
        _nline += 1
        self.secondGrid.addWidget(self.commandLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.commandValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.commandTimeLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        
        _nline += 1
        self.secondGrid.addWidget(self.statusLabel, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        self.secondGrid.addWidget(self.statusValueLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)
        _nline += 1
        self.secondGrid.addWidget(self.statusTimeLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)#|QtCore.Qt.AlignTop)

        _nline = 0
        self.thirdGrid.addWidget(self.startTimeLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.thirdGrid.addWidget(self.startTimeText,_nline,1,1,1,QtCore.Qt.AlignLeft,)
        _nline += 1
        self.thirdGrid.addWidget(self.endTimeLabel,_nline,0,1,1,QtCore.Qt.AlignLeft,)
        self.thirdGrid.addWidget(self.endTimeText,_nline,1,1,1,QtCore.Qt.AlignLeft,)
        _nline += 1
        self.thirdGrid.addWidget(
            self.protonLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.protonText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.neutronLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.thirdGrid.addWidget(
            self.neutronText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        _nline += 1
        self.thirdGrid.addWidget(
            self.runCanvas,
            _nline,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        #self.thirdGrid.addItem(QtGui.QSpacerItem(-1, -1,
        #                       QtGui.QSizePolicy.Ignored,
        #                       QtGui.QSizePolicy.Expanding), 2, 0)


        self.dataThread = False
        self.pix = None

    def setNeonStatus(self, value):
        if value:
            self.neonConnectLabel.setText('Connected')
        else:
            self.neonConnectLabel.setText('Disconnected')

    def getIP_PORT(self):
        _ip_port = [('10.1.53.240', 9001), ('10.1.53.240',9011)]
        return _ip_port

    def getNeon(self):
        status=False
        writeServer=None
        readServer=None

        _timeout=10
        _ip_port=self.getIP_PORT()
        _passwd='sanlie;123'
        _r=neonReceiver.connectNeon(_ip_port, _passwd, _timeout)
        status=_r.getStatus()
        writeServer=_r.getRedisWrite()
        readServer=_r.getRedisRead()
        
        return status, writeServer, readServer

    def setUserInfo(self, value):
        _value = json.loads(str(value))
        self.userIDText.setText(str(_value['userID']))
        self.runNoText.setText(str(_value['runNo']))
        self.proposalText.setText(str(_value['proposalID']))

    # get from neon
    def setCommandLabel(self, value):
        _timen=str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        self.setCommandTimeLabel(_timen)
        self.setCommandValueLabel(value)

    def setCommandTimeLabel(self, time):
        self.commandTimeLabel.setText(time)

    def setCommandValueLabel(self, value):
        self.commandValueLabel.setText(value)
    
    # get from neon
    def setStatusLabel(self, value):
        myStatus = self.statusValueLabel.text()
        _timen=str(time.strftime('%Y-%m-%d  %H:%M:%S'))
        if myStatus != value: 
            self.setStatusTimeLabel(_timen)
            self.setStatusValueLabel(value)
            logging.info(str("status is " + value + ' now')) 

    def setStatusTimeLabel(self, time):
        self.statusTimeLabel.setText(time)

    def setStatusValueLabel(self, value):
        self.statusValueLabel.setText(value)
    
    def setProtonNeutron(self, _proton, _neutron):
        try:
            self.protonText.setText(str(_proton))
            self.neutronText.setText(str(_neutron))
        except:
            self.protonText.setText("-----")
            self.neutronText.setText("-----")
    
    def setStartEndTime(self, _start, _end):
        try:
            self.startTimeText.setText(str(_start))
            self.endTimeText.setText(str(_end))
        except:
            self.startTimeText.setText("------")
            self.endTimeText.setText("------")

    def updateMonitorCanvas(self, xdata, ydata, started,_command):
        try:
            if _command in ('configure', 'abort'):
                self.pix = None
            else:
                if not started:
                    pass
                else:
                    for j in range(len(xdata)):
                        xdata[j] = xdata[j]*10
                    x = xdata[0:250]
                    y = ydata[0:250]
                    if not self.pix:
                        self.runCanvas.ax.clear()
                        self.pix, = self.runCanvas.ax.plot(x, y, color="g")
                    else:
                        self.pix.set_ydata(y)
                    self.runCanvas.ax.relim()
                    self.runCanvas.ax.autoscale_view()
                    self.runCanvas.draw()
                    #self.runCanvas.flush_events()
        except:
            pass
