#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from pattern import *
from detector import *
from monitor import *
from experiment import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.patternPage = CSNSPatternPage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.patternPage, 'Diffraction Pattern')
        self.addTab(self.detectorPage, 'Detector Counts')
        self.addTab(self.monitorPage, 'Monitor Counts')
        self.addTab(self.experimentPage, 'Experiment Progress')
    
        self.currentChanged.connect(self.tabChange)

    def updateDiffractionSimulator(self):
        self.patternPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.patternPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getPatternPath(self):
        groupStatus = []
        path1 = []
        path2 = []
        _unitIndex = []
        _index = self.patternPage.patternDock[0].normSelected()
        for i in range(len(self.patternPage.patternDock)):
            _unitIndex.append(self.patternPage.patternDock[2-i].getIndex())
            groupStatus.append(self.patternPage.patternDock[i].pauseButton.text())
            if _index == 0:
                if _unitIndex[i] == 0:
                    path1.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/reduction/monitor/tof')
                    path2.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/reduction/monitor/counts')
                elif _unitIndex[i] == 1:
                    path1.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/reduction/monitor/d')
                    path2.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/reduction/moniotr/intensity')
                else:
                    pass
            elif _index == 1:
                if _unitIndex[i] == 0:
                    path1.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/reduction/PC/tof')
                    path2.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/reduction/PC/counts')
                elif _unitIndex[i] == 1:
                    path1.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/reduction/PC/d')
                    path2.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/reduction/PC/intensity')
                else:
                    pass
            elif _index == 2:
                if _unitIndex[i] == 0:
                    path1.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/raw/tof')
                    path2.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/raw/counts')
                elif _unitIndex[i] == 1:
                    path1.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/raw/d')
                    path2.append('/GPPD/workspace/MantidData/group'+str(i+1).zfill(2)+'/raw/intensity')
                else:
                    pass
            else:
                pass                
        return groupStatus, path1, path2

    def getDetectorPath(self):
        buttonIndex = self.detectorPage.getButtonIndex() 
        
        path1 = []
        path2 = []
        path3 = []        
        path4 = []        
        path5 = []
        
        moduleList=[131,132,133,231,232,233,322,331,332,333,341,342,343,422,431,432,433,441,442,443,521,522,523,531,532,533,541,542,543,621,622,623,631,632,633,641,642,643]
        _index = self.detectorPage.getComboIndex() 
        #for i in range (buttonIndex+1):
        path1 = '/GPPD/workspace/MantidData/module'+str(moduleList[buttonIndex])+'/xy_image/x'
        path2 = '/GPPD/workspace/MantidData/module'+str(moduleList[buttonIndex])+'/xy_image/y'
        path3 = '/GPPD/workspace/MantidData/module'+str(moduleList[buttonIndex])+'/xy_image/value'
        if _index == 1:
            path4 = '/GPPD/workspace/MantidData/module'+str(moduleList[buttonIndex])+'/tof'
            path5 = '/GPPD/workspace/MantidData/module'+str(moduleList[buttonIndex])+'/counts'
        elif _index == 2:
            path4 = '/GPPD/workspace/MantidData/module'+str(moduleList[buttonIndex])+'/d'
            path5 = '/GPPD/workspace/MantidData/module'+str(moduleList[buttonIndex])+'/intensity'            
        return path1, path2, path3, path4, path5
        

    def getMonitorPath(self):
        monitorStatus = []
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        _index = self.monitorPage.getComboIndex()
        for i in range(len(self.monitorPage.monitorDock)):
            monitorStatus.append(self.monitorPage.monitorDock[i].pauseButton.text())
            path1.append('/GPPD/workspace/MantidData/monitor'+str(i+1)+'/xy_image/x')
            path2.append('/GPPD/workspace/MantidData/monitor'+str(i+1)+'/xy_image/y')
            path3.append('/GPPD/workspace/MantidData/monitor'+str(i+1)+'/xy_image/value')
            if _index[i] == 0:
                path4.append('/GPPD/workspace/MantidData/monitor'+str(i+1)+'/tof')
                path5.append('/GPPD/workspace/MantidData/monitor'+str(i+1)+'/counts')
            else:
                path4.append('/GPPD/workspace/MantidData/monitor'+str(i+1)+'/wave')
                path5.append('/GPPD/workspace/MantidData/monitor'+str(i+1)+'/intensity')
        return monitorStatus, path1, path2, path3, path4, path5

    def getExperimentPath(self):
        path1 = []
        path2 = []
        path3 = []
        path1 = '/GPPD/drone/proton_charge'
        path2 = '/GPPD/drone/neutron_counts'
        path3 = '/GPPD/drone/pulse_charge'
        return path1, path2, path3
    
    def setStatus(self):
        self.tabChange()

    def tabChange(self):
        path1 = []
        path2 = []
        path3 = []
        path4 = []
        path5 = []
        status = []
        tabIndex = self.currentIndex()

        if tabIndex == 0:
            status, path1, path2 = self.getPatternPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2,
                        "status": status}
        elif tabIndex == 1:
            path1, path2, path3, path4, path5 = self.getDetectorPath()
            kwargs = {'tabIndex': tabIndex, 'path1': path1, 'path2': path2, 'path3': path3, 'path4': path4, 'path5': path5}
        elif tabIndex == 2:
            status, path1, path2, path3, path4, path5 = self.getMonitorPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3, 
                        "path4": path4,"path5": path5, "status": status}

        elif tabIndex == 3:
            path1, path2, path3 = self.getExperimentPath()
            kwargs = {"tabIndex": tabIndex, "path1": path1, "path2": path2, "path3": path3}
       
        self.parent.setDataPath(kwargs)
