'''
Created on 2015.6.4
@author: yll

DotQ

'''
from conf import *
from canvas import *
from model.readData import *
from model.readImage import *

class CSNSCalibrationPage(QtGui.QTabWidget):

    def __init__(self):
        super(CSNSCalibrationPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self,QTabWidget):
    	self.setTabPosition(QTabWidget.West)

        #main  grid
        self.mainGridWidget = QtGui.QWidget(self)
        self.mainGrid = QtGui.QGridLayout(self.mainGridWidget)
 
        # Left Label
        self.LeftLabel = QtGui.QLabel("Left")
        # Right Label
        self.RightLabel = QtGui.QLabel("Right")
         
        # Bckward 2D/3D
        self.BackwardComboBox = QtGui.QComboBox()
        self.BackwardComboBox.addItem("2D")
        self.BackwardComboBox.addItem("3D")
        self.filexy=["img/XY ++.png", "img/XY +-.png"]
        self.filext=["img/XT ++.png", "img/XT +-.png"]
        _index=self.BackwardComboBox.currentIndex()

        _xsize=3
        _ysize=1

        # Backward
        self.BackwardLabel = QtGui.QLabel("Backward")

        self.BackwardImageCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.dataxyX, self.dataxyY, self.dataxyZ = CSNSReadImage2Matrix(self.filexy[_index], 1, 1)
        self.BackwardImage = self.BackwardImageCanvas.ax.pcolormesh(self.dataxyY, self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle((0,0), 0, 0, facecolor='None', edgecolor='black', alpha=0.8,zorder=2)
        self.BackwardImageCanvas.ax.add_patch(self.rect)
        self.BackwardImageCanvas.draw()

        #Background
        self.BackgroundLabel = QtGui.QLabel("Backward")

        self.BackgroundCanvas = CSNSCanvas(self, _xsize, _ysize)

        self.dataxyX, self.dataxyY, self.dataxyZ = CSNSReadImage2Matrix(self.filexy[_index], 1, 1)  
        self.BackgroundImage = self.BackwardImageCanvas.ax.pcolormesh(self.dataxyY, self.dataxyX, self.dataxyZ, cmap=cm.coolwarm)
        self.rect = Rectangle((0,0), 0, 0, facecolor='None', edgecolor='black', alpha=0.8,zorder=2) 
        self.BackgroundCanvas.ax.add_patch(self.rect)
        self.BackgroundCanvas.draw()

        self.mainGrid.addWidget(self.LeftLabel,  0,0,1,1)
        self.mainGrid.addWidget(self.RightLabel, 0,1,1,1)
        self.mainGrid.addWidget(self.BackwardLabel, 1,0,1,1)
        self.mainGrid.addWidget(self.BackgroundLabel,    1,1,1,1)
        self.mainGrid.addWidget(self.BackwardImageCanvas,    2,0,1,1)
        self.mainGrid.addWidget(self.BackgroundCanvas,    2,1,1,1)
        self.mainGrid.addWidget(self.BackwardComboBox,    2,2,1,1)
