'''
Created on 2015.9.25
@author: yll
'''

# configure
from conf import *

# user defined
from viewer.runList import *
from viewer.runData import *
from viewer.mainTab import *
from viewer.subTab import *

class myMenuBar(QtGui.QMenuBar):
    def __init__(self, parent=None):
        super(myMenuBar,self).__init__(parent)
        self.CreateMenuBar()
        self.open_action.triggered.connect(self.file_open)

    def CreateMenuBar(self):

        self.file_menu = self.addMenu("File(&F)")
        self.edit_menu = self.addMenu("Edit(&E)")
        self.help_menu = self.addMenu("Help(&H)")

        self.open_action = self.file_menu.addAction("Open")
        self.save_action = self.file_menu.addAction("Save")
        self.exit_action = self.file_menu.addAction("Exit")
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap("icon/open.jpg"),QtGui.QIcon.Normal,QtGui.QIcon.Off)
        self.open_action.setIcon(icon)
        self.open_action.setShortcut(QtCore.QCoreApplication.translate("MainWindow","Ctrl+O"))
        icon2 = QtGui.QIcon()
        icon2.addPixmap(QtGui.QPixmap("icon/save.jpg"),QtGui.QIcon.Normal,QtGui.QIcon.Off)
        self.save_action.setIcon(icon2)
        self.save_action.setShortcut(QtCore.QCoreApplication.translate("MainWindow","Ctrl+S"))
        icon3 = QtGui.QIcon()
        icon3.addPixmap(QtGui.QPixmap("icon/exit.jpg"),QtGui.QIcon.Normal,QtGui.QIcon.Off)
        self.exit_action.setIcon(icon3)
        self.exit_action.setShortcut(QtCore.QCoreApplication.translate("MainWindow","Ctrl+P"))

        self.cut_action = self.edit_menu.addAction("Cut")
        self.copy_action = self.edit_menu.addAction("Copy")
        self.past_action = self.edit_menu.addAction("Paste")

    def file_open(self):
        fileName = QtGui.QFileDialog.getOpenFileName(self,("title"),("./"),(""))#,None)
        print('fileName:',fileName)
        #print(selectedFilter)

class myStatusBar(QtGui.QStatusBar):
    def __init__(self, parent=None):
        super(myStatusBar,self).__init__(parent)
        self.CreateStatusBar()

    def CreateStatusBar(self):
        pass

class mywindow(QtGui.QMainWindow):

    def __init__(self):
        super(mywindow, self).__init__()
        self.setupUi(self)

    def setupUi(self,MainWindow):

        self.myMenuBar = myMenuBar(self)
        self.setMenuBar(self.myMenuBar)

        self.myStatusBar = myStatusBar(self)
        self.setStatusBar(self.myStatusBar)

        self.mainSplitter = QtGui.QSplitter(QtCore.Qt.Horizontal,self)

        self.leftSplitter = QtGui.QSplitter(QtCore.Qt.Vertical,self)
        self.rightSplitter = QtGui.QSplitter(QtCore.Qt.Vertical,self)

        self.upLeftListWidget = CSNSRunList(self.leftSplitter)
        self.downLeftFigure = CSNSRunData(self.leftSplitter)

        self.upRightTab = CSNSMainTab(self.rightSplitter)
        self.downRightTab = CSNSSubTab(self.rightSplitter)

        self.leftSplitter.setSizes([600,200])
        self.rightSplitter.setSizes([700,100])

        self.leftSplitter.addWidget(self.upLeftListWidget)
        self.leftSplitter.addWidget(self.downLeftFigure)
        self.rightSplitter.addWidget(self.upRightTab)
        self.rightSplitter.addWidget(self.downRightTab)
        self.mainSplitter.addWidget(self.leftSplitter)
        self.mainSplitter.addWidget(self.rightSplitter)

        self.setCentralWidget(self.mainSplitter)

    def btnExit(self):
        if self.pushButton.text()=="Let it go":
               print(self.pushButton.text())
               self.pushButton.setText("I'm still here!")
        else:
               print(self.pushButton.text())
               self.pushButton.setText("Let it go")

def main():
    myapp = QtGui.QApplication(sys.argv)
    mytop = mywindow()
    mytop.setWindowTitle("GPPD")
    mytop.resize(1200,800)
    mytop.show()
    sys.exit(myapp.exec_())

if __name__ == '__main__':
    #if __package__ is None:
    	#sys.path.append( path.dirname( path.dirname( path.abspath(__file__) ) ) )
    main()
