#!/usr/bin/python
# -*- coding: utf-8 -*-
# configure

'''
Created on 2015.6.2
@author: yll

reduction
'''

from conf import *

import pygraphviz as pgv
import networkx as nx

# user defined

from model.readData import *
from model.readFile import *
from model.readImage import *


class CSNSReductionPage(QtGui.QWidget):

    def __init__(self):
        super(CSNSReductionPage, self).__init__(parent=None)
        self.setupUi(self)

    def setupUi(self, QWidget):

        # for main  grid

        self.mainGrid = QtGui.QGridLayout(self)

        self.flowText = QtGui.QTextEdit(self)
        self.flowText.setText(CSNSReadText('dat/flowchart.dot'))

        self.flowEdit = QtGui.QTextEdit(self)

        fig = plt.figure()
        self.flowCanvas = FigureCanvas(fig)
        self.flowAxes = fig.add_subplot(111)

        self.flowFigure = nx.read_dot('dat/flowchart.dot')
        nx.draw_networkx(self.flowFigure, ax=self.flowAxes,
                         node_color='b')

        self.flowCanvas.draw()

        self.mainGrid.addWidget(self.flowText, 0, 0, 1, 1)
        self.mainGrid.addWidget(self.flowCanvas, 0, 2, 1, 1)
        self.mainGrid.addWidget(self.flowEdit, 0, 3, 1, 1)


