#!/usr/bin/python
# -*- coding: utf-8 -*-
# Set the QT API to PyQt4

import os
os.environ['QT_API'] = 'pyqt'
import sip

# sip.setapi("QString", 2)
# sip.setapi("QVariant", 2)
# from PyQt4.QtGui  import *

from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QWidget

# Import the console machinery from ipython

from qtconsole.rich_jupyter_widget import RichJupyterWidget
from qtconsole.inprocess import QtInProcessKernelManager
from IPython.lib import guisupport


class QIPythonWidget(RichJupyterWidget):

    """ Convenience class for a live IPython console widget. We can replace the standard banner using the customBanner argument"""

    def __init__(
        self,
        customBanner=None,
        *args,
        **kwargs
        ):
        if customBanner != None:
            self.banner = customBanner
        super(QIPythonWidget, self).__init__(*args, **kwargs)

        kernel_manager = QtInProcessKernelManager()
        self.kernel_manager = kernel_manager
        kernel_manager.start_kernel()
        kernel = kernel_manager.kernel
        kernel.gui = 'qt4'
        kernel.shell.push(kwargs)

        kernel_client = kernel_manager.client()
        kernel_client.start_channels()

        control = RichJupyterWidget()
        self.control = control
        control.kernel_manager = kernel_manager
        control.kernel_client = kernel_client

        def stop():
            kernel_client.stop_channels()
            kernel_manager.shutdown_kernel()
            guisupport.get_app_qt4().exit()

        self.exit_requested.connect(stop)

    def pushVariables(self, variableDict):
        """ Given a dictionary containing name / value pairs, push those variables to the IPython console widget """

        self.kernel_manager.kernel.shell.push(variableDict)

    def clearTerminal(self):
        """ Clears the terminal """

        self._control.clear()

    def printText(self, text):
        """ Prints some plain text to the console """

        self._append_plain_text(text)

    def executeCommand(self, command):
        """ Execute a command in the frame of the console widget """

        self._execute(command, False)


class ConsoleWidget(QWidget):

    """ Main GUI Widget including a button and IPython Console widget inside vertical layout """

    def __init__(self, parent=None):
        super(ConsoleWidget, self).__init__(parent)
        layout = QtGui.QVBoxLayout(self)
        guiconsole = \
            QIPythonWidget(customBanner='Welcome to CSNS GPPD console (Lili YAN)!\n'
                           )
        guiconsole.set_default_style(colors='linux')
        layout.addWidget(guiconsole)


        # This allows the variable foo and method print_process_id to be accessed from the ipython console
