#!/usr/bin/python
# -*- coding: utf-8 -*-
from conf import *

from peakFinder import *


def getXYdata(
    x0,
    y0,
    dataX,
    dataY,
    dataZ,
    ):
    ylist = (dataY[0])[:]
    ny = len(ylist)

    xlist = []
    for i in range(ny):
        xlist.append(dataX[i][0])

    nx = len(xlist)

    xid = min(xlist, key=lambda x: abs(x - x0))
    yid = min(ylist, key=lambda x: abs(x - y0))
    xid = xlist.index(xid)
    yid = ylist.index(yid)

    dataYZ = []
    dataYZ.append([])
    dataYZ.append([])
    for i in range(ny):
        dataYZ[0].append(dataY[xid][i])
        dataYZ[1].append(dataZ[xid][i])

    dataXZ = []
    dataXZ.append([])
    dataXZ.append([])
    for i in range(nx):
        dataXZ[0].append(dataX[i][yid])
        dataXZ[1].append(dataZ[i][yid])

    return (dataYZ, dataXZ)


class SlitCalculation:

    def __init__(self, incidentAngle=0.1, reflectedAngle=0.1):
        self.incidentAngle = incidentAngle
        self.reflectedAngle = reflectedAngle

    def getSlitHeight(self):
        self.slitList = [CSNSMRslit1Position, CSNSMRslit2Position,
                         CSNSMRsamplePosition, CSNSMRslit3Position]

        _a = (CSNSMRslit1Height + CSNSMRsampleHeight) / 2.0 \
            / -CSNSMRslit1Position
        _b = CSNSMRsampleHeight / 2.0
        _s3 = (_a * CSNSMRslit3Position + _b) * 2

        self.heightList = [CSNSMRslit1Height, CSNSMRslit2Height,
                           CSNSMRsampleHeight, _s3]

        return (self.slitList, self.heightList)


