#!/usr/bin/python
# -*- coding: utf-8 -*-
import numpy as np
import scipy
import Image
from PIL import ImageOps


def CSNSReadImage2Table(fname):
    img = Image.open(fname).convert('L')
    box = (630, 400, 2630, 2000)

    # box = (int(left), int(top),int(right),int(bottom))

    region = img.crop(box)
    nx = 100
    ny = 100
    size = (nx, ny)
    img_resized = region.resize(size, Image.ANTIALIAS)

    arr = np.asarray(img_resized)

    X = []
    Y = []
    Z = []

    ngroup = -1
    for i in range(nx):
        ngroup += 1
        X.append([])
        Y.append([])
        Z.append([])
        for j in range(ny):
            X[ngroup].append(i)
            Y[ngroup].append(j)
            Z[ngroup].append(arr[i][j])

    return (X, Y, Z)


def CSNSReadImage2Matrix(fname, xpixel, ypixel):
    img = Image.open(fname).convert('L')

    img = ImageOps.invert(img)

    box = (630, 400, 2630, 2000)

    # box = (int(left), int(top),int(right),int(bottom))

    region = img.crop(box)
    nx = 100
    ny = 100
    size = (ny - 1, nx - 1)
    img_resized = region.resize(size, Image.ANTIALIAS)

    Z = np.asarray(img_resized)

    X = np.zeros((nx, ny))
    Y = np.zeros((nx, ny))

    for i in range(nx):
        for j in range(ny):
            X[i][j] = (i + 1) * xpixel
            Y[i][j] = (j + 1) * ypixel

    return (X, Y, Z)


def CSNSReadImageSurface(fname):
    img = Image.open(fname).convert('L')

    img = ImageOps.invert(img)

    box = (630, 400, 2630, 2000)

    # box = (int(left), int(top),int(right),int(bottom))

    region = img.crop(box)
    n = 50
    size = (n, n)
    img_resized = region.resize(size, Image.ANTIALIAS)

    img = np.asarray(img_resized)

    R = np.zeros(n)
    a = np.zeros(n)
    b = np.zeros(n)
    c = np.zeros(n)

    for i in range(n):
        a[i] = i * 0.01 + 0.01
        b[i] = i * 0.01 + 0.01
        b[i] = i * 0.01 + 0.01

    (X, Y) = np.meshgrid(a, b)
    (Z, tmp) = np.meshgrid(c, R)

    for i in range(n):
        for j in range(n):
            Z[i][j] = scipy.sqrt(abs(0.4 ** 2 - X[i][j] ** 2 - Y[i][j]
                                 ** 2))

    C = img / float(img.max())

    return (X, Y, Z, C)


