#!/usr/bin/python
# -*- coding: utf-8 -*-
import numpy as np


def CSNSRead2DData(fname):
    data = []

    fopen = open(fname, 'r')
    lines = fopen.readlines()

    check = lines[-1].split()
    n = len(check)
    for i in range(n):
        data.append([])

    for line in lines:
        tmp = line.split()
        for i in range(n):
            data[i].append(float(tmp[i]))

    return (n, data)


def CSNSRead4DData(fname):
    '''
    input:
    0 1 z
    0 2 z
    0 3 z
    1 1 z
    1 2 z
    1 3 z

    output:

    '''

    n = 50

    R = np.zeros(n)
    X = np.zeros(n)
    Y = np.zeros(n)
    Z = np.zeros(n)
    C = np.zeros(n)

    for i in range(n):
        X[i] = i * 0.01 + 0.01
        Y[i] = i * 0.01 + 0.01
        Z[i] = i * 0.01 + 0.01
    (X, Y) = np.meshgrid(X, Y)
    (Z, tmp) = np.meshgrid(Z, R)
    (C, tmp) = np.meshgrid(C, R)

    for i in range(C.shape[0]):
        for j in range(C.shape[1]):
            C[i][j] = Y[i][n / 2]

    C /= float(C.max())

    return (X, Y, Z, C)


def CSNSRead3DData(fname):
    '''
    input:
    0 1 z
    0 2 z
    0 3 z
    1 1 z
    1 2 z
    1 3 z

    output:

    '''

    X = []
    Y = []
    Z = []

    fopen = open(fname, 'r')
    lines = fopen.readlines()

    ngroup = -1
    nfirst = -1
    for line in lines:
        tmp = line.split()
        first = tmp[1]
        break

    ngroup = -1
    for line in lines:
        tmp = line.split()
        if tmp[1] == first:
            ngroup += 1
            X.append([])
            Y.append([])
            Z.append([])

        X[ngroup].append(float(tmp[0]))
        Y[ngroup].append(float(tmp[1]))
        Z[ngroup].append(float(tmp[2]))

    return (X, Y, Z)


