#!/usr/bin/python
# -*- coding: utf-8 -*-
import math
import random
from math import atan
from numpy import *
from scipy import pi, log
import numpy as np
import time
import thread
import threading
from scipy.interpolate import interp1d
from scipy.interpolate import InterpolatedUnivariateSpline
from scipy.interpolate import UnivariateSpline
from readData import *
from globalClass import *
from profileFunction import *

class protonSimulator(threading.Thread):

    def __init__(
        self,
        threadID,
        CSNSGlobal,
        ):
        threading.Thread.__init__(self)

        self.threadID = threadID
        self.protonCharge = CSNSGlobal


        self.gauss=[]
        _parameters=[1.0, 0.0, 5, 0.0]
        for i in range(5):
            self.gauss.append(CSNSgauss(_parameters, -5.0+i*2))

        self.nPulse=5
        self.step=2.0
        self.nPoints=int(5*40/self.step)
        self.period=int(40/self.step)

        self.protonCharge.X=[]
        self.protonCharge.Y=[]

        self.protonCharge.X.append(0.0)
        self.protonCharge.Y.append(0.0)
        
        for i in range(self.nPoints):
            self.protonCharge.X.append(i*2)
            self.protonCharge.Y.append(0.0)

    def randomSampling(ylist, y0):
        p = random.random()
        idx = np.argmin(np.abs(ylist - y0))
        return idx
    
    def run(self):
        _renew=-1
        while(True):
            _renew+=1
            if _renew < 5:
                self.protonCharge.Y.pop(0)
                self.protonCharge.Y.append(self.gauss[_renew]*random.random(0.8,1.0))
                _renew+=1
            elif _renew<self.period:
                self.protonCharge.Y.pop(0)
                self.protonCharge.Y.append(self.gauss[_renew]*random.random(0.01, 0.1))
                _renew+=1
            else:           
                _renew=-1
            
