from model import jsonArray
import threading
from Queue import Queue
import time
import matplotlib
import numpy as np
import cStringIO
from PIL import Image

class dataSet(threading.Thread):

    def __init__(self,threadID,neonRedis,refreshtime,neonpathXaxis,neonpathYaxis,neonpathZarray,neonpathCvalue,arrayZ,valueC):

        threading.Thread.__init__(self)
        self.paused = False
        self.pause_cond = threading.Condition(threading.Lock())
        self.thread_stop = False

        self.neonRedis=neonRedis
        self.neonpathX=neonpathX
        self.neonpathY=neonpathY
        self.neonpathZ=neonpathZ
        self.neonpathC=neonpathC
        
        self.arrayZ=arrayZ
        self.valueC=valueC
        
        self.refreshtime=refreshtime
        
    def setXaxis(self, xbins):
        _json_data=jsonArray.jsonEncoder(xbins)
        self.neonRedis.set(self.neonpathXaxis, _json_data)
        
    def setYaxis(self, ybins):
        _json_data=jsonArray.jsonEncoder(ybins)
        self.neonRedis.set(self.neonpathYaxis, _json_data)

    def process(self):
        be=time.time()
        
        if (self.neonpathCvalue != None):
            _dataC=self.valueC.get()
            self.neonRedis.set(self.neonpathCvalue, _dataC)
            
        _jsonZ=self.arrayZ.get()
        _jsonZ=jsonArray.jsonEncoder()
        self.neonRedis.set(self.neonpathZarray, _jsonZ)

        print (time.time()-be)

    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)

    def destroy(self):
        self.neonRedis.delete(self.neonX)
        self.neonRedis.delete(self.neonY)
        self.neonRedis.delete(self.neonZ)
        self.neonRedis.delete(self.neonC)

    def pause(self):
        self.paused = True
        self.pause_cond.acquire()

    def resume(self):
        self.paused = False
        self.pause_cond.notify()
        self.pause_cond.release()

    def stop(self):
        self.thread_stop = True
        
        
class dataGet(threading.Thread):

    def __init__(
        self,
        threadID,
        neonRedis,
        refreshtime,
	neonpathXaxis,
	neonpathYaxis,
	neonpathZarray,
        neonpathCvalue,
	button,
	canvas,
        ):
        threading.Thread.__init__(self)
        self.paused = False
        self.pause_cond = threading.Condition(threading.Lock())
        self.thread_stop = False

        self.neonRedis=neonRedis
        self.neonpathXaxis=neonpathXaxis
        self.neonpathYaxis=neonpathYaxis
        self.neonpathZarray=neonpathZarray
        self.neonpathCvalue=neonpathCvalue

	self.button=button
        self.canvas = canvas
	self.ax = canvas.ax

	self.getAxis()	
        
	#self.arrayZ=arrayZ
        #self.valueC=valueC
        
        self.refreshtime=refreshtime

    def getAxis(self):
        _json_data=self.neonRedis.get(self.neonpathXaxis)
        print _json_data
	_x=jsonArray.jsonDecoder(_json_data)

	_json_data=self.neonRedis.get(self.neonpathYaxis)
        _y=jsonArray.jsonDecoder(_json_data)

	_nx=len(_x)
	_ny=len(_y)
	
	self.xbin=np.zeros((_nx,_ny))
	self.ybin=np.zeros((_nx,_ny))

	for i in range(_nx):
	    for j in range(_ny):
		self.xbin[i][j]=_x[i]
		self.ybin[i][j]=_y[j]

    	
    def initXYaxis(self):
	pass
	#self.ax.set_xdata(self.getXaxis())	
	#self.ax.set_ydata(self.getYaxis())	
	#self.axis = self.ax.plot(self.getXaxis(), self.getYaxis(), "cool")	
		
    def process(self):
        be=time.time()
        
        if (self.neonpathCvalue != None):
            _dataC=self.neonRedis.get(self.neonpathCvalue)
	    print _dataC
	    
            self.button.setText(str(_dataC))
        
	if (self.neonpathZarray != None):
	    _jsonZ=self.neonRedis.get(self.neonpathZarray)
            #_dataZ=jsonArray.jsonDecoder(_jsonZ)
	    _imdata = cStringIO.StringIO(_jsonZ)
	    _im=Image.open(_imdata)#.getvalue())
	    self.canvas.ax.imshow(_im)  

        print (time.time()-be)
	#self.ax.pcolormesh(self.xbin, self.ybin, _dataZ)
	#self.canvas.draw()	
	    
	    #_jsonZ=self.neonRedis.get(self.neonpathZarray)
            #self.arrayZ.put(jsonArray.jsonDecoder(_jsonZ))
            #self.arrayZ.task_done()

    def run(self):
        while True:
            self.process()
            time.sleep(self.refreshtime)

    def pause(self):
        #self.paused = True
        #self.pause_cond.acquire()
        self.can_run.set()
        with self.arrayZ.mutex:
            self.arrayZ.queue.clear()
            self.valueC.queue.clear()

    def resume(self):
        #self.paused = False
        #self.pause_cond.notify()
        #self.pause_cond.release()
        self.can_run.clear()

    def stop(self):
        self.paused = True
        self.pause_cond.acquire()
        self.can_run.set()
