#!/usr/bin/python
# -*- coding:utf-8 -*-

#from PyQt4 import QtCore, QtGui
#from PyQt4 import Qt
from conf.constants import *
import json

from conf import *
import thread
import threading

from presenter.updateStreaming import *
from model.diffractionSimulator import *
from model.readData import *

class CSNSUserInfo(QtGui.QWidget):

    def __init__(self, parent=None):
        super(CSNSUserInfo, self).__init__(parent)
        self.setupUi(self)

	self.controlThread = None

    def setupUi(self, QWidget):
        self.verticalLayout = QtGui.QVBoxLayout(self)
        #self.mainGrid.setMargin(0)

	self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreafirst = QtGui.QScrollArea()
        self.scrollAreafirst.setWidgetResizable(True)
        self.scrollAreafirst.setWidget(self.first)
	
	self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreasecond = QtGui.QScrollArea()
        self.scrollAreasecond.setWidgetResizable(True)
        self.scrollAreasecond.setWidget(self.second)
	
        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollAreathird = QtGui.QScrollArea()
        self.scrollAreathird.setWidgetResizable(True)
        self.scrollAreathird.setWidget(self.third)
		
	self.splitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        self.splitter.addWidget(self.scrollAreafirst)	
        self.splitter.addWidget(self.scrollAreasecond)	
        self.splitter.addWidget(self.scrollAreathird)	
	self.splitter.setSizes([220, 220, 220])
        
	self.firstGrid = QtGui.QGridLayout(self.first)
	self.secondGrid = QtGui.QGridLayout(self.second)
	self.thirdGrid = QtGui.QGridLayout(self.third)

	#main verticalLayout
	self.GPPDLabel = QtGui.QLabel('<font color=red>GPPD</font>')
	self.GPPDLabel.setFont(QtGui.QFont("Roman times",20,QtGui.QFont.Bold))

	#first Grid
	self.userIDLabel = QtGui.QLabel('UserID: ', self.first)
        self.userIDText = QtGui.QLabel('1',self.first)

        self.proposalLabel = QtGui.QLabel('ProposalID: ', self.first)
        self.proposalText = QtGui.QLabel('2', self.first)

        self.verticalLayout.addWidget(self.GPPDLabel)
        self.verticalLayout.addWidget(self.splitter)

	#second Grid
	
	self.controllerLabel = QtGui.QLabel('Controller', self.second)
	self.controllerRightStatus = statusRightLabel('')
	self.controllerErrorStatus = statusErrorLabel('')
	self.createControllerThread()
	self.controllerThread.start()
	self.controllerStatusLabel = QtGui.QLabel('Disconnected', self.second)
	self.controllerButton = QtGui.QPushButton('Connected', self.second)	 		
	self.analyserLabel = QtGui.QLabel('Analyser', self.third)	 		
	self.analyserRightStatus = statusRightLabel('')	 		
	self.analyserErrorStatus = statusErrorLabel('')	 		
	self.createAnalyserThread()
	self.analyserThread.start()
	self.analyserStatusLabel = QtGui.QLabel('Disconnected', self.third)
	self.analyserButton = QtGui.QPushButton('Connected', self.third)	 		
	#third Grid
	with plt.xkcd():
            self.runFigure = Figure(
                (1, 1),
                dpi=150,
                facecolor='white',
                edgecolor=None,
                frameon=False,
                tight_layout=False,
                )
	    self.runCanvas = FigureCanvas(self.runFigure)
            self.runCanvas.setParent(self)

            self.runAxes = self.runFigure.add_subplot(111)
            self.runFigure.subplots_adjust(left=0.05, bottom=0.05,
                    right=0.95, top=0.95)
            self.runAxes.tick_params(axis='both', which='major',
                    labelsize=6)
            self.runAxes.get_xaxis().set_visible(False)
            self.runAxes.get_yaxis().set_visible(False)	
	self.chargeLabel = QtGui.QLabel('Proton Charge: ')
        self.chargeText = QtGui.QLabel('1.3E6 ')

        self.countsLabel = QtGui.QLabel('Neutron Counts: ')
        self.countsText = QtGui.QLabel('5.2E10 ')

        self.monitorStreaming = CSNSGlobal()
        self.startMonitor()

	_nline = 0
        self.firstGrid.addWidget(self.userIDLabel, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.userIDText, _nline, 1, 1, 1)

	_nline += 1
        self.firstGrid.addWidget(self.proposalLabel, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.proposalText, _nline, 1, 1, 1)
	
	_nline += 1
        self.secondGrid.addWidget(self.controllerLabel, _nline, 0, 1, 1)
        self.secondGrid.addWidget(self.controllerRightStatus, _nline, 1, 1, 1)
        self.secondGrid.addWidget(self.controllerErrorStatus, _nline, 1, 1, 1)
        self.secondGrid.addWidget(self.controllerStatusLabel, _nline, 2, 1, 1)
	_nline += 1
        self.secondGrid.addWidget(self.controllerButton, _nline, 2, 1, 1)

	_nline += 1
        self.secondGrid.addWidget(self.analyserLabel, _nline, 0, 1, 1)
        self.secondGrid.addWidget(self.analyserRightStatus, _nline, 1, 1, 1)
        self.secondGrid.addWidget(self.analyserErrorStatus, _nline, 1, 1, 1)
        self.secondGrid.addWidget(self.analyserStatusLabel, _nline, 2, 1, 1)
	_nline += 1
        self.secondGrid.addWidget(self.analyserButton, _nline, 2, 1, 1)

	_nline += 1
	self.thirdGrid.addWidget(
            self.chargeLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.thirdGrid.addWidget(
            self.chargeText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
	_nline += 1
        self.thirdGrid.addWidget(
            self.countsLabel,
            _nline,
            0,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
        self.thirdGrid.addWidget(
            self.countsText,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignCenter,
            )
	_nline += 1
	self.thirdGrid.addWidget(
            self.runCanvas,
            _nline,
            0,
            1,
            2,
            QtCore.Qt.AlignCenter,
            )
        self.thirdGrid.addItem(QtGui.QSpacerItem(-1, -1,
                              QtGui.QSizePolicy.Ignored,
                              QtGui.QSizePolicy.Expanding), 2, 0)

    def startMonitor(self):
        self.createStreamingThread(self.getSource())
        self.createPlotThread()

        self.streamingThread.start()
        self.plotThread.start()

    def createStreamingThread(self, sourceID):
        global CSNSThreadID
        CSNSThreadID += 1

        if sourceID == 2:
            self.streamingThread = diffractionSimulator(
                CSNSThreadID,
                3,
                './dat/gppd.dat',
                './dat/monitor.dat',
                1E6,
                1.0,
                self.monitorStreaming,
                )
        elif sourceID == 0:
            self.streamingThread = neonReceiver(
                CSNSThreadID,
                self.getIP(),
                self.getPort(),
                '/BL01/MONITOR01/PATTERN',
                1.0,
                self.monitorStreaming,
                )

        self.streamingThread.setDaemon(True)

    def createPlotThread(self):
        global CSNSThreadID
        CSNSThreadID += 1

        self.plotThread = updateStreamingMonitor(
            CSNSThreadID,
            self.runCanvas,
            self.runAxes,
            'g',
            self.monitorStreaming,
            )

        self.plotThread.setDaemon(True)

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()

    def getSource(self):
        self.sourceID = 2
        return self.sourceID

    def createControllerThread(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.controllerThread = ControllerStatusListen(CSNSThreadID, self.controllerRightStatus,self.controllerErrorStatus)
        self.controllerThread.setDaemon(True)

    def createAnalyserThread(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.analyserThread = AnalyserStatusListen(CSNSThreadID, self.analyserRightStatus,self.analyserErrorStatus)
        self.analyserThread.setDaemon(True)

class statusRightLabel(QtGui.QWidget):
    def __init__(self, text=None):
        super(self.__class__, self).__init__()
        self.text = text
	self.setMinimumSize(10,10)

    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        pen = QtGui.QPen()
        #pen.setStyle(QtGui.Qt.SquareCap)
        pen.setWidth(2)
        pen.setColor(QtCore.Qt.white)
        painter.setPen(pen)
        painter.translate(0, 13)
        line1 = QtCore.QLine(0,5,4,10)
        line2 = QtCore.QLine(4,10,10,0)
        painter.drawRect(0,0,10,10)
        painter.fillRect(0,0,10,10,QtCore.Qt.green)
        painter.drawLines(line1,line2)
        if self.text:
            painter.drawText(0, 0, self.text)
        painter.end()

class statusErrorLabel(QtGui.QWidget):
    def __init__(self, text=None):
        super(self.__class__, self).__init__()
        self.text = text
        self.setMinimumSize(10,10)

    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        pen = QtGui.QPen()
        #pen.setStyle(QtGui.Qt.SquareCap)
        pen.setWidth(2)
        pen.setColor(QtCore.Qt.white)
        painter.setPen(pen)
        painter.translate(0, 13)
        line1 = QtCore.QLine(0,0,10,10)
        line2 = QtCore.QLine(10,0,0,10)
        painter.drawRect(0,0,10,10)
        painter.fillRect(0,0,10,10,QtCore.Qt.red)
        painter.drawLines(line1,line2)
        if self.text:
            painter.drawText(0, 0, self.text)
        painter.end()

class ControllerStatusListen(threading.Thread):

    def __init__(
        self,
        threadID,
	controllerRightStatus,
	controllerErrorStatus,
        ):

        threading.Thread.__init__(self)
        self.threadID = threadID
	self.constant_run = threading.Event()
	self.controllerRightStatus = controllerRightStatus
	self.controllerErrorStatus = controllerErrorStatus
   	global CSNSControllerStatus
 
    def process(self):
        if(CSNSControllerStatus):
            self.controllerRightStatus.hide()
            self.controllerErrorStatus.show()
   	    #global CSNSControllerStatus
	    #CSNSControllerStatus = 0
        else:
            self.controllerRightStatus.show()
            self.controllerErrorStatus.hide()
   	    #global CSNSControllerStatus
	    #CSNSControllerStatus = 1

    def run(self):
        while True:
	    if not self.constant_run.isSet():
                delay = 1
                time.sleep(delay)
            	try:
        	    self.process()
            	except:
                    break
                finally:
                    pass

    def pause(self):
        self.constant_run.clear()

    def resume(self):
        self.constant_run.set()

class AnalyserStatusListen(threading.Thread):

    def __init__(
        self,
        threadID,
        analyserRightStatus,
        analyserErrorStatus,
        ):

        threading.Thread.__init__(self)
        self.threadID = threadID
        self.constant_run = threading.Event()
        self.analyserRightStatus = analyserRightStatus
        self.analyserErrorStatus = analyserErrorStatus

    def process(self):
        if(CSNSAnalyserStatus):
            self.analyserRightStatus.hide()
            self.analyserErrorStatus.show()
        else:
            self.analyserRightStatus.show()
            self.analyserErrorStatus.hide()

    def run(self):
        while True:
            if not self.constant_run.isSet():
                delay = 1
                time.sleep(delay)
                try:
                    self.process()
                except:
                    break
                finally:
                    pass

    def pause(self):
        self.constant_run.clear()

    def resume(self):
        self.constant_run.set()

