#!/usr/bin/python
# -*- coding: utf-8 -*-
# Set the QT API to PyQt4

import os
os.environ['QT_API'] = 'pyqt'
import sip

# sip.setapi("QString", 2)
# sip.setapi("QVariant", 2)
# from PyQt4.QtGui  import *

from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QWidget

# Import the console machinery from ipython

from qtconsole.rich_jupyter_widget import RichJupyterWidget
from qtconsole.inprocess import QtInProcessKernelManager
from IPython.lib import guisupport
#from IPython import QtEmbeddedKernelManager

class QIPythonWidget(RichJupyterWidget):

    """ Convenience class for a live IPython console widget. We can replace the standard banner using the customBanner argument"""

    def __init__(
        self,
        customBanner=None,
        *args,
        **kwargs
        ):
        if customBanner != None:
            self.banner = customBanner
        super(QIPythonWidget, self).__init__(*args, **kwargs)

        self.kernel_manager = kernel_manager = QtInProcessKernelManager()
        kernel_manager.start_kernel()
        kernel_manager.kernel.gui = 'qt4'
        #kernel.shell.push(kwargs)

        self.kernel_client = kernel_client = self.kernel_manager.client()
        kernel_client.start_channels()
        self.execute("%matplotlib inline")
        def stop():
            kernel_client.stop_channels()
            kernel_manager.shutdown_kernel()
            guisupport.get_app_qt4().exit()

        self.exit_requested.connect(stop)

        control = RichJupyterWidget()
        self.control = control
        control.kernel_manager = kernel_manager
        control.kernel_client = kernel_client
        control.exit_requested.connect(stop)
        #control.show()

        #guisupport.start_event_loop_qt4(guisupport.get_app_qt4())

class ConsoleWidget(QWidget):

    """ Main GUI Widget including a button and IPython Console widget inside vertical layout """

    def __init__(self, parent=None):
        super(ConsoleWidget, self).__init__(parent)
        layout = QtGui.QVBoxLayout(self)
        guiconsole = \
            QIPythonWidget(customBanner='Welcome to CSNS GPPD console (Lili YAN)!\n')

        #guisupport.start_event_loop_qt4(guisupport.get_app_qt4())
        guiconsole.set_default_style(colors='linux')
        layout.addWidget(guiconsole)
