#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from experiment import *
from histogram import *
from detector import *
from monitor import *
from model.chopperModel import *

class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.experimentPage = CSNSExperimentPage(self)
        self.histogramPage = CSNSHistogramPage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.monitorPage = CSNSMonitorPage(self)

        self.addTab(self.experimentPage, 'Experiment')
        self.addTab(self.histogramPage, 'Histogram')
        self.addTab(self.detectorPage, 'Detector')
        self.addTab(self.monitorPage, 'Monitor')

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()


