#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2017.05.11

Detector

'''

from conf.constants import *

import Queue
from canvas import *
from model.readData import *
from model.readImage import *
from model.protonSimulator import *
from presenter.updateStreaming import *
from presenter.progressBarThread import *


class CSNSExperimentPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSExperimentPage, self).__init__(parent)
        self.inQueue = Queue.Queue()
        self.outQueue = Queue.Queue()
        self.setupUi(self)
        self.minRange = 1
        self.maxRange = 60
        
	self.protonConstant = True
        self.neutronConstant = False
        self.pulseConstant = False
        
	self.middleProtonRange = 0
        self.middleNeutronRange = 0
        self.middlePluseRange = 0

    def __del__(self):

        # self.getThread.stop_event.set()
        # self.putThread.stop_event.set()

        pass

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.verticalLayout = QtGui.QVBoxLayout(self)

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.mainGrid = QtGui.QGridLayout(self.first)

        _xsize = 3
        _ysize = 0.5

        # Measurement Time

        self.timeLabel = QtGui.QLabel('Measurement Time:')
        #self.timeProgressBar = QtGui.QProgressBar(self)
        #self.timeProgressThread = updateProgressBar(121, 1, 3600)
        #self.timeProgressThread.partDone.connect(self.updateTimeProgressBar)
        #self.timeProgressThread.procDone.connect(self.fin)
        #self.timeProgressThread.start()

        # Proton Charge

        self.protonRadio = QtGui.QRadioButton()
        self.protonRadio.setChecked(True)
        self.protonLabel = QtGui.QLabel('Proton Charge:')

        self.protonCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # Neutron Counts

        self.neutronRadio = QtGui.QRadioButton()
        self.neutronLabel = QtGui.QLabel('Neutron Counts:')

        self.neutronCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        # pulse Counts

        self.pulseRadio = QtGui.QRadioButton()
        self.pulseLabel = QtGui.QLabel('Pulse Counts:')

        self.pulseCanvas = CSNSCanvas(
            self,
            _xsize,
            _ysize,
            150,
            'Proton Charge',
            'Time /ms',
            'Intensity',
            )

        self.RadioGroup = QtGui.QButtonGroup()
        self.RadioGroup.addButton(self.protonRadio)
        self.RadioGroup.addButton(self.neutronRadio)
        self.RadioGroup.addButton(self.pulseRadio)
        self.RadioGroup.buttonClicked.connect(self.RadioButtonChoose)

        # Common ProgressBar

        self.protonProgressBar = QtGui.QProgressBar(self)
	self.protonProgressThread = updateProgressBar(121, 1, 3600)
        self.protonProgressThread.partDone.connect(self.updateProtonProgressBar)
        self.protonProgressThread.procDone.connect(self.fin)
        self.protonProgressThread.start()

        self.neutronProgressBar = QtGui.QProgressBar(self)
        self.neutronProgressThread = updateProgressBar(121, 1, 360)
        self.neutronProgressThread.partDone.connect(self.updateNeutronProgressBar)
        self.neutronProgressThread.procDone.connect(self.fin)
        self.neutronProgressThread.start()

        self.pulseProgressBar = QtGui.QProgressBar(self)
        self.pulseProgressThread = updateProgressBar(121, 1, 360)
        self.pulseProgressThread.partDone.connect(self.updatePulseProgressBar)
        self.pulseProgressThread.procDone.connect(self.fin)
        self.pulseProgressThread.start()

        _nline = 0
        self.mainGrid.addWidget(
            self.timeLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )

        _nline += 1
        self.mainGrid.addWidget(self.protonProgressBar, _nline, 2, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.neutronProgressBar, _nline, 2, 1,
                                1)
        _nline += 1
        self.mainGrid.addWidget(self.pulseProgressBar, _nline, 2, 1,
                                1)

        _nline += 1
        self.mainGrid.addWidget(self.protonRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.protonLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.protonCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.neutronRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.neutronLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.neutronCanvas, _nline, 2, 1, 1)

        _nline += 1
        self.mainGrid.addWidget(self.pulseRadio, _nline, 0, 1, 1)
        self.mainGrid.addWidget(
            self.pulseLabel,
            _nline,
            1,
            1,
            1,
            QtCore.Qt.AlignLeft,
            )
        self.mainGrid.addWidget(self.pulseCanvas, _nline, 2, 1, 1)

        self.verticalLayout.addWidget(self.scrollArea)

        self.neutronProgressBar.hide()
        self.pulseProgressBar.hide()

        # self.inQueue.join()
        # self.outQueue.join()

    def startProtonSimulator(self):
        self.putProton()
        self.getProton()
        self.startCommonProgress()

        # for i in range(int(1E6)):
        #    self.inQueue.put_nowait(i)
        #    self.inQueue.join()

    def putProton(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.putThread = protonSimulator(CSNSThreadID, self.inQueue,
                self.outQueue)

        self.putThread.setDaemon(True)
        self.putThread.start()

    def getProton(self):
        global CSNSThreadID
        CSNSThreadID += 1
        self.getThread = updateProtonCharge(CSNSThreadID,
                self.protonCanvas, self.protonCanvas.ax, 'g',
                self.outQueue)
        self.getThread.setDaemon(True)
        self.getThread.start()

    def putProtonIsAlive(self):
        try:
            return self.putThread.isAlive()
        except:
            return False

    def getProtonIsAlive(self):
        try:
            return self.getThread.isAlive()
        except:
            return False

    #def updateTimeProgressBar(self, val):
    #    self.timeProgressBar.setValue(val)
    #    perct = '{0}%'.format(val)

    def updateProtonProgressBar(self, val):
        self.protonProgressBar.setValue(val)

        perct = "{0}%".format(val)
        # self.middleProtonRange = val

    def updateNeutronProgressBar(self, val):
        self.neutronProgressBar.setValue(val)
        perct = "{0}%".format(val)

    def updatePulseProgressBar(self, val):
        self.pulseProgressBar.setValue(val)
        perct = "{0}%".format(val)

    def RadioButtonChoose(self):
        if self.protonRadio.isChecked():
            self.protonProgressBar.show()
            self.neutronProgressBar.hide()
            self.pulseProgressBar.hide()
        elif self.neutronRadio.isChecked():

            self.protonProgressBar.hide()
            self.neutronProgressBar.show()
            self.pulseProgressBar.hide()
        elif self.pulseRadio.isChecked():

            self.protonProgressBar.hide()
            self.neutronProgressBar.hide()
            self.pulseProgressBar.show()

    def startCommonProgress(self):
        global CSNSThreadID

        CSNSThreadID += 1
        self.protonProgressThread = updateProgressBar(CSNSThreadID, 1,
                60)
        self.protonProgressThread.partDone.connect(self.updateProtonProgressBar)
        self.protonProgressThread.procDone.connect(self.fin)
        self.protonProgressThread.start()

        CSNSThreadID += 1
        self.neutronProgressThread = updateProgressBar(CSNSThreadID, 1,
                600)
        self.neutronProgressThread.partDone.connect(self.updateNeutronProgressBar)
        self.neutronProgressThread.procDone.connect(self.fin)
        self.neutronProgressThread.start()

        CSNSThreadID += 1
        self.pulseProgressThread = updateProgressBar(CSNSThreadID, 1,
                100)
        self.pulseProgressThread.partDone.connect(self.updatePulseProgressBar)
        self.pulseProgressThread.procDone.connect(self.fin)
        self.pulseProgressThread.start()

    def fin(self):
        #print self.rightSplitter.sizes()
        pass


