#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from chopper import *
from sample import *
from calibration import *
from reduction import *
from experiment import *
from histogram import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent=None):
        super(CSNSMainTab, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.chopperPage = CSNSChopperPage(self)
        self.samplePage = CSNSSamplePage(self)
        self.experimentPage = CSNSExperimentPage(self)
        self.histogramPage = CSNSHistogramPage(self)
        self.calibrationPage = CSNSCalibrationPage(self)
        self.reductionPage = CSNSReductionPage(self)

        self.addTab(self.chopperPage, 'Chopper')
        self.addTab(self.samplePage, 'Sample')
        self.addTab(self.experimentPage, 'Experiment')
        self.addTab(self.histogramPage, 'Histogram')
        self.addTab(self.calibrationPage, 'Calibration')
        self.addTab(self.reductionPage, 'Reduction')

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()
 
    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()
