#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.10
'''
import numpy as np
from PyQt4 import QtCore, QtGui
import patternDock
import patternDock1
from model import jsonArray
#import subprocess
#try:
#    import pyscreenshot as ImageGrab
#except:
#    pass

class CSNSPatternPage(QtGui.QMainWindow):

    def __init__(self, parent):
        super(CSNSPatternPage, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):  # QTabWidget):
        self.patternDock=[]
        self.patternDock.append(patternDock1.patternDock(self,
                1, 9, 0.4, 'r', 4000, 'Backward Bank'))
        self.patternDock.append(patternDock.patternDock(self,
                2, 9, 0.4, 'g', 3000, 'Medium-Angle Bank'))
        self.patternDock.append(patternDock.patternDock(self,
                3, 9, 0.4, 'b', 2000, 'Low-Angle Bank'))

        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[0])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[1])
        self.addDockWidget(QtCore.Qt.LeftDockWidgetArea,
                           self.patternDock[2])
        
        #self.setCentralWidget(self.scrollArea)
        self.pix = []
        for i in range(len(self.patternDock)):
            self.pix.append('') 

        self.pattern1 = 0
        self.pattern2 = 0
        self.pattern3 = 0

    def getPatternCanvas(self, n):
        return self.patternDock[n].getCanvas()
    
    def setStatus(self):
        return self.parent.setStatus()
    
    def getHistogramData(self):
        self.parent.getHistogramData()

    def clearCanvas(self):
        for i in range(len(self.patternDock)):
            self.patternDock[i].canvas.ax.clear()
            self.patternDock[0].canvas.draw()

    def saveData(self, redisServer, num, runNo, path):
        path1 = '/GPPD/workspace/MantidData/group'+str(num).zfill(2)+'/raw/d'
        path2 = '/GPPD/workspace/MantidData/group'+str(num).zfill(2)+'/raw/intensity'
        _x=redisServer.get(path1)
        _y=redisServer.get(path2)
        if _x is not None and _y is not None:
            #_name = path + '/pattern' + str(4-num) +'.png'
            #self.patternDock[3-num].canvas.fig.savefig(_name)
            try:
                _x = jsonArray.jsonDecoder(_x)
                _y = jsonArray.jsonDecoder(_y)
                ff=open(path+"/bank"+str(4-num)+".dat",'w')
                for i in range(len(_x)):
                    ff.write("%f %f\n" % (_x[i], _y[i]))

                ff.close()
            except:
                pass 

    def updateCanvas(self,redisServer, runNo, _command, num, value):#, started, _command): 
        try:
            '''
            if _command == 'stop':
                #path = "/home/gppd/RUN"+str(runNo).zfill(7)
                path = "/home/gppd/Desktop/RUN"+str(runNo).zfill(7)
                _cmd = "mkdir -p " + path
                subprocess.check_output(_cmd, shell=True)
                if num == 1 and self.pattern1 == 0:
                    self.saveData(redisServer, num, runNo, path)        
                    self.pattern1 = 1
                elif num == 2 and self.pattern2 == 0:
                    self.saveData(redisServer, num, runNo, path)        
                    self.pattern2 = 1
                elif num == 3 and self.pattern3 == 0:
                    self.saveData(redisServer, num, runNo, path)        
                    self.pattern3 = 1
                    
            else:
            '''
            if num == 1:
                self.updateCanvas3(value)
            elif num == 2:
                self.updateCanvas2(value)
            elif num == 3:
                self.updateCanvas1(value)
        except:
            pass

    def updateCanvas1(self, value):
        canvas = self.patternDock[0].canvas
        _pause = self.patternDock[0].pauseButton.text()
        if _pause == 'Pause':
            #try:
            if str(value[1]) == 'clear':
                pass
            elif len(value[0]) != len(value[1]) or len(value[1]) == 0:
                pass
            else:
                canvas.ax.clear()
                self.pix[0], = canvas.ax.plot(value[0], value[1], color=canvas.plotColor)
                canvas.ax.add_patch(canvas.rect)
                if canvas.zoomSelected and (canvas.minX != canvas.maxX) and (canvas.minY != canvas.maxY):
                    canvas.ax.set_xlim(canvas.minX, canvas.maxX)
                    canvas.ax.set_ylim(canvas.minY, canvas.maxY) 
                index = self.patternDock[0].getIndex()
                if index == 0:
                    canvas.ax.set_xlabel('TOF / us')
                else:
                    canvas.ax.set_xlabel('d')
                canvas.ax.set_ylabel('Neutron Counts')
                
                xIndex = self.patternDock[0].xComboBox.currentIndex()
                if xIndex == 0:
                    canvas.ax.set_xscale('linear')
                else:
                    canvas.ax.set_xscale('log')
                yIndex = self.patternDock[0].yComboBox.currentIndex()
                if yIndex == 0:
                    canvas.ax.set_yscale('linear')
                else:
                    canvas.ax.set_yscale('log')

                canvas.ax.relim()
                canvas.ax.autoscale_view()
                canvas.draw()
            #except:
            #    pass

    def updateCanvas2(self, value):
        canvas = self.patternDock[1].canvas
        _pause = self.patternDock[1].pauseButton.text()
        if _pause == 'Pause':
            #try:
            if str(value[1]) == 'clear':
                pass
            elif len(value[0]) != len(value[1]) or len(value[1]) == 0:
                pass
            else:
                canvas.ax.clear()
                self.pix[1], = canvas.ax.plot(value[0], value[1], color=canvas.plotColor)
                canvas.ax.add_patch(canvas.rect)
                if canvas.zoomSelected and (canvas.minX != canvas.maxX) and (canvas.minY != canvas.maxY):
                    canvas.ax.set_xlim(canvas.minX, canvas.maxX)
                    canvas.ax.set_ylim(canvas.minY, canvas.maxY) 
                index = self.patternDock[1].getIndex()
                if index == 0:
                    canvas.ax.set_xlabel('TOF / us')
                else:
                    canvas.ax.set_xlabel('d')
                canvas.ax.set_ylabel('Neutron Counts')
                
                xIndex = self.patternDock[1].xComboBox.currentIndex()
                if xIndex == 0:
                    canvas.ax.set_xscale('linear')
                else:
                    canvas.ax.set_xscale('log')
                yIndex = self.patternDock[1].yComboBox.currentIndex()
                if yIndex == 0:
                    canvas.ax.set_yscale('linear')
                else:
                    canvas.ax.set_yscale('log')

                canvas.ax.relim()
                canvas.ax.autoscale_view()
                canvas.draw()
            #except:
            #    pass

    def updateCanvas3(self, value):
        canvas = self.patternDock[2].canvas
        _pause = self.patternDock[2].pauseButton.text()
        if _pause == 'Pause':
            #try:
            if str(value[1]) == 'clear':
                #canvas.ax.clear()
                #canvas.draw()
                pass
            elif len(value[0]) != len(value[1]) or len(value[1]) == 0:
                pass
            else:
                canvas.ax.clear()
                self.pix[2], = canvas.ax.plot(value[0], value[1], color=canvas.plotColor)
                canvas.ax.add_patch(canvas.rect)
                if canvas.zoomSelected and (canvas.minX != canvas.maxX) and (canvas.minY != canvas.maxY):
                    canvas.ax.set_xlim(canvas.minX, canvas.maxX)
                    canvas.ax.set_ylim(canvas.minY, canvas.maxY) 
                elif canvas.scale_factor != 1.0:
                    canvas.ax.set_xlim([canvas.xdata - canvas.new_width * (1-canvas.relx), canvas.xdata + canvas.new_width * (canvas.relx)])
                    canvas.ax.set_ylim([canvas.ydata - canvas.new_height * (1-canvas.rely), canvas.ydata + canvas.new_height * (canvas.rely)])

                index = self.patternDock[2].getIndex()
                if index == 0:
                    canvas.ax.set_xlabel('TOF / us')
                else:
                    canvas.ax.set_xlabel('d')
                canvas.ax.set_ylabel('Neutron Counts')

                xIndex = self.patternDock[2].xComboBox.currentIndex()
                if xIndex == 0:
                    canvas.ax.set_xscale('linear')
                else:
                    canvas.ax.set_xscale('log')
                yIndex = self.patternDock[2].yComboBox.currentIndex()
                if yIndex == 0:
                    canvas.ax.set_yscale('linear')
                else:
                    canvas.ax.set_yscale('log')

                canvas.ax.relim()
                canvas.ax.autoscale_view()
                canvas.draw()
            #except:
                #pass
