from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64

class workerObject(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    
    def __init__(self, parent=None, *args,**kwargs):
        super(self.__class__, self).__init__(parent)

        for kwarg in kwargs:
            if kwarg == 'neonServer':
                self.neonServer= kwargs[kwarg]
            elif kwarg == 'neonPath': 
                self.neonPath= kwargs[kwarg]
            elif kwarg == 'refreshTime': 
                self.refreshTime= kwargs[kwarg]
      
        try:
            type(self.refreshTime)
        except:
            self.refreshTime=5
 
        self.command=True
        self.mylist=["configure", "start", "stop", "pause", "abort"]

    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command: break
            try:
                i=random.randint(0,4)
                self.signalStatus.emit(self.mylist[i])
            except:
                continue

            time.sleep(self.refreshTime) 
        self.finished.emit()            

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command
import io
class protonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(object)
    signalImage = QtCore.pyqtSignal(object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, neonServer, neonPath, neonBank01PID, refreshTime):
        super(self.__class__, self).__init__()

        self.neonServer= neonServer
        self.neonPath= neonPath
        self.neonBank01PID = neonBank01PID
        self.refreshTime = refreshTime

        self.started=True

    def pause(self):
        self.started=False

    @QtCore.pyqtSlot()
    def process(self):
        _json_data=None 
        _json_im=None 
        _im =None
        while True:
            if not self.started:break
            _json_im = self.neonServer.get(self.neonBank01PID)
            print _json_im
            _json_im = cStringIO.StringIO(_json_im)
            #_data_im.seek(0)
            #_data_im=base64.b64encode(_json_im.buf)
            print "y/n:", Image.isImageType(_json_im)
            _im = Image.open(_json_im)
            print _im

            try:
                _json_data = self.neonServer.get(self.neonPath)
            except:
                pass

            if _json_data is None:
                self.signalLog.emit("Empty proton data")
            else:
                try:
                    _array = jsonArray.jsonDecoder(_json_data)
                    self.signalStatus.emit(_array)
                except:
                    self.signalLog.emit("Incompleted proton data")

            if _im is None:
                self.signalLog.emit("Empty bank01 image")
            else:
                self.signalImage.emit(_im)

            time.sleep(self.refreshTime)
        self.finished.emit()

    def set(self, value):
        self.started=value

    def get(self):
        return self.started


class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()
