from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64
import numpy

class workerObject(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    
    def __init__(self, parent=None, *args,**kwargs):
        super(self.__class__, self).__init__(parent)

        for kwarg in kwargs:
            if kwarg == 'neonServer':
                self.neonServer= kwargs[kwarg]
            elif kwarg == 'neonPath': 
                self.neonPath= kwargs[kwarg]
            elif kwarg == 'refreshTime': 
                self.refreshTime= kwargs[kwarg]
      
        try:
            type(self.refreshTime)
        except:
            self.refreshTime=0.3
 
        self.command=True
        self.mylist=["configure", "start", "stop", "pause", "abort"]

    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command: break
            try:
                i=random.randint(0,4)
                self.signalStatus.emit(self.mylist[i])
            except:
                continue

            time.sleep(self.refreshTime) 
        self.finished.emit()            

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command
#import io
class getNeonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(object)
    signalMonitor = QtCore.pyqtSignal(object)
    signalExperiment = QtCore.pyqtSignal(object,object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, neonServer, protonPath, neutronPath, pulsePath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.protonPath = protonPath
        self.neutronPath = neutronPath
        self.pulsePath = pulsePath
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0
        self.monitorTOFPath = '/GPPD/workspace/MantidData/monitor02/tof'
        self.monitorCountsPath = '/GPPD/workspace/MantidData/monitor02/counts'
        self.monitorTOF=[]

    def pause(self):
        self.started=False

    @QtCore.pyqtSlot()
    def process(self):
        try:
            _data = self.neonServer.get(self.monitorTOFPath)
        except:
            pass
        if _data is None:
            self.signalLog.emit("Empty Monitor Data!")
        else:
            try:
                _data = jsonArray.jsonDecoder(_data)
                self.monitorTOF=_data
            except:
                self.signalLog.emit("Incompleted Monitor data")

        while True:
            if not self.started:break 
            try:
                _data = self.neonServer.get(self.monitorCountsPath)
                _proton = self.neonServer.get(self.protonPath)
                _neutron = self.neonServer.get(self.neutronPath)
                _pulse = self.neonServer.get(self.pulsePath)
            except:
                pass
            if _data is None:
                self.signalLog.emit("Empty Monitor Data!")
            else:
                try:
                    _data = jsonArray.jsonDecoder(_data)
                    self.signalMonitor.emit(_data)
                except:
                    self.signalLog.emit("Incompleted Monitor data")
            if _proton is None:
                self.signalLog.emit("Empty Proton Charge Data!")
            else:
                try:
                    _proton = jsonArray.jsonDecoder(_proton)
                except:
                    self.signalLog.emit("Incompleted Proton Charge  data")
            if _neutron is None:
                self.signalLog.emit("Empty Neutron Counts Data!")
            else:
                try:
                    _neutron = jsonArray.jsonDecoder(_neutron)
                except:
                    self.signalLog.emit("Incompleted Neutron Counts data")
            if _pulse is None:
                self.signalLog.emit("Empty Pulse Counts Data!")
            else:
                try:
                    _pulse = jsonArray.jsonDecoder(_pulse)
                except:
                    self.signalLog.emit("Incompleted Pulse Counts data")

            try:
                self.signalExperiment.emit(_proton[1], _neutron[1])
            except:
                pass

            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass
            
            if self.tabIndex == 1:
                try:
                    _data = self.neonServer.get(self.kwargs['path1'])
                except:
                    pass
                if _data is None:
                    self.signalLog.emit("Empty bank data: ")
                else:
                    try:
                        #bank_data = cStringIO.StringIO(_data)
                        #_img= Image.open(bank_data)
                        #bank_data=numpy.fromstring(_data, numpy.uint8).reshape(1200,750,3)
                        _data=jsonArray.jsonDecoder(_data)
                        _img=Image.fromarray(_data, "RGB")
                        self.signalStatus.emit(_img)
                    except:
                        self.signalLog.emit("Incompleted bank data")
            elif self.tabIndex == 3:
                _array = []
                _array.append(_proton)
                _array.append(_neutron)
                _array.append(_pulse)
                try:
                    self.signalStatus.emit(_array)
                except:
                    pass
            else:
                value = []
                for key in self.kwargs: 
                    _array = []
                    if key=='tabIndex':
                        pass
                    else:
                        try:
                            for j in range(len(self.kwargs[key])): 
                                _data = self.neonServer.get(self.kwargs[key][j])
                                if _data is None:
                                    self.signalLog.emit("Empty Canvas Data!")
                                else:
                                    try:
                                        _data = jsonArray.jsonDecoder(_data)
                                        _array.append(_data)
                                    except:
                                        self.signalLog.emit("Incompleted Canvas data")
                            value.append(_array)
                        except:
                            pass
                try:
                    self.signalStatus.emit(value)
                    time.sleep(2)
                except:
                    pass

            time.sleep(self.refreshTime)
        self.finished.emit()

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def setImgPath(self, value):
        self.imgpath=value

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getImgPath(self):
        return self.imgpath

    def getDataPath(self):
        return self.kwargs

    def getTabIndex(self):
        return self.tabIndex

    def getMonitorTOF(self):
        return self.monitorTOF

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()
