#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from PyQt4 import Qt

# for user defined

from experiment import *
from histogram import *
from detector import *
from monitor import *
from model.chopperModel import *


class CSNSMainTab(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSMainTab, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, QTabWidget):

        # self.main_tab = QtGui.QTabWidget(self.main_vertical)

        self.histogramPage = CSNSHistogramPage(self)
        self.detectorPage = CSNSDetectorPage(self)
        self.monitorPage = CSNSMonitorPage(self)
        self.experimentPage = CSNSExperimentPage(self)

        self.addTab(self.histogramPage, 'Diffraction Pattern')
        self.addTab(self.detectorPage, 'Detector Counts')
        self.addTab(self.monitorPage, 'Monitor Counts')
        self.addTab(self.experimentPage, 'Experiment Progress')

        self.currentChanged.connect(self.tabChange)

    def updateDiffractionSimulator(self):
        self.histogramPage.startDiffractionSimulator()

    def updateDataStreaming(self):
        self.histogramPage.startDataStreaming()

    def updateProton(self, threadID):
        self.experimentPage.startProtonSimulator()

    # diffraction Pattern 
    def getPatternCanvas(self, n):
        return self.histogramPage.getPatternCanvas(n)

    # detector Counts
    def getBankCanvas(self):
	return self.detectorPage.getBankCanvas()

    # monitor Counts
    def getMonitorImageCanvas(self, n): 
	return self.monitorPage.getMonitorImageCanvas(n)

    def getMonitorPatternCanvas(self, n): 
	return self.monitorPage.getMonitorPatternCanvas(n)

    # experiment Progress
    def getProtonCanvas(self):
	return self.experimentPage.getProtonCanvas()

    def getNeutronCanvas(self):
	return self.experimentPage.getNeutronCanvas()

    def getPulseCanvas(self):
	return self.experimentPage.getPulseCanvas()

    def getIP(self):
        return self.parent.getIP()

    def getPort(self):
        return self.parent.getPort()

    def setImgPath(self,value):
        self.parent.setImgPath(value)
        self.tabChange()
        
    def getImgPath(self):
        return self.detectorPage.getImgPath()

    def tabChange(self):
        groupTOFPath = []
        groupCountsPath = []
        bankPath = []
        monitorAxisXPath = []
        monitorAxisYPath = []
        monitorValuePath = []
        monitorTOFPath = []
        monitorCountsPath = []
        protonPath = []
        neutronPath = []
        pulsePath = []
        tabIndex = self.currentIndex()

        if tabIndex == 0:
            ngroup = 3
            i=1
            for i in range(ngroup+1):
                groupTOFPath.append('/GPPD/workspace/data/group'+str(i).zfill(2)+'/tof')
                groupCountsPath.append('/GPPD/workspace/data/group'+str(i).zfill(2)+'/counts')
            
            kwargs = {"tabIndex": tabIndex, "path1": groupTOFPath, "path2": groupCountsPath}
        elif tabIndex == 1:
            bankPath = self.getImgPath()
            kwargs = {'tabIndex': tabIndex, 'path1': bankPath}
        elif tabIndex == 2:
            nmonitor = 3
            for i in range(nmonitor+1):
                monitorAxisXPath.append('/GPPD/workspace/data/monitor'+str(i).zfill(2)+'/axis_x')
                monitorAxisYPath.append('/GPPD/workspace/data/monitor'+str(i).zfill(2)+'/axis_y')
                monitorValuePath.append('/GPPD/workspace/data/monitor'+str(i).zfill(2)+'/value')
                monitorTOFPath.append('/GPPD/workspace/data/monitor'+str(i).zfill(2)+'/tof')
                monitorCountsPath.append('/GPPD/workspace/data/monitor'+str(i).zfill(2)+'/counts')
            kwargs = {"tabIndex": tabIndex, "path1": monitorAxisXPath, "path2": monitorAxisYPath, "path3": monitorValuePath, "path4": monitorTOFPath,"path5": monitorCountsPath}
        elif tabIndex == 3:
            protonPath='/GPPD/workspace/protoncharge'
            neutronPath='/GPPD/workspace/neutroncounts'
            pulsePath='/GPPD/workspace/pulsecounts'
            kwargs = {"tabIndex": tabIndex, "path1": protonPath, "path2": neutronPath, "path3": pulsePath}
        
        self.parent.setDataPath(kwargs)


