from PyQt4 import QtGui, QtCore
import sys
import random
import time
import json
from model import jsonArray
import cStringIO
from PIL import Image
import base64

class workerObject(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(str)
    
    def __init__(self, parent=None, *args,**kwargs):
        super(self.__class__, self).__init__(parent)

        for kwarg in kwargs:
            if kwarg == 'neonServer':
                self.neonServer= kwargs[kwarg]
            elif kwarg == 'neonPath': 
                self.neonPath= kwargs[kwarg]
            elif kwarg == 'refreshTime': 
                self.refreshTime= kwargs[kwarg]
      
        try:
            type(self.refreshTime)
        except:
            self.refreshTime=0.3
 
        self.command=True
        self.mylist=["configure", "start", "stop", "pause", "abort"]

    def pause(self):
        self.command=False
    
    @QtCore.pyqtSlot()
    def process(self):
        while True:
            if not self.command: break
            try:
                i=random.randint(0,4)
                self.signalStatus.emit(self.mylist[i])
            except:
                continue

            time.sleep(self.refreshTime) 
        self.finished.emit()            

    def set(self, command):
        self.command=command
    
    def get(self):
        return self.command
import io
class getNeonData(QtCore.QObject):
    finished = QtCore.pyqtSignal()
    signalStatus = QtCore.pyqtSignal(object)
    signalLog = QtCore.pyqtSignal(str)

    def __init__(self, parent, neonServer, protonPath, neutronPath, pulsePath, refreshTime):
        super(self.__class__, self).__init__()
        self.parent = parent
        self.neonServer = neonServer
        self.refreshTime = refreshTime
        self.started = True
        self.imgpath = None
        self.kwargs = {}
        self.tabIndex = 0

    def pause(self):
        self.started=False

    @QtCore.pyqtSlot()
    def process(self):

        while True:
            if not self.started:break 
            try:
                self.tabIndex = self.kwargs['tabIndex']
            except:
                pass

            if self.tabIndex == 1:
                try:
                    _data = self.neonServer.get(self.kwargs['path1'])
                    print "222", self.kwargs['path1']
                except:
                    pass
                if _data is None:
                    self.signalLog.emit("Empty bank data: ")
                else:
                    try:
                        bank_data = cStringIO.StringIO(_data)
                        _img= Image.open(bank_data)
                        self.signalStatus.emit(_img)
                    except:
                        self.signalLog.emit("Incompleted bank data")
            elif self.tabIndex == 3:
                i = 0
                for key in self.kwargs:
                    if key=='tabIndex':
                        pass
                    else:
                        _data = self.neonServer.get(self.kwargs[key])
                        if _data is None:
                                self.signalLog.emit("Empty Canvas Data!")
                        else:
                            try:
                                _array[i] = jsonArray.jsonDecoder(_data)
                            except:
                                self.signalLog.emit("Incompleted Canvas data")
                    i+=1 
                self.signalStatus.emit(_array)
            else:
                i = 0
                _array = []
                for key in self.kwargs: 
                    if key=='tabIndex':
                        pass
                    else:
                        for j in range(len(self.kwargs[key])): 
                            _data = self.neonServer.get(self.kwargs[key][j])
                            print "111", self.kwargs[key][j]
                            if _data is None:
                                self.signalLog.emit("Empty Canvas Data!")
                            else:
                                try:
                                    _array[i][j] = jsonArray.jsonDecoder(_data)
                                except:
                                    self.signalLog.emit("Incompleted Canvas data")
                    i+=1
                #try:
                #    self.signalStatus.emit(_array)
                #except:
                #    pass

            '''
            _neonPath=self.getImgPath()
            if _neonPath is None: pass

            try:
                bank_data = self.neonServer.get(_neonPath)
            except:
                pass

            if bank_data is None:
                    self.signalLog.emit("Empty bank data: ")
            else:
                try:
                    bank_data = cStringIO.StringIO(bank_data)
                    bank_img= Image.open(bank_data)
                    self.signalDetector.emit(bank_img)
                except:
                    self.signalLog.emit("Incompleted bank data")
            '''
            time.sleep(self.refreshTime)
        self.finished.emit()

    def set(self, value):
        self.started=value

    def get(self):
        return self.started

    def setImgPath(self, value):
        self.imgpath=value

    def setDataPath(self, kwargs):
        self.kwargs = kwargs

    def getImgPath(self):
        return self.imgpath

    def getDataPath(self):
        return self.kwargs

    def getTabIndex(self):
        return self.tabIndex

class workerThread(QtCore.QThread):
    def __init__(self, parent):
        super(workerThread, self).__init__(parent)

    def __del__(self):
        self.wait()
