#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2015.10.26

Calibration

'''

from conf import *
from canvas import *
from model.readData import *
from model.readImage import *

import random

class CSNSCalibrationPage(QtGui.QTabWidget):

    def __init__(self, parent):
        super(CSNSCalibrationPage, self).__init__(parent)
        self.setupUi(self)

    def setupUi(self, QTabWidget):
        self.setTabPosition(QTabWidget.West)

        # main  grid

        self.verticalLayout = QtGui.QVBoxLayout(self)

        first = QtGui.QFrame(self)
        first.setFrameShape(QtGui.QFrame.StyledPanel)
        scrollArea = QtGui.QScrollArea()
        scrollArea.setWidgetResizable(True)
        scrollArea.setWidget(first)

        self.verticalLayout.addWidget(scrollArea)

        self.mainGrid = QtGui.QGridLayout(first)

        # Background

        _xsize = 9
        _ysize = 0.8

        # Background

        self.BackLabel = QtGui.QLabel('Bank')
        self.BackComboBox = QtGui.QComboBox()
        self.BackComboBox.addItem('0:Left Backward')
        self.BackComboBox.addItem('1:Right Backward')
        self.BackComboBox.addItem('2:Left Medium')
        self.BackComboBox.addItem('3:Right Medium')
        self.BackComboBox.addItem('4:Left Small')
        self.BackComboBox.addItem('5:Right Small')

        self.LoadButton = QtGui.QPushButton('Load')
        self.LoadButton.clicked.connect(self.load_file)        
        self.ExportButton = QtGui.QPushButton('Export')
        self.ExportButton.clicked.connect(self.export_file)        

        self.BackCanvas = CSNSCanvas(
            self,
            _xsize, 
            _ysize,
            150,
            'Backward Bank',
            'X',
            'Y',
            )

        self.filexy = ['img/XY ++.png', 'img/XT +-.png']
        
        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[1], 1, 1)

        self.BackImage1 = \
            self.BackCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.PuBu, zorder=2, alpha=0.5)

        #self.filexy = ['img/XY ++.png', 'img/XY +-.png']

        (self.dataxyX, self.dataxyY, self.dataxyZ) = \
            CSNSReadImage2Matrix(self.filexy[0], 1, 1)
        self.BackImage2 = \
            self.BackCanvas.ax.pcolormesh(self.dataxyY,
                self.dataxyX, self.dataxyZ, cmap=cm.Reds, zorder=1)

        self.maskListWidget = QtGui.QListWidget(self)  
        #self.maskListWidget.setMinimumWidth(70)
        #self.maskListWidget.setMaximumWidth(150)
        for i in range(100):
            _item = QtGui.QListWidgetItem(str(i), self.maskListWidget)
            #_item.setFlags(QtCore.Qt.ItemIsUserCheckable)
            _r=random.random()
            if _r <0.22:
                _item.setCheckState(QtCore.Qt.Unchecked)
            else:
                 _item.setCheckState(QtCore.Qt.Checked)
            self.maskListWidget.addItem(_item)

        _nline = 0
        self.mainGrid.addWidget(self.BackComboBox, _nline, 0, 1, 1)
        self.mainGrid.addWidget(self.BackLabel,_nline, 4, 1, 1, QtCore.Qt.AlignCenter)
        self.mainGrid.addWidget(self.LoadButton, _nline, 8, 1, 1)
        self.mainGrid.addWidget(self.ExportButton, _nline, 9, 1, 1)
        _nline += 1
        self.mainGrid.addWidget(self.BackCanvas, _nline, 0, 1, 8)
        self.mainGrid.addWidget(self.maskListWidget, _nline, 8, 1, 2)

    def load_file(self):
        fileName = QtGui.QFileDialog.getOpenFileName(self, 'Open File')
        file = open(fileName,'r')

        with file:
            maskData = file.read()
            #clear 
            self.maskListWidget.clear()
            #add load data
            str_split = maskData.split('\n')
            for i in range(len(str_split)):
                _item = QtGui.QListWidgetItem(str_split[i], self.maskListWidget)
                _r=random.random()
                if _r <0.22:
                    _item.setCheckState(QtCore.Qt.Unchecked)
                else:
                     _item.setCheckState(QtCore.Qt.Checked)
                self.maskListWidget.addItem(_item)

    def export_file(self):
        filePath = QtGui.QFileDialog.getSaveFileName(self,'Save File','/opt/shared/home/yanll/GPPDfly/src/dat/maskData.txt')
        
        if len(filePath) > 0:
            with open(filePath, 'w') as theFile:
                for i in xrange(self.maskListWidget.count()):
                    if self.maskListWidget.item(i).checkState() == QtCore.Qt.Checked:
                        theFile.write(''.join([str(self.maskListWidget.item(i).text()),
                                           '\n']))
