#!/bin/bash

# Usage: $0 RUN_NUMBER. Example: $0 RUN0000001

set -u
RUN="$1"

source ./conf.sh

logPath="~/irods_transfer"
retries=3
restartFile="$logPath/restartfile"
lfRestartFile="$logPath/lfrestartfile"
errorLog="$logPath/error.log"
log="$logPath/log.log"
putComOption="-KrTf -X $restartFile --retries $retries --lfrestart $lfRestartFile"

mkdir -p "$logPath"
#echo "$putComOption"

#Upload to raw backup

# Control for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Control/$RUN"
targetPath="$backupRawdataPrefix/BL01/Control/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Detector for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Detector/$RUN"
targetPath="$backupRawdataPrefix/BL01/Detector/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 histogram for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Histogram/Monitor1/$RUN"
targetPath="$backupRawdataPrefix/BL01/Monitor/Histogram/Monitor1/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 event for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Event/Monitor1/$RUN"
targetPath="$backupRawdataPrefix/BL01/Monitor/Event/Monitor1/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor2 histogram for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Histogram/Monitor2/$RUN"
targetPath="$backupRawdataPrefix/BL01/Monitor/Histogram/Monitor2/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor2 event for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Event/Monitor2/$RUN"
targetPath="$backupRawdataPrefix/BL01/Monitor/Event/Monitor2/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor3 histogram for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Histogram/Monitor3/$RUN"
targetPath="$backupRawdataPrefix/BL01/Monitor/Histogram/Monitor3/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor3 event for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Event/Monitor3/$RUN"
targetPath="$backupRawdataPrefix/BL01/Monitor/Event/Monitor3/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Note: BL02 has only one monitr: Monitor1

# Upload to NeXus backup
sourcePathPrefix=/opt/CSNSDATA/nexus/TS1   # TODO: need to be edited
sourcePath="$sourcePathPrefix/BL01/$RUN"
targetPath="$backupNexusdataPrefix/BL01/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

###### Upload to user data #######

# Control for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Control/$RUN"
targetPath="$userRawdataPrefix/BL01/Control/"
echo input -R "$userResc" --acl "read $bl01admin" "$putComOption" "$sourcePath" "$targetPath"

# Detector for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Detector/$RUN"
targetPath="$userRawdataPrefix/BL01/Detector/"
echo input -R "$userResc" --acl "read $bl01admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 histogram for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Histogram/Monitor1/$RUN"
targetPath="$userRawdataPrefix/BL01/Monitor/Histogram/Monitor1/"
echo input -R "$userResc" --acl "read $bl01admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 event for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Event/Monitor1/$RUN"
targetPath="$userRawdataPrefix/BL01/Monitor/Event/Monitor1/"
echo input -R "$userResc" --acl "read $bl01admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor2 histogram for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Histogram/Monitor2/$RUN"
targetPath="$userRawdataPrefix/BL01/Monitor/Histogram/Monitor2/"
echo input -R "$userResc" --acl "read $bl01admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor2 event for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Event/Monitor2/$RUN"
targetPath="$userRawdataPrefix/BL01/Monitor/Event/Monitor2/"
echo input -R "$userResc" --acl "read $bl01admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor3 histogram for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Histogram/Monitor3/$RUN"
targetPath="$userRawdataPrefix/BL01/Monitor/Histogram/Monitor3/"
echo input -R "$userResc" --acl "read $bl01admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor3 event for BL01
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL01/Monitor/Event/Monitor3/$RUN"
targetPath="$userRawdataPrefix/BL01/Monitor/Event/Monitor3/"
echo input -R "$userResc" --acl "read $bl01admin" "$putComOption" "$sourcePath" "$targetPath"

# Note: BL02 has only one monitr: Monitor1

# Upload to NeXus
sourcePathPrefix=/opt/CSNSDATA/nexus/TS1   # TODO: need to be edited
sourcePath="$sourcePathPrefix/BL01/$RUN"
targetPath="$userNexusdataPrefix/BL01/"
owner="taoj"
echo input -R "$userResc" --acl "read $bl01admin;read $owner" "$putComOption" "$sourcePath" "$targetPath"

