#!/bin/bash

set -e
source ./icat_server.conf

# Find Facility
#resp=$($curl ''$url'/icat/entityManager?sessionId='$sessionId'&query=SELECT%20f.id%20FROM%20Facility%20f%20WHERE%20f.name%3D'\''CSNS'\''')
#resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=SELECT%20f.id%20FROM%20Facility%20f%20WHERE%20f.name%3D'CSNS'")
query="SELECT f.id FROM Facility f WHERE f.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
csnsId=$(echo $resp | python -c "import sys, json; print json.load(sys.stdin)[0]")
echo $csnsId

# Find FacilityCycle
query="SELECT f.id FROM FacilityCycle f WHERE f.facility.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
csnsId=$(echo $resp | python -c "import sys, json; print json.load(sys.stdin)[0]")
echo $csnsId

# Find Instrument
query="SELECT f.name, f.id FROM Instrument f WHERE f.facility.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
# resp is a array [[name, id],[name, id]]
echo $resp | python -c "exec(\"import sys, json;\narray=json.load(sys.stdin);\nfor item in array: print item[0],':',item[1];\")"

# Find DatafileFormat
query="SELECT f.name, f.id FROM DatafileFormat f WHERE f.facility.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
# resp is a array [[name, id],[name, id]]
echo $resp | python -c "import sys, json; print json.load(sys.stdin)[0][0]"

# Find User
query="SELECT f.name, f.id FROM User f"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
# resp is a array [[name, id],[name, id]]
echo $resp | python -c "exec(\"import sys, json;\narray=json.load(sys.stdin);\nfor item in array: print item[0],':',item[1];\")"

# Find InvestigationType
query="SELECT f.name, f.id FROM InvestigationType f WHERE f.facility.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
# resp is a array [[name, id],[name, id]]
echo $resp | python -c "import sys, json; print json.load(sys.stdin)[0][1]"

# Find DatasetType
query="SELECT f.name, f.id FROM DatasetType f WHERE f.facility.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
# resp is a array [[name, id],[name, id]]
echo $resp | python -c "exec(\"import sys, json;\narray=json.load(sys.stdin);\nfor item in array: print item[0],':',item[1];\")"

# Find ParameterType
query="SELECT f.name, f.id FROM ParameterType f WHERE f.facility.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
# resp is a array [[name, id],[name, id]]
echo $resp | python -c "exec(\"import sys, json;\narray=json.load(sys.stdin);\nfor item in array: print item[0],':',item[1];\")"

# Find SampleType
query="SELECT f.name, f.id FROM SampleType f WHERE f.facility.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
# resp is a array [[name, id],[name, id]]
echo $resp | python -c "exec(\"import sys, json;\narray=json.load(sys.stdin);\nfor item in array: print item[0],':',item[1];\")"

# Find Investigation
query="SELECT f.name, f.id FROM Investigation f WHERE f.facility.name='CSNS'"
encoded=$(python -c "import sys, urllib; print urllib.quote(\"${query}\")")
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=$encoded")
# resp is a array [[name, id],[name, id]]
echo $resp | python -c "exec(\"import sys, json;\narray=json.load(sys.stdin);\nfor item in array: print item[0],':',item[1];\")"
